package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.consts.ChangeStatusConst;
import com.ejianc.business.plan.service.*;
import com.ejianc.business.plan.vo.BudgetDetailTemVO;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.business.utils.CheckUtil;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("budgetPlanChange")
public class BudgetPlanChangeBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBudgetPlanChangeService budgetPlanChangeService;

    @Autowired
    private IBudgetPlanService budgetPlanService;
    @Autowired
    private IBudgetDetailService budgetDetailService;

    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;

    @Autowired
    private IBudgetPlanItemChangeService budgetPlanItemChangeService;


    @Autowired
    private IBudgetPlanRecordService budgetPlanRecordService;

    @Autowired
    private IBudgetPlanItemRecordService budgetPlanItemRecordService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetPlanChangeEntity changeEntity = budgetPlanChangeService.getById(billId);
        QueryParam p = new QueryParam();
        p.getParams().put("plan_id", new Parameter(QueryParam.EQ, billId));
        List<BudgetPlanItemChangeEntity> budgetPlanItemChangeEntities = budgetPlanItemChangeService.queryList(p);


        Long id = changeEntity.getChangeId();
        //审核完后回写
        //查询原计划
        BudgetPlanEntity plan = budgetPlanService.getById(id);
        QueryParam param = new QueryParam();
        param.getParams().put("plan_id", new Parameter(QueryParam.EQ, plan.getId()));
        List<BudgetPlanItemEntity> planItemEntities = budgetPlanItemService.queryList(param);

        //更新变更到原计划
        if (CollectionUtils.isNotEmpty(budgetPlanItemChangeEntities)) {
            List<BudgetPlanItemEntity> newItemEntities = new ArrayList<>();
            Map<String, BudgetPlanItemEntity> oldMap = planItemEntities.stream().collect(Collectors.toMap(k -> k.getDetailId() + k.getYyearMonth(), (k) -> k));
            budgetPlanItemChangeEntities.forEach(t -> {
                String key = t.getDetailId() + t.getYyearMonth();
                BudgetPlanItemEntity budgetPlanItemEntity = oldMap.get(key);
                if (budgetPlanItemEntity != null) {
                    budgetPlanItemEntity.setPlanNum(t.getPlanNum());
                    budgetPlanItemEntity.setPlanRatio(t.getPlanRatio());
                    newItemEntities.add(budgetPlanItemEntity);
                } else {
                    t.setId(null);
                    t.setPlanId(plan.getId());
                    t.setVersion(null);
                    newItemEntities.add(BeanMapper.map(t, BudgetPlanItemEntity.class));
                }
            });
            budgetPlanItemService.saveOrUpdateBatch(newItemEntities);

            Long budgetId = changeEntity.getBudgetId();
            QueryWrapper<BudgetDetailEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("budget_id",budgetId);
            wrapper.ne("change_type",5);
            List<BudgetDetailEntity> list = budgetDetailService.list(wrapper);
            Map<Long, BudgetDetailEntity> checkMap = list.stream().collect(Collectors.toMap(k -> k.getId(), (k) -> k));
            List<Long> removes = new ArrayList<>();
            planItemEntities.forEach(item->{
                if(checkMap.get(item.getDetailId()) == null){
                    removes.add(item.getId());
                }else if(changeEntity.getEndMonth().compareTo(item.getYyearMonth()) < 0){
                    removes.add(item.getId());
                }
            });

            if (removes.size() > 0) {
                budgetPlanItemService.removeByIds(removes);
            }
        }

        //回写记录
        BudgetPlanRecordEntity rec = BeanMapper.map(plan, BudgetPlanRecordEntity.class);
        rec.setId(null);
        budgetPlanRecordService.saveOrUpdate(rec);
        if (CollectionUtils.isNotEmpty(planItemEntities)) {
            planItemEntities.forEach(t -> {
                        t.setId(null);
                        t.setPlanId(rec.getId());
                        t.setVersion(null);
                    }
            );
            List<BudgetPlanItemRecordEntity> budgetPlanItemRecordEntities = BeanMapper.mapList(planItemEntities, BudgetPlanItemRecordEntity.class);
            budgetPlanItemRecordService.saveOrUpdateBatch(budgetPlanItemRecordEntities);
        }



        plan.setChangeStatus(ChangeStatusConst.CHANGED);
        plan.setChangeId(billId);
        plan.setEndMonth(changeEntity.getEndMonth());
        plan.setMonthEndDate(changeEntity.getMonthEndDate());
        plan.setChangeCode(changeEntity.getBillCode());
        budgetPlanService.updateById(plan);

        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error("施工计划变更单暂不支持回退功能!");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
