package com.ejianc.business.utils;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemChangeEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.service.IBudgetPlanItemChangeService;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.vo.BudgetTemVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.math.BigDecimal;
import java.util.*;

/**
 * 校验工具类
 */
@Component
public class CheckUtil {

    @Autowired
    private IBudgetDetailService budgetDetailService;

    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;

    @Autowired
    private IBudgetPlanItemChangeService budgetPlanItemChangeService;

    @Autowired
    private IBudgetPlanService budgetPlanService;

    private static CheckUtil checkUtil;

    @PostConstruct
    public void init() {
        checkUtil = this;
        checkUtil.budgetDetailService = this.budgetDetailService;
        checkUtil.budgetPlanItemService = this.budgetPlanItemService;
        checkUtil.budgetPlanItemChangeService = this.budgetPlanItemChangeService;
        checkUtil.budgetPlanService = this.budgetPlanService;
    }

    // 获取两个yyyy-mm格式的中间所有月份
    public static List<String> getAllMonth(String startMonth,String endMonth) {
        List<String> monthSets = new ArrayList<>();
        monthSets.add(startMonth);
        while (true){
            if(startMonth.equals(endMonth)){
                break;
            }
            Integer begin = Integer.parseInt(startMonth.substring(0, 4));
            Integer end = Integer.parseInt(startMonth.substring(5, 7));
            if(end == 12){
                begin += 1;
                end = 1;
            }else{
                end += 1;
            }
            startMonth = ""+begin+"-"+(end < 10 ? "0"+end : end);
            monthSets.add(startMonth);
        }
        return monthSets;
    }

    public static CommonResponse createPlanItem(Long planId,Long budgetId,String startMonth,String endMonth){
        List<String> allMonth = getAllMonth(startMonth, endMonth);
        // 预算3级明细
        QueryWrapper<BudgetDetailEntity> budgetDetailQueryWrapper = new QueryWrapper<>();
        budgetDetailQueryWrapper.eq("budget_id",budgetId);
        budgetDetailQueryWrapper.eq("level_no",3);
        List<BudgetDetailEntity> budgetDetailEntities = checkUtil.budgetDetailService.list(budgetDetailQueryWrapper);
        Set<Long> details = new HashSet<>();
        budgetDetailEntities.forEach(item->{
            details.add(item.getId());
        });

        QueryWrapper<BudgetPlanItemEntity> budgetPlanItemQueryWrapper = new QueryWrapper<>();
        budgetPlanItemQueryWrapper.eq("plan_id",planId);
        budgetPlanItemQueryWrapper.eq("leaf_level",3);
        List<BudgetPlanItemEntity> budgetPlanItemEntities = checkUtil.budgetPlanItemService.list(budgetPlanItemQueryWrapper);
        List<BudgetPlanItemEntity> newList = new ArrayList<>();
        Map<Long,BudgetPlanItemEntity> level3Map = new HashMap<>();
        budgetPlanItemEntities.forEach(item->{
            level3Map.put(item.getDetailId(),item);
        });
        details.forEach(item->{
            if(null == level3Map.get(item)){
                allMonth.forEach(month->{
                    BudgetPlanItemEntity entity = new BudgetPlanItemEntity();
                    entity.setPlanId(planId);
                    entity.setDetailId(item);
                    entity.setLeafFlag(1);
                    entity.setLeafLevel(3);
                    entity.setYyearMonth(month);
                    newList.add(entity);
                });
            }
        });
        if(newList.size()>0){
            checkUtil.budgetPlanItemService.saveOrUpdateBatch(newList);
        }
        return CommonResponse.success();
    }

    /**
     * 验证新增计划，变更计划时，所有楼号是否都已编辑。
     * @param flag 1新增 2变更
     * @param planId  非必传 如果调用处可直接获取传递，反之通过budgetId获取。
     * @param budgetId
     * @return
     */
    public static List<String> CheckAllBuilding(int flag, Long planId, Long budgetId) {

        // 如planId未传递，通过budgetId获取
        if(null == planId){
            QueryWrapper<BudgetPlanEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("budget_id",budgetId);
            List<BudgetPlanEntity> list = checkUtil.budgetPlanService.list(queryWrapper);
            planId = list.get(0).getId();
        }

        List<String> budgetBuildingNos = new ArrayList<>();
        List<String> planBuildingNos = new ArrayList<>();
        // 获取预算的明细
        QueryWrapper<BudgetDetailEntity> budgetDetailQueryWrapper = new QueryWrapper<>();
        budgetDetailQueryWrapper.eq("budget_id",budgetId);
        budgetDetailQueryWrapper.eq("level_no",1);
        List<BudgetDetailEntity> budgetDetailEntities = checkUtil.budgetDetailService.list(budgetDetailQueryWrapper);
        for (BudgetDetailEntity entity:budgetDetailEntities
        ) {
            budgetBuildingNos.add(entity.getBuildingNo());
        }

        // 用于保存预算的明细id 该属性复用，每次使用完会重置。
        Set<Long> detailIds = new HashSet<>();
        if(flag == 1){
            // 获取该计划的明细 该属性复用，每次使用完会重置。
            QueryWrapper<BudgetPlanItemEntity> budgetPlanItemQueryWrapper = new QueryWrapper<>();
            budgetPlanItemQueryWrapper.eq("plan_id",planId);
            List<BudgetPlanItemEntity> budgetPlanItemEntities = checkUtil.budgetPlanItemService.list(budgetPlanItemQueryWrapper);
            for (BudgetPlanItemEntity entity:budgetPlanItemEntities
            ) {
                detailIds.add(entity.getDetailId());
            }
        }else if(flag == 2){
            QueryWrapper<BudgetPlanItemChangeEntity> budgetPlanItemChangeEntityQueryWrapper = new QueryWrapper<>();
            budgetPlanItemChangeEntityQueryWrapper.eq("dr",0);
            budgetPlanItemChangeEntityQueryWrapper.eq("plan_id",planId);
            List<BudgetPlanItemChangeEntity> list = checkUtil.budgetPlanItemChangeService.list(budgetPlanItemChangeEntityQueryWrapper);
            for (BudgetPlanItemChangeEntity entity:list
            ) {
                detailIds.add(entity.getDetailId());
            }
        }
        budgetDetailEntities.clear();
        if(detailIds.size() > 0){
            budgetDetailQueryWrapper = new QueryWrapper<>();
            budgetDetailQueryWrapper.in("id",detailIds);
            budgetDetailEntities = checkUtil.budgetDetailService.list(budgetDetailQueryWrapper);
        }
        detailIds.clear();
        for (BudgetDetailEntity entity:budgetDetailEntities
        ) {
            detailIds.add(Long.valueOf(entity.getInnerCode().substring(0,18)));
        }
        budgetDetailEntities.clear();
        if(detailIds.size() > 0){
            budgetDetailQueryWrapper = new QueryWrapper<>();
            budgetDetailQueryWrapper.in("id",detailIds);
            budgetDetailEntities = checkUtil.budgetDetailService.list(budgetDetailQueryWrapper);
        }
        for (BudgetDetailEntity entity:budgetDetailEntities
        ) {
            planBuildingNos.add(entity.getBuildingNo());
        }

        budgetBuildingNos.removeAll(planBuildingNos);
        return budgetBuildingNos;
    }

}
