/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.vo.BudgetDetailVO;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.plan.bean.BudgetInfoEntity;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.service.IBudgetInfoService;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/budget/"})
public class BudgetApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IBudgetService budgetService;
    @Autowired
    IBudgetPlanService budgetPlanService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;
    @Autowired
    private IBudgetInfoService budgetInfoService;

    @GetMapping(value={"getLaborCostMny"})
    public CommonResponse<BigDecimal> getLaborCostMny(@RequestParam(value="projectId") Long projectId, @RequestParam(value="settleDate") String settleDate) {
        BudgetVO budgetVO;
        LambdaQueryWrapper budgetQuery = new LambdaQueryWrapper();
        budgetQuery.eq(BudgetEntity::getProjectId, (Object)projectId);
        List budgetEntities = this.budgetService.list((Wrapper)budgetQuery);
        HashMap<Long, BigDecimal> budgetMap = new HashMap<Long, BigDecimal>();
        BigDecimal totalMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)budgetEntities) && CollectionUtils.isNotEmpty((Collection)(budgetVO = this.budgetService.queryDetail(((BudgetEntity)((Object)budgetEntities.get(0))).getId(), false)).getDetailList())) {
            for (BudgetDetailVO budgetDetailVO : budgetVO.getDetailList()) {
                budgetMap.put(budgetDetailVO.getId(), budgetDetailVO.getCostPrice());
            }
        }
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        LambdaQueryWrapper budgetPlanQuery = new LambdaQueryWrapper();
        budgetPlanQuery.eq(BudgetPlanEntity::getProjectId, (Object)projectId);
        budgetPlanQuery.in(BudgetPlanEntity::getBillState, billStateList);
        List planEntities = this.budgetPlanService.list((Wrapper)budgetPlanQuery);
        this.logger.info("---------------------------------------------planEntities:" + planEntities.size());
        ArrayList<BudgetPlanItemEntity> planItemEntities = new ArrayList<BudgetPlanItemEntity>();
        QueryWrapper wr = new QueryWrapper();
        wr.eq((Object)"project_id", (Object)projectId);
        wr.orderByDesc((Object)"yyear_month");
        wr.last("limit 1");
        List infoList = this.budgetInfoService.list((Wrapper)wr);
        if (CollectionUtils.isNotEmpty((Collection)infoList)) {
            this.logger.info("info\u8868\u4e2d \u6700\u8fd1\u4e00\u6b21\u7684\u6708\u4efd\uff1a======================================" + ((BudgetInfoEntity)((Object)infoList.get(0))).getYyearMonth());
            LambdaQueryWrapper bw = new LambdaQueryWrapper();
            bw.eq(BudgetInfoEntity::getProjectId, (Object)projectId);
            bw.eq(BudgetInfoEntity::getYyearMonth, (Object)((BudgetInfoEntity)((Object)infoList.get(0))).getYyearMonth());
            List list = this.budgetInfoService.list((Wrapper)bw);
            for (BudgetInfoEntity infoEntity : list) {
                BudgetPlanItemEntity budgetPlanItemEntity = (BudgetPlanItemEntity)((Object)BeanMapper.map((Object)((Object)infoEntity), BudgetPlanItemEntity.class));
                planItemEntities.add(budgetPlanItemEntity);
            }
        }
        if (CollectionUtils.isNotEmpty(planItemEntities)) {
            for (BudgetPlanItemEntity itemEntity : planItemEntities) {
                if (!budgetMap.containsKey(itemEntity.getDetailId())) continue;
                totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)((BigDecimal)budgetMap.get(itemEntity.getDetailId())), (BigDecimal)itemEntity.getFinishNum()));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u4eba\u5de5\u6210\u672c\u6210\u529f", (Object)totalMny);
    }

    public static void main(String[] args) {
        String settleDate = "2022-04";
        String curMonth1 = "2022-08";
        int i = settleDate.compareTo(curMonth1);
        System.out.println(i);
    }

    private String getCalendar(String settleDate) {
        String ca;
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd").parse(settleDate);
            ca = new SimpleDateFormat("yyyy-MM").format(date);
        }
        catch (ParseException e) {
            throw new BusinessException("\u65e5\u671f\u8f6c\u6362\u9519\u8bef");
        }
        return ca;
    }
}

