package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.service.IBudgetChangeService;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.utils.ExcelImportUtil;
import com.ejianc.business.budget.utils.ExcelReader;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.budget.vo.BudgetDetailVO;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.enums.ChangeStatusEnum;
import com.ejianc.business.enums.ChangeTypeEnum;
import com.ejianc.business.plan.vo.BudgetCheckVO;
import com.ejianc.business.utils.BudgetCheckUtil;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.budget.mapper.BudgetMapper;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.service.IBudgetService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 预算管理
 *
 * @author generator
 */
@Service("budgetService")
public class BudgetServiceImpl extends BaseServiceImpl<BudgetMapper, BudgetEntity> implements IBudgetService {

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IBudgetDetailService budgetDetailService;

    @Autowired
    private IBudgetChangeService budgetChangeService;

    @Autowired
    private IMaterialApi materialApi;

    private static final String BILL_CODE = "PROBUDGET_BUDGET";

    @Override
    public BudgetVO insertOrUpdate(BudgetVO budgetVO) {

        checkIsOne(budgetVO.getProjectId(), budgetVO.getId());

        if (StringUtils.isEmpty(budgetVO.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                budgetVO.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BudgetEntity budgetEntity = BeanMapper.map(budgetVO, BudgetEntity.class);
        budgetEntity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        budgetEntity.setBaseIncomebudgetMny(budgetEntity.getIncomebudgetMny());
        budgetEntity.setBeforeIncomebudgetMny(budgetEntity.getIncomebudgetMny());

        budgetEntity.setBaseCostbudgetMny(budgetEntity.getCostbudgetMny());
        budgetEntity.setBeforeCostbudgetMny(budgetEntity.getCostbudgetMny());

        budgetEntity.setBaseLaborMny(budgetEntity.getLaborMny());
        budgetEntity.setBeforeLaborMny(budgetEntity.getLaborMny());

        budgetEntity.setBaseMaterialMny(budgetEntity.getMaterialMny());
        budgetEntity.setBeforeMaterialMny(budgetEntity.getMaterialMny());

        budgetEntity.setBaseManageMny(budgetEntity.getManageMny());
        budgetEntity.setBeforeManageMny(budgetEntity.getManageMny());

        budgetEntity.setBaseIncomebudgetAdjustMny(budgetEntity.getIncomebudgetAdjustMny());
        budgetEntity.setBeforeIncomebudgetAdjustMny(budgetEntity.getIncomebudgetAdjustMny());

        super.saveOrUpdate(budgetEntity, false);

        List<BudgetDetailEntity> detailEntityList = budgetEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (BudgetDetailEntity cdEntity : detailEntityList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (BudgetDetailEntity cdEntity : detailEntityList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
                //变更类型
                cdEntity.setChangeType(ChangeTypeEnum.未变更.getCode());
            }
            // 生成结构码、内码、逻辑内码
            List<Map> resultMapList = BeanMapper.mapList(detailEntityList, Map.class);
            List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);
            BudgetCheckUtil.checkWeightScale(treeData);
            List<Map<String, Object>> ListCodeDate = creatInnerCode(treeData, null);
            List<BudgetDetailEntity> entities = new ArrayList<>();
            treeToList(ListCodeDate, entities);
            budgetDetailService.saveOrUpdateBatch(entities, entities.size(), false);
        }
        return queryDetail(budgetEntity.getId(), true);
    }

    /**
     * 生成内码
     *
     * @param list
     * @param innerCode
     * @return
     */
    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> ypd = list.get(i);
            // 生成内码
            if (StringUtils.isNotEmpty(innerCode)) {
                ypd.put("innerCode", innerCode + "&&" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }

            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = creatInnerCode((List) ypd.get("children"), ypd.get("innerCode").toString());
                ypd.put("children", child);
                ypd.put("leafFlag", false);
            } else {
                ypd.put("leafFlag", true);
            }
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<BudgetDetailEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, BudgetDetailEntity.class));
        }
    }

    private void checkIsOne(Long projectId, Long budgetId) {
        LambdaQueryWrapper<BudgetEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetEntity::getProjectId, projectId);
        queryWrapper.ne(null != budgetId, BudgetEntity::getId, budgetId);
        if (CollectionUtils.isNotEmpty(list(queryWrapper))) {
            throw new BusinessException("一个项目只允许存在一份预算单");
        }
    }


    @Override
    public BudgetVO queryDetail(Long id, boolean detailHasChildren) {
        BudgetEntity budgetEntity = super.selectById(id);
        BudgetVO budgetVO = BeanMapper.map(budgetEntity, BudgetVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("budgetId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<BudgetDetailEntity> detailEntityListDb = budgetDetailService.queryList(queryParam, false);
        // 对树形重新排序 start
        List<BudgetDetailVO> budgetDetailVOS = BeanMapper.mapList(detailEntityListDb, BudgetDetailVO.class);
        budgetDetailVOS.forEach(item -> {
            Integer treeNumber = 0;
            // 进制，本次需求只考虑到两位数，进制为10的n次方。
            Integer baseSystem = 100;
            // 基数, 基数为10的n*(m-1)次方 n进制位数，m树形层数。
            Integer useNumber = 1000000;
            String treeIndex = item.getTreeIndex();
            String[] split = treeIndex.split("\\.");
            for (String s : split) {
                treeNumber += Integer.parseInt(s) * useNumber;
                useNumber = useNumber / baseSystem;
            }
            item.setTreeNumber(treeNumber);
        });
        Collections.sort(budgetDetailVOS, new Comparator<BudgetDetailVO>() {
            @Override
            public int compare(BudgetDetailVO o1, BudgetDetailVO o2) {
                return o1.getTreeNumber().compareTo(o2.getTreeNumber());
            }
        });
        detailEntityListDb = BeanMapper.mapList(budgetDetailVOS, BudgetDetailEntity.class);
        // 排序 end
        List<BudgetDetailEntity> detailEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || !ChangeTypeEnum.中止.getCode().equals(entity.getChangeType())) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (BudgetDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List<BudgetDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, BudgetDetailVO.class);
            if (detailHasChildren) {
                budgetVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            } else {
                budgetVO.setDetailList(resultMapList);
            }
        } else {
            budgetVO.setDetailList(BeanMapper.mapList(detailEntityList, BudgetDetailVO.class));
        }

        if (null != budgetEntity.getChangeVersion() && budgetEntity.getChangeVersion() > 0) {
            budgetVO.setRecordList(budgetChangeService.queryDetailRecord(budgetEntity.getId()));
        }
        return budgetVO;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Set<String> materialNameSet = new HashSet<>();
        List<BudgetCheckVO> checkVOS = new ArrayList<>();
        BudgetCheckVO checkVO;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                boolean levelFlag = false;
                boolean levelBlankFlag = false;
                int oneNo = 0;
                int twoNo = 0;
                int threeNo = 0;
                int fourNo = 0;
                Integer lastLevelNo = -1;
                String nextLevel = "1";
                Map<String, Integer> indexMap = new HashMap<>();
                List<BudgetDetailVO> detailVoList = new ArrayList<>();
                Map<String, BudgetDetailVO> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BudgetDetailVO vo = new BudgetDetailVO();
                    boolean flag = false;
                    String warnType = "";
                    StringBuffer detailIndex = new StringBuffer();
                    String buildingNo = datas.get(0);
                    String buildContent = datas.get(1);
                    String craft = datas.get(2);
                    String materialName = datas.get(9);
                    Integer levelNo = -1;
                    if (StringUtils.isNotBlank(buildingNo)) {
                        oneNo++;
                        levelNo = 1;
                        if (!nextLevel.contains(levelNo.toString())) {
                            warnType = warnType + "层级不对,";
                            flag = true;
                            levelFlag = true;
                        }
                        if (lastLevelNo == 4) {
                            twoNo = 0;
                            threeNo = 0;
                            fourNo = 0;
                        }
                        nextLevel = "2";
                        detailIndex.append(oneNo);
                        levelBlankFlag = true;
                        vo.setBuildingNo(buildingNo);
                    } else if (StringUtils.isNotBlank(buildContent)) {
                        twoNo++;
                        levelNo = 2;
                        if (!nextLevel.contains(levelNo.toString())) {
                            warnType = warnType + "层级不对,";
                            flag = true;
                            levelFlag = true;
                        }
                        if (lastLevelNo == 4) {
                            threeNo = 0;
                            fourNo = 0;
                        }
                        nextLevel = "3";
                        detailIndex.append(oneNo).append(".").append(twoNo);
                        levelBlankFlag = true;
                        vo.setBuildContent(buildContent);
                    } else if (StringUtils.isNotBlank(craft)) {
                        threeNo++;
                        levelNo = 3;
                        if (!nextLevel.contains(levelNo.toString())) {
                            warnType = warnType + "层级不对,";
                            flag = true;
                            levelFlag = true;
                        }
                        if (lastLevelNo == 4) {
                            fourNo = 0;
                        }
                        nextLevel = "4";
                        detailIndex.append(oneNo).append(".").append(twoNo).append(".").append(threeNo);
                        levelBlankFlag = true;
                        vo.setCraft(craft);
                    } else if (StringUtils.isNotBlank(materialName)) {
                        fourNo++;
                        levelNo = 4;
                        if (!nextLevel.contains(levelNo.toString())) {
                            warnType = warnType + "层级不对,";
                            flag = true;
                            levelFlag = true;
                        }
                        nextLevel = "1,2,3,4";
                        detailIndex.append(oneNo).append(".").append(twoNo).append(".").append(threeNo).append(".").append(fourNo);
                        levelBlankFlag = true;
                        materialNameSet.add(materialName.trim());
                        vo.setMaterialName(materialName);
                    }
                    lastLevelNo = levelNo;

                    vo.setTreeIndex(detailIndex.toString());
                    //维护父子关系
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    String[] split = detailIndex.toString().split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex.toString(), vo);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }

                    indexMap.put(detailIndex.toString(), i);

                    if (!levelBlankFlag) {
                        warnType = warnType + "楼号、施工内容、工艺、材料名称不能都为空,";
                        flag = true;
                    }

                    vo.setLevelNo(levelNo);

                    if (levelNo == 3) {
                        if (StringUtils.isBlank(datas.get(4))) {
                            vo.setBudgetNum(null);
                            warnType = warnType + "工程量为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setBudgetNum(new BigDecimal(datas.get(4)));
                            } catch (Exception e) {
                                vo.setBudgetNum(null);
                                warnType = warnType + "工程量只能为数字或小数,";
                                flag = true;
                            }
                        }

                        vo.setBudgetUnit(datas.get(5));//计量单位

                        if (StringUtils.isBlank(datas.get(6))) {
                            vo.setBudgetPrice(null);
                            warnType = warnType + "综合单价为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setBudgetPrice(new BigDecimal(datas.get(6)));
                            } catch (Exception e) {
                                vo.setBudgetPrice(null);
                                warnType = warnType + "综合单价只能为数字或小数,";
                                flag = true;
                            }
                        }

                        vo.setBudgetMoney(ComputeUtil.safeMultiply(vo.getBudgetNum(), vo.getBudgetPrice()));

                        if (StringUtils.isBlank(datas.get(7))) {
                            vo.setCostNum(null);
                            warnType = warnType + "成本工程量为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setCostNum(new BigDecimal(datas.get(7)));
                            } catch (Exception e) {
                                vo.setCostNum(null);
                                warnType = warnType + "成本工程量只能为数字或小数,";
                                flag = true;
                            }
                        }

                        if (StringUtils.isBlank(datas.get(8))) {
                            vo.setCostPrice(null);
                            warnType = warnType + "人工单价为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setCostPrice(new BigDecimal(datas.get(8)));
                            } catch (Exception e) {
                                vo.setCostPrice(null);
                                warnType = warnType + "人工单价只能为数字或小数,";
                                flag = true;
                            }
                        }

                        vo.setCostMoney(ComputeUtil.safeMultiply(vo.getCostNum(), vo.getCostPrice()));
                    }

                    if (levelNo == 4) {
                        if (StringUtils.isBlank(datas.get(9))) {
                            vo.setMaterialName(null);
                            warnType = warnType + "材料名称/体系为空,";
                            flag = true;
                        } else {
                            vo.setMaterialName(datas.get(9));
                        }

                        if (StringUtils.isBlank(datas.get(10))) {
                            vo.setMaterialWeightScale(null);
//                            warnType = warnType + "产值权重为空,";
//                            flag = true;
                        } else {
                            try {
                                vo.setMaterialWeightScale(ComputeUtil.safeMultiply(new BigDecimal(100), new BigDecimal(datas.get(10))));
                            } catch (Exception e) {
                                vo.setMaterialWeightScale(null);
                                warnType = warnType + "产值权重只能为数字或小数,";
                                flag = true;
                            }
                        }

                        if (StringUtils.isBlank(datas.get(11))) {
                            vo.setMaterialUsedScale(null);
//                            warnType = warnType + "产值权重为空,";
//                            flag = true;
                        } else {
                            try {
                                vo.setMaterialUsedScale(ComputeUtil.safeMultiply(new BigDecimal(100), new BigDecimal(datas.get(11))));
                            } catch (Exception e) {
                                vo.setMaterialUsedScale(null);
                                warnType = warnType + "材料使用率只能为数字或小数,";
                                flag = true;
                            }
                        }

                        if (StringUtils.isBlank(datas.get(12))) {
                            vo.setMaterialPrice(null);
                            warnType = warnType + "材料单价为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setMaterialPrice(new BigDecimal(datas.get(12)));
                            } catch (Exception e) {
                                vo.setMaterialPrice(null);
                                warnType = warnType + "材料单价只能为数字或小数,";
                                flag = true;
                            }
                        }

                        if (StringUtils.isBlank(datas.get(13))) {
                            vo.setMaterialUsedNum(null);
                            warnType = warnType + "耗量为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setMaterialUsedNum(new BigDecimal(datas.get(13)));
                            } catch (Exception e) {
                                vo.setMaterialUsedNum(null);
                                warnType = warnType + "耗量只能为数字或小数,";
                                flag = true;
                            }
                        }

                        BigDecimal parCostNum = tidMap.get(vo.getTpid()) != null ? tidMap.get(vo.getTpid()).getCostNum() : null;
                        vo.setMaterialPlanNum(ComputeUtil.safeMultiply(vo.getMaterialUsedNum(), parCostNum));
                        vo.setMaterialMoney(ComputeUtil.safeMultiply(vo.getMaterialPlanNum(), vo.getMaterialPrice()));

                        if (StringUtils.isBlank(datas.get(14))) {
                            vo.setMaterialUnit(null);
                            warnType = warnType + "材料单位为空,";
                            flag = true;
                        } else {
                            vo.setMaterialUnit(datas.get(14));
                        }
                        vo.setLeafFlag(true);
                        // 获取楼号 施工内容 工序
                        checkVO = getCheckVO(detailVoList, datas.get(9));
                        Boolean likeFlag = false;
                        for (BudgetCheckVO item : checkVOS) {
                            if (checkVO.getLevel1().equals(item.getLevel1()) && checkVO.getLevel2().equals(item.getLevel2()) && checkVO.getLevel3().equals(item.getLevel3()) && checkVO.getLevel4().equals(item.getLevel4())) {
                                warnType = warnType + "数据重复,";
                                flag = true;
                                likeFlag = true;
                                break;
                            }
                        }
                        if (!likeFlag) {
                            checkVOS.add(checkVO);
                        }
                    } else {
                        vo.setLeafFlag(false);
                    }

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (flag) {
                        warnType = warnType.substring(0, warnType.length() - 1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    vo.setChangeType(3);//增补项
                    detailVoList.add(vo);
                }

                for (BudgetDetailVO tVo : detailVoList) {
                    tVo.setTpid(tidMap.get(tVo.getTpid()) != null ? tidMap.get(tVo.getTpid()).getTid() : null);
                }

                CommonResponse<List<MaterialVO>> materialListresp = materialApi.queryMaterialListByNames(new ArrayList<>(materialNameSet));
                Map<String, MaterialVO> materialMap = null;
                if (materialListresp.isSuccess()) {
                    materialMap = materialListresp.getData().stream().collect(Collectors.toMap(MaterialVO::getName, Function.identity(), (key1, key2) -> key2));
                }

                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.dealWeightScale(deailTreeData);
                levelFlag = getLevelFlag(mapList, materialMap);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                if (levelFlag) {
                    resp.put("successList", null);
                    resp.put("successNum", 0);
                } else {
                    resp.put("successList", convertJsonToVoList(allList.get(0)));
                    resp.put("successNum", result.size() - errorList.size());
                }
                resp.put("errorList", errorList);
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    private List<BudgetDetailVO> convertJsonToVoList(List<Map<String, Object>> successList) {
        List<Map<String, Object>> success = ExcelImportUtil.treeToListNoWarn(successList);
        List<BudgetDetailVO> detailVOList = BeanMapper.mapList(success, BudgetDetailVO.class);
        return buildTreeByTid(detailVOList);
    }

    private BudgetCheckVO getCheckVO(List<BudgetDetailVO> list, String level4) {
        BudgetCheckVO budgetCheckVO = new BudgetCheckVO();
        budgetCheckVO.setLevel4(level4);
        list.forEach(item -> {
            if (item.getLevelNo() == 1) {
                budgetCheckVO.setLevel1(item.getBuildingNo());
            } else if (item.getLevelNo() == 2) {
                budgetCheckVO.setLevel2(item.getBuildContent());
            } else if (item.getLevelNo() == 3) {
                budgetCheckVO.setLevel3(item.getCraft());
            }
        });
        return budgetCheckVO;
    }

    private boolean getLevelFlag(List<Map<String, Object>> mapList, Map<String, MaterialVO> materialMap) {
        for (Map<String, Object> map : mapList) {
            List<Map<String, Object>> child = (List) map.get("children");
            if (child != null) {
                if (getLevelFlag(child, materialMap)) {
                    return true;
                }
            } else {
                if (null != map.get("materialName")) {
                    if (materialMap.containsKey(map.get("materialName"))) {
                        MaterialVO materialVO = materialMap.get(map.get("materialName"));
                        map.put("materialId", materialVO.getId());
                    } else {
                        if (!(Boolean) map.get("importFlag")) {
                            map.put("warnType", map.get("warnType") + ", 根据名称找不到对应的物资");
                        } else {
                            map.put("importFlag", false);
                            map.put("warnType", "根据名称找不到对应的物资");
                        }
                    }
                }

                if (null != map.get("warnType") && ((String) map.get("warnType")).contains("权重和不为1")) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 构建树
     *
     * @param values 需要组建树的数据List
     * @return 树的根节点
     */
    public static List<BudgetDetailVO> buildTreeByTid(List<BudgetDetailVO> values) {
        Map<String, BudgetDetailVO> nodeMap = new HashMap<>();
        List<BudgetDetailVO> result = new ArrayList<>();
        List<BudgetDetailVO> emptyValueList = new ArrayList<>();
        for (BudgetDetailVO value : values) {
            if (StringUtils.isBlank(value.getTpid())) {
                result.add(value);
            } else {
                BudgetDetailVO parentNode = nodeMap.get(value.getTpid());
                if (parentNode == null) {
                    emptyValueList.add(value);
                } else {
                    parentNode.getChildren().add(value);
                }
            }
            nodeMap.put(value.getTid(), value);
        }
        if (!emptyValueList.isEmpty()) {
            for (BudgetDetailVO value : emptyValueList) {
                BudgetDetailVO parentNode = nodeMap.get(value.getTpid());
                if (parentNode == null) {
                    result.add(value);
                } else {
                    parentNode.getChildren().add(value);
                }
            }
        }
        return result;
    }
}
