package com.ejianc.business.plan.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.vo.PlanCostVO;
import com.ejianc.business.budget.vo.PlanProfitVO;
import com.ejianc.business.equipment.api.ISettlementApi;
import com.ejianc.business.equipment.vo.SettlementVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.ProjectReimburseVO;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.history.ProjectProgressVo;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.api.IMaterialInstoreApi;
import com.ejianc.business.material.vo.InstoreAccountSumVO;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.mapper.BudgetPlanMapper;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.business.sub.api.ISubReportApi;
import com.ejianc.business.sub.vo.SubProjectSettleNumVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author songlx
 * @version 1.0
 * @description: 报表service
 * @date 2021/10/21
 */
@Service
public class PlanReportService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    BudgetPlanMapper planMapper;

    @Autowired
    IProjectApi projectApi;

    @Autowired
    ISubReportApi subReportApi;

    @Autowired
    IMaterialInstoreApi materialInstoreApi;

    @Autowired
    ISettlementApi equipSettlementApi;

    @Autowired
    IPayContractApi payContractApi;

    @Autowired
    IIncomeContractApi iIncomeContractApi;

    @Autowired
    private IOrgApi iOrgApi;


    private static BigDecimal YI_BAI = new BigDecimal("100");


    public List<PlanCostVO> loadCostList2ES(QueryParam param) {
        String currentMonth = DateUtil.getCurrentDay(DateUtil.MONTH);
        HashMap<String, Object> map = new HashMap<>();
        map.put("tenantId", InvocationInfoProxy.getTenantid());
        map.put("yyearMonth", currentMonth);
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        logger.info(">>>>>loadCostList2ES>>>>orgIds:{}", JSONObject.toJSONString(orgIds));
        map.put("orgIds", orgIds);
        List<PlanCostVO> planCostVOS = planMapper.getCost(map);
        if (CollectionUtils.isNotEmpty(planCostVOS)) {
            List<Long> projectIds = planCostVOS.stream().map(PlanCostVO::getProjectId).collect(Collectors.toList());
            CommonResponse<List<ProjectRegisterVO>> projectRes = projectApi.queryProjectByIds(projectIds);
            CommonResponse<List<SubProjectSettleNumVO>> subSettleNumRes = subReportApi.getSubSettleNum(projectIds);
            CommonResponse<List<InstoreAccountSumVO>> materialRes = materialInstoreApi.amountSum(projectIds);

            CommonResponse<List<SettlementVO>> equipMapRes = equipSettlementApi.getSettleMny(projectIds);
            CommonResponse<List<ProjectReimburseVO>> financeRes = payContractApi.getProjectReimburse(projectIds);


            Map<Long, InstoreAccountSumVO> materialMap = new HashMap<>();
            if (materialRes.isSuccess() && CollectionUtils.isNotEmpty(materialRes.getData())) {
                materialMap = materialRes.getData().stream().collect(Collectors.toMap(k -> k.getProjectId(), (k) -> k));
            }

            Map<Long, SubProjectSettleNumVO> subMap = new HashMap<>();
            if (subSettleNumRes.isSuccess() && CollectionUtils.isNotEmpty(subSettleNumRes.getData())) {
                subMap = subSettleNumRes.getData().stream().collect(Collectors.toMap(k -> k.getProjectId(), (k) -> k));
            }

            Map<Long, SettlementVO> equipmentMap = new HashMap<>();
            if (equipMapRes.isSuccess() && CollectionUtils.isNotEmpty(equipMapRes.getData())) {
                equipmentMap = equipMapRes.getData().stream().collect(Collectors.toMap(k -> k.getProjectId(), (k) -> k));
            }
            Map<Long, ProjectReimburseVO> financeMap = new HashMap<>();
            if (financeRes.isSuccess() && CollectionUtils.isNotEmpty(financeRes.getData())) {
                financeMap = financeRes.getData().stream().collect(Collectors.toMap(k -> k.getProjectId(), (k) -> k));
            }

            if (projectRes.isSuccess()) {
                List<ProjectRegisterVO> projects = projectRes.getData();
                if (CollectionUtils.isNotEmpty(projects)) {
                    Map<Long, ProjectRegisterVO> proMaps = projects.stream().collect(Collectors.toMap(k -> k.getId(), (k) -> k));

                    for (PlanCostVO c : planCostVOS) {
                        Long projectId = c.getProjectId();
                        // 周期默认放入当前月
                        c.setYyearMonth(currentMonth.substring(0, 4) + "年" + currentMonth.substring(5) + "月");

                        QueryWrapper<BudgetPlanEntity> queryWrapper = new QueryWrapper<>();
                        queryWrapper.eq("project_id", projectId);
                        queryWrapper.eq("dr", 0);
                        List<BudgetPlanEntity> budgetPlanEntities = planMapper.selectList(queryWrapper);
                        // 有计划并且计划截止月 < 当前月，取计划截止月
                        if (budgetPlanEntities.size() > 0 && budgetPlanEntities.get(0).getEndMonth().length() == 7) {
                            String endMonth = budgetPlanEntities.get(0).getEndMonth();
                            if (endMonth.compareTo(currentMonth) <= 0) {
                                c.setYyearMonth(endMonth.substring(0, 4) + "年" + endMonth.substring(5, 7) + "月");
                            }
                        }

                        ProjectRegisterVO project = proMaps.get(projectId);
                        if (project != null) {
                            c.setParentOrgId(project.getOrgId());
                            c.setParentOrgName(project.getOrgName());
                        }
                        SubProjectSettleNumVO sub = subMap.get(projectId);
                        if (sub != null) {
                            BigDecimal finishNum = sub.getFinishNum();
                            BigDecimal settleNum = sub.getSettleNum();
                            c.setCurNum(ComputeUtil.isGreaterThan(finishNum, BigDecimal.ZERO) ? finishNum : settleNum);
                            c.setSubCost(ComputeUtil.isGreaterThan(sub.getFinishMny(), BigDecimal.ZERO) ? sub.getFinishMny() : sub.getSettleMny());
                        }
                        c.setRealNum(ComputeUtil.isGreaterThan(c.getCurNum(), c.getComputeNum()) ? c.getCurNum() : c.getComputeNum());

                        InstoreAccountSumVO instoreVO = materialMap.get(projectId);
                        if (instoreVO != null) {
                            c.setMaterialCost(instoreVO.getTotalAmount());
                        }

                        SettlementVO equipVO = equipmentMap.get(projectId);
                        if (null != equipVO) {
                            c.setEquipRentCost(equipVO.getRentSettleMny());
                            c.setEquipPurchaseCost(equipVO.getPurchaseSettleMny());
                        }
                        ProjectReimburseVO projectReimburseVO = financeMap.get(projectId);
                        if (null != projectReimburseVO) {
                            c.setLoadReimburseCost(projectReimburseVO.getLoadReimburseMny());
                            c.setPayReimburseCost(projectReimburseVO.getPayReimburseMny());
                        }
                        c.setCurCost(ComputeUtil.safeAdd(c.getSubCost(), c.getMaterialCost(), c.getEquipPurchaseCost(), c.getEquipRentCost(), c.getLoadReimburseCost(), c.getPayReimburseCost()));
                        c.setComputeCost(ComputeUtil.safeAdd(c.getComputeCost(), c.getMaterialCost(), c.getEquipPurchaseCost(), c.getEquipRentCost(), c.getLoadReimburseCost(), c.getPayReimburseCost()));
                        c.setRealCost(ComputeUtil.isGreaterThan(c.getCurCost(), c.getComputeCost()) ? c.getCurCost() : c.getComputeCost());

                        c.setBudgetPrice(ComputeUtil.safeDiv(c.getPlanBudgetCost(), c.getBudgetNum()));
                        c.setRealPrice(ComputeUtil.safeDiv(c.getRealCost(), c.getRealNum()));
                        //已完工预算 本表【预算单价】*【实际工程量】
                        c.setFinishBudget(ComputeUtil.safeMultiply(c.getBudgetPrice(), c.getRealNum()));
                        // 进度差异
                        //本表【已完工预算】-【计划工作预算成本】
                        c.setPlanDiff(ComputeUtil.safeSub(c.getFinishBudget(), c.getPlanBudgetCost()));
                        //成本差异
                        //本表【已完工预算成本】-【已完工实际成本】
                        c.setCostDiff(ComputeUtil.safeSub(c.getFinishBudget(), c.getRealCost()));

                        //工期绩效
                        //本表【已完工预算】/【计划工作预算成本】
                        c.setWorkAchi(ComputeUtil.bigDecimalPercent(c.getFinishBudget(), c.getPlanBudgetCost(), 8));
                        //成本绩效
                        //本表【已完工实际成本】/【已完工预算成本】
                        c.setCostAchi(ComputeUtil.bigDecimalPercent(c.getRealCost(), c.getFinishBudget(), 8));
                        c.setProjectName(proMaps.get(c.getProjectId()).getName());
                    }
                }
            } else {
                throw new BusinessException("查询项目信息失败！");
            }
        }
        return planCostVOS;
    }

    public List<PlanProfitVO> loadProfitList2ES(QueryParam param) {

        HashMap<String, Object> map = new HashMap<>();
        map.put("tenantId", InvocationInfoProxy.getTenantid());
        map.put("yyearMonth", DateUtil.getCurrentDay(DateUtil.MONTH));
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        map.put("orgIds", orgIds);
        logger.info(">>>>>loadProfitList2ES>>>>orgIds:{}", JSONObject.toJSONString(orgIds));
        List<PlanProfitVO> planProfitVOS = planMapper.getProfit(map);
        if (CollectionUtils.isNotEmpty(planProfitVOS)) {
            List<Long> projectIds = planProfitVOS.stream().map(PlanProfitVO::getProjectId).collect(Collectors.toList());
            CommonResponse<List<ProjectRegisterVO>> projectRes = projectApi.queryProjectByIds(projectIds);
            CommonResponse<List<SubProjectSettleNumVO>> subSettleNumRes = subReportApi.getSubSettleNum(projectIds);
            CommonResponse<List<InstoreAccountSumVO>> materialRes = materialInstoreApi.amountSum(projectIds);

            CommonResponse<List<SettlementVO>> equipMapRes = equipSettlementApi.getSettleMny(projectIds);
            CommonResponse<List<ProjectReimburseVO>> financeRes = payContractApi.getProjectReimburse(projectIds);
            CommonResponse<List<ProjectProgressVo>> listCommonResponse = iIncomeContractApi.projectProgressList(projectIds);

            Map<Long, ProjectProgressVo> progressMap = new HashMap<>();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(listCommonResponse.getData())) {
                progressMap = listCommonResponse.getData().stream().collect(Collectors.toMap(k -> k.getProjectId(), (k) -> k));
            }

            Map<Long, InstoreAccountSumVO> materialMap = new HashMap<>();
            if (materialRes.isSuccess() && CollectionUtils.isNotEmpty(materialRes.getData())) {
                materialMap = materialRes.getData().stream().collect(Collectors.toMap(k -> k.getProjectId(), (k) -> k));
            }

            Map<Long, SubProjectSettleNumVO> subMap = new HashMap<>();
            if (subSettleNumRes.isSuccess() && CollectionUtils.isNotEmpty(subSettleNumRes.getData())) {
                subMap = subSettleNumRes.getData().stream().collect(Collectors.toMap(k -> k.getProjectId(), (k) -> k));
            }

            Map<Long, SettlementVO> equipmentMap = new HashMap<>();
            if (equipMapRes.isSuccess() && CollectionUtils.isNotEmpty(equipMapRes.getData())) {
                equipmentMap = equipMapRes.getData().stream().collect(Collectors.toMap(k -> k.getProjectId(), (k) -> k));
            }
            Map<Long, ProjectReimburseVO> financeMap = new HashMap<>();
            if (financeRes.isSuccess() && CollectionUtils.isNotEmpty(financeRes.getData())) {
                financeMap = financeRes.getData().stream().collect(Collectors.toMap(k -> k.getProjectId(), (k) -> k));
            }

            if (projectRes.isSuccess()) {
                List<ProjectRegisterVO> projects = projectRes.getData();
                if (CollectionUtils.isNotEmpty(projects)) {
                    Map<Long, ProjectRegisterVO> proMaps = projects.stream().collect(Collectors.toMap(k -> k.getId(), (k) -> k));

                    for (PlanProfitVO c : planProfitVOS) {
                        Long projectId = c.getProjectId();
                        ProjectRegisterVO project = proMaps.get(projectId);
                        if (project != null) {
                            c.setParentOrgId(project.getOrgId());
                            c.setParentOrgName(project.getOrgName());
                        }
                        SubProjectSettleNumVO sub = subMap.get(projectId);
                        if (sub != null) {
                            c.setSubCost(ComputeUtil.isGreaterThan(sub.getFinishMny(), BigDecimal.ZERO) ? sub.getFinishMny() : sub.getSettleMny());
                        }
                        c.setCurCost(c.getSubCost());
                        //实际人工费
                        c.setRealCost(ComputeUtil.isGreaterThan(c.getCurCost(), c.getComputeCost()) ? c.getCurCost() : c.getComputeCost());

                        InstoreAccountSumVO instoreVO = materialMap.get(projectId);
                        if (instoreVO != null) {
                            c.setMaterialCost(instoreVO.getTotalAmount());
                        }

                        SettlementVO equipVO = equipmentMap.get(projectId);
                        if (null != equipVO) {
                            c.setEquipRentCost(equipVO.getRentSettleMny());
                            c.setEquipPurchaseCost(equipVO.getPurchaseSettleMny());
                        }
                        ProjectReimburseVO projectReimburseVO = financeMap.get(projectId);
                        if (null != projectReimburseVO) {
                            c.setLoadReimburseCost(projectReimburseVO.getLoadReimburseMny());
                            c.setPayReimburseCost(projectReimburseVO.getPayReimburseMny());
                        }
                        //实际管理费
                        c.setRealManageMny(ComputeUtil.safeAdd(c.getEquipPurchaseCost(), c.getEquipRentCost(), c.getLoadReimburseCost(), c.getPayReimburseCost()));

                        //计划净利润
                        c.setPlanProfit(ComputeUtil.bigDecimalPercent(ComputeUtil.safeSub(c.getIncomebudgetMny(), c.getCostbudgetMny(), c.getTaxFee()), c.getIncomebudgetMny(), 8));


                        if (null != project.getStatus() && "3".equals(project.getStatus())) {
                            ProjectProgressVo projectProgressVo = progressMap.get(projectId);
                            c.setProductionMny(projectProgressVo.getOutputMoney());
                        }
                        c.setProjectName(proMaps.get(c.getProjectId()).getName());

                        //实际税金
                        c.setRealTaxFee(ComputeUtil.safeDiv(ComputeUtil.safeMultiply(c.getProductionMny(), c.getTaxRatio()), YI_BAI));

                        //实际净利润
                        c.setRealProfit(ComputeUtil.bigDecimalPercent(ComputeUtil.safeSub(c.getProductionMny(), c.getRealCost(), c.getRealManageMny(), c.getMaterialCost(), c.getRealTaxFee()), c.getProductionMny(), 8));

                        //首次计划利润
                        c.setBasePlanProfit(ComputeUtil.bigDecimalPercent(ComputeUtil.safeSub(c.getBaseIncomebudgetMny(), c.getBaseCostbudgetMny()), c.getBaseIncomebudgetMny(), 8));
                        c.setBasePlanProfitTxt(ComputeUtil.scaleTwo(ComputeUtil.safeSub(c.getBaseIncomebudgetMny(), c.getBaseCostbudgetMny())).toString() + "/" + ComputeUtil.scaleTwo(c.getBaseIncomebudgetMny()));

                    }
                }
            } else {
                throw new BusinessException("查询项目信息失败！");
            }
        }
        return planProfitVOS;
    }


    public static void main(String[] args) {
        System.out.println((12195482.78 - 4977536.39 - 277806.41 - 3308082.09 - 611262.05) / 12195482.78);
    }
}
