package com.ejianc.business.budget.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.vo.BudgetDetailVO;
import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.plan.bean.BudgetInfoEntity;
import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.bean.BudgetPlanItemEntity;
import com.ejianc.business.plan.service.IBudgetInfoService;
import com.ejianc.business.plan.service.IBudgetPlanItemService;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/budget/")
public class BudgetApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IBudgetService budgetService;

    @Autowired
    IBudgetPlanService budgetPlanService;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IBudgetPlanItemService budgetPlanItemService;


    @Autowired
    private IBudgetInfoService budgetInfoService;

    @GetMapping(value = "getLaborCostMny")
    public CommonResponse<BigDecimal> getLaborCostMny(@RequestParam("projectId") Long projectId, @RequestParam("settleDate") String settleDate) {
        LambdaQueryWrapper<BudgetEntity> budgetQuery = new LambdaQueryWrapper<>();
        budgetQuery.eq(BudgetEntity::getProjectId, projectId);
        List<BudgetEntity> budgetEntities = budgetService.list(budgetQuery);
        Map<Long, BigDecimal> budgetMap = new HashMap<>();
        BigDecimal totalMny = BigDecimal.ZERO;
        if(CollectionUtils.isNotEmpty(budgetEntities)){
            BudgetVO budgetVO = budgetService.queryDetail(budgetEntities.get(0).getId(), false);
            if(CollectionUtils.isNotEmpty(budgetVO.getDetailList())){
                for(BudgetDetailVO budgetDetailVO : budgetVO.getDetailList()){
                    budgetMap.put(budgetDetailVO.getId(), budgetDetailVO.getCostPrice());
                }
            }
        }
        //只查询审批通过的施工计划
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        LambdaQueryWrapper<BudgetPlanEntity> budgetPlanQuery = new LambdaQueryWrapper<>();
        budgetPlanQuery.eq(BudgetPlanEntity::getProjectId, projectId);
        budgetPlanQuery.in(BudgetPlanEntity:: getBillState,billStateList);
        List<BudgetPlanEntity> planEntities = budgetPlanService.list(budgetPlanQuery);
        logger.info("---------------------------------------------planEntities:"+planEntities.size());
        List<BudgetPlanItemEntity> planItemEntities = new ArrayList<>();
        /*if(CollectionUtils.isNotEmpty(planEntities)){
            logger.info("该项目有施工计划，查询施工计划-------------------------------------");
            LambdaQueryWrapper<BudgetPlanItemEntity> pw = new LambdaQueryWrapper<>();
            pw.eq(BudgetPlanItemEntity::getPlanId, planEntities.get(0).getId());
            String curMonth1 = getCalendar(settleDate);
            *//*String endDay1 = planEntities.get(0).getMonthEndDate() != null ? planEntities.get(0).getMonthEndDate() : "31";
            String _endMonthDate1 = curMonth1 + "-" + endDay1;*//*
            QueryWrapper<BudgetPlanItemEntity> wr = new QueryWrapper<>();
            wr.eq("plan_id",planEntities.get(0).getId());
            wr.orderByDesc("yyear_month");
            wr.last("limit 1");
            List<BudgetPlanItemEntity> infoList = budgetPlanItemService.list(wr);
            logger.info("最近一次计划日期------------------------------："+infoList.get(0).getYyearMonth());
            // 如果计划截止月份小于结算时间，则取截止月份数据
            String endMonth = planEntities.get(0).getEndMonth();
            if(curMonth1.compareTo(infoList.get(0).getYyearMonth()) > 0){
                pw.eq(BudgetPlanItemEntity::getYyearMonth, endMonth);
            }else{
                pw.eq(BudgetPlanItemEntity::getYyearMonth, curMonth1);
            }

            *//*if(endMonth.compareTo(curMonth1) < 0){
                pw.eq(BudgetPlanItemEntity::getYyearMonth, endMonth);
            }else{
                if (_endMonthDate1.compareTo(settleDate) >= 0) {
                    pw.eq(BudgetPlanItemEntity::getYyearMonth, curMonth1);
                } else {
                    //如果截止日期今天之前,那说明当前月是在下月
                    String nextMonth = DateUtil.format(DateUtil.minusMonths(-1), DateUtil.MONTH);
                    pw.eq(BudgetPlanItemEntity::getYyearMonth, nextMonth);
                }
            }*//*
            planItemEntities = budgetPlanItemService.list(pw);
            logger.info("施工计划明细：--------------------------------"+planItemEntities.size());
        } else {*/
            //logger.info("该项目没有施工计划，查询info表============================================");
            QueryWrapper<BudgetInfoEntity> wr = new QueryWrapper<>();
            wr.eq("project_id",projectId);
            wr.orderByDesc("yyear_month");
            wr.last("limit 1");
            List<BudgetInfoEntity> infoList = budgetInfoService.list(wr);
            if(CollectionUtils.isNotEmpty(infoList)){
                logger.info("info表中 最近一次的月份：======================================"+infoList.get(0).getYyearMonth());
                LambdaQueryWrapper<BudgetInfoEntity> bw = new LambdaQueryWrapper<>();
                bw.eq(BudgetInfoEntity::getProjectId,projectId);
                bw.eq(BudgetInfoEntity::getYyearMonth,infoList.get(0).getYyearMonth());
                List<BudgetInfoEntity> list = budgetInfoService.list(bw);
                for (BudgetInfoEntity infoEntity : list) {
                    BudgetPlanItemEntity budgetPlanItemEntity = BeanMapper.map(infoEntity,BudgetPlanItemEntity.class);
                    planItemEntities.add(budgetPlanItemEntity);
                }
            }

        //}
        if(CollectionUtils.isNotEmpty(planItemEntities)){
            for(BudgetPlanItemEntity itemEntity : planItemEntities){
                if(budgetMap.containsKey(itemEntity.getDetailId())){
                    totalMny = ComputeUtil.safeAdd(totalMny, ComputeUtil.safeMultiply(budgetMap.get(itemEntity.getDetailId()), itemEntity.getFinishNum()));
                }
            }
        }
        return CommonResponse.success("查询人工成本成功", totalMny);
    }

    public static void main(String[] args) {
        String settleDate = "2022-04";
        String curMonth1 = "2022-08";
        int i = settleDate.compareTo(curMonth1);
        System.out.println(i);
    }

    private String getCalendar(String settleDate){
        String ca;
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd").parse(settleDate );
            ca = new SimpleDateFormat("yyyy-MM").format(date);
        } catch (ParseException e) {
            throw new BusinessException("日期转换错误");
        }
        return ca;
    }
}
