package com.ejianc.business.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.bean.BudgetChangeDetailEntity;
import com.ejianc.business.budget.bean.BudgetChangeEntity;
import com.ejianc.business.budget.bean.BudgetDetailEntity;
import com.ejianc.business.budget.bean.BudgetEntity;
import com.ejianc.business.budget.service.IBudgetChangeDetailService;
import com.ejianc.business.budget.service.IBudgetDetailService;
import com.ejianc.business.budget.service.IBudgetService;
import com.ejianc.business.budget.utils.ExcelImportUtil;
import com.ejianc.business.budget.utils.ExcelReader;
import com.ejianc.business.budget.utils.TreeNodeBUtil;
import com.ejianc.business.budget.vo.*;
import com.ejianc.business.enums.ChangeStatusEnum;
import com.ejianc.business.enums.ChangeTypeEnum;
import com.ejianc.business.plan.vo.BudgetCheckVO;
import com.ejianc.business.utils.BudgetCheckUtil;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.budget.mapper.BudgetChangeMapper;
import com.ejianc.business.budget.service.IBudgetChangeService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 预算变更
 *
 * @author generator
 */
@Service("budgetChangeService")
public class BudgetChangeServiceImpl extends BaseServiceImpl<BudgetChangeMapper, BudgetChangeEntity> implements IBudgetChangeService {

    private static final String BILL_CODE = "PROBUDGET_CHANGE";

    @Autowired
    private IMaterialApi materialApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IBudgetService budgetService;

    @Autowired
    private IBudgetChangeDetailService budgetChangeDetailService;

    @Autowired
    private IBudgetDetailService budgetDetailService;

    @Override
    public BudgetChangeVO insertOrUpdate(BudgetChangeVO changeVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        BudgetChangeEntity entity = null;
        List<BudgetEntity> entitiesc = null;
        List<BudgetChangeEntity> entities = null;

        //变更合同只能存在一条未生效的
        LambdaQueryWrapper<BudgetChangeEntity> lambdachange = Wrappers.<BudgetChangeEntity>lambdaQuery();
        lambdachange.eq(BudgetChangeEntity::getTenantId, tenantId);
        lambdachange.eq(BudgetChangeEntity::getBudgetId, changeVO.getBudgetId());
        if (changeVO.getId() != null && changeVO.getId() > 0) {
            lambdachange.ne(BudgetChangeEntity::getId, changeVO.getId());
        }
        lambdachange.ne(BudgetChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(BudgetChangeEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if (num > 0) {
            throw new BusinessException("该预算已存在未生效的变更单!");
        }
        if (StringUtils.isEmpty(changeVO.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                changeVO.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if (changeVO.getId() != null && changeVO.getId() > 0) {
            //修改 校验合同编号唯一，变更单除去本单，采购合同  同时唯一
            LambdaQueryWrapper<BudgetChangeEntity> lambda = Wrappers.<BudgetChangeEntity>lambdaQuery();
            lambda.eq(BudgetChangeEntity::getBillCode, changeVO.getBillCode());
            lambda.eq(BudgetChangeEntity::getTenantId, tenantId);
            lambda.ne(BudgetChangeEntity::getBudgetId, changeVO.getBudgetId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, changeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, changeVO.getBudgetId()));
            entitiesc = budgetService.queryList(queryParam, false);

        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<BudgetChangeEntity> lambda = Wrappers.<BudgetChangeEntity>lambdaQuery();
            lambda.eq(BudgetChangeEntity::getTenantId, tenantId);
            lambda.eq(BudgetChangeEntity::getBillCode, changeVO.getBillCode());
            lambda.ne(BudgetChangeEntity::getBudgetId, changeVO.getBudgetId());
            entities = super.list(lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, changeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, changeVO.getBudgetId()));
            entitiesc = budgetService.queryList(queryParam, false);
        }

        if (entities != null && entities.size() > 0 && entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        BudgetChangeEntity BudgetChangeEntity = BeanMapper.map(changeVO, BudgetChangeEntity.class);
        //保存前清空主键和父主键，重新生成
        List<BudgetChangeDetailEntity> beforeDetails = BudgetChangeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == BudgetChangeEntity.getId()) {
            for (BudgetChangeDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        super.saveOrUpdate(BudgetChangeEntity, false);

        List<BudgetChangeDetailEntity> changeDetailEntities = BudgetChangeEntity.getDetailList();
        List<BudgetDetailVO> budgetDetailVOS = budgetService.queryDetail(changeVO.getBudgetId(), false).getDetailList();
        Map<Long, BudgetDetailVO> budgetDetailVOMap = budgetDetailVOS.stream().collect(Collectors.toMap(BudgetDetailVO::getId, Function.identity(), (key1, key2) -> key2));
        if (CollectionUtils.isNotEmpty(changeDetailEntities)) {
            Map<String, Long> idMap = new HashMap<>();
            for (BudgetChangeDetailEntity cdEntity : changeDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
                BudgetDetailVO budgetDetailVO = budgetDetailVOMap.get(cdEntity.getSrcBid());
                if (budgetDetailVO != null) {
                    cdEntity.setBeforeBudgetMoney(budgetDetailVO.getBudgetMoney());
                    cdEntity.setBeforeBudgetNum(budgetDetailVO.getBudgetNum());
                    cdEntity.setBeforeBudgetPrice(budgetDetailVO.getBudgetPrice());
                    cdEntity.setBeforeBudgetUnit(budgetDetailVO.getBudgetUnit());

                    cdEntity.setBeforeCostMoney(budgetDetailVO.getCostMoney());
                    cdEntity.setBeforeCostNum(budgetDetailVO.getCostNum());
                    cdEntity.setBeforeCostPrice(budgetDetailVO.getCostPrice());

                    cdEntity.setBeforeMaterialMoney(budgetDetailVO.getMaterialMoney());
                    cdEntity.setBeforeMaterialPlanNum(budgetDetailVO.getMaterialPlanNum());
                    cdEntity.setBeforeMaterialPrice(budgetDetailVO.getMaterialPrice());
                    cdEntity.setBeforeMaterialUnit(budgetDetailVO.getMaterialUnit());
                    cdEntity.setBeforeMaterialUsedNum(budgetDetailVO.getMaterialUsedNum());
                    cdEntity.setBeforeMaterialUsedScale(budgetDetailVO.getMaterialUsedScale());
                    cdEntity.setBeforeMaterialWeightScale(budgetDetailVO.getMaterialWeightScale());
                }
            }
            for (BudgetChangeDetailEntity cdEntity : changeDetailEntities) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            // 生成结构码、内码、逻辑内码
            List<Map> resultMapList = BeanMapper.mapList(changeDetailEntities, Map.class);
            List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);
            BudgetCheckUtil.checkWeightScale(treeData);
            List<Map<String, Object>> ListCodeDate = creatInnerCode(treeData, null);
            List<BudgetChangeDetailEntity> saveEntities = new ArrayList<>();
            treeToList(ListCodeDate, saveEntities);
            budgetChangeDetailService.saveOrUpdateBatch(saveEntities, saveEntities.size(), false);
        }

        saveWriteContract(BudgetChangeEntity);

        return queryDetail(BudgetChangeEntity.getId());
    }

    /**
     * 生成内码
     *
     * @param list
     * @param innerCode
     * @return
     */
    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> ypd = list.get(i);
            // 生成内码
            if (StringUtils.isNotEmpty(innerCode)) {
                ypd.put("innerCode", innerCode + "&&" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }

            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = creatInnerCode((List) ypd.get("children"), ypd.get("innerCode").toString());
                ypd.put("children", child);
                ypd.put("leafFlag", false);
            } else {
                ypd.put("leafFlag", true);
            }
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<BudgetChangeDetailEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, BudgetChangeDetailEntity.class));
        }
    }



    /**
     * 保存回写预算
     *
     * @param changeEntity
     */
    private void saveWriteContract(BudgetChangeEntity changeEntity) {
        LambdaUpdateWrapper<BudgetEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(BudgetEntity::getChangeId, changeEntity.getId());
        updateWrapper.set(BudgetEntity::getChangeCode, changeEntity.getBillCode());
        updateWrapper.set(BudgetEntity::getChangeVersion, changeEntity.getChangeVersion());
        updateWrapper.set(BudgetEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());
        updateWrapper.set(BudgetEntity::getChangingCostbudgetMny, changeEntity.getCostbudgetMny());
        updateWrapper.set(BudgetEntity::getChangingIncomebudgetAdjustMny, changeEntity.getIncomebudgetAdjustMny());
        updateWrapper.set(BudgetEntity::getChangingIncomebudgetMny, changeEntity.getIncomebudgetMny());
        updateWrapper.set(BudgetEntity::getChangingLaborMny, changeEntity.getLaborMny());
        updateWrapper.set(BudgetEntity::getChangingManageMny, changeEntity.getManageMny());
        updateWrapper.set(BudgetEntity::getChangingManageRate, changeEntity.getManageMny());
        updateWrapper.set(BudgetEntity::getChangingMaterialMny, changeEntity.getMaterialMny());
        updateWrapper.eq(BudgetEntity::getId, changeEntity.getBudgetId());
        budgetService.update(budgetService.selectById(changeEntity.getBudgetId()), updateWrapper, false);
    }

    @Override
    public BudgetChangeVO addConvertByConId(Long budgetId) {
        BudgetVO budgetVO = budgetService.queryDetail(budgetId, false);
        BudgetChangeVO changeVO = BeanMapper.map(budgetVO, BudgetChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBillCode(null);
        changeVO.setBeforeCostbudgetMny(budgetVO.getCostbudgetMny());
        changeVO.setBeforeIncomebudgetAdjustMny(budgetVO.getIncomebudgetAdjustMny());
        changeVO.setBeforeIncomebudgetMny(budgetVO.getIncomebudgetMny());
        changeVO.setBeforeLaborMny(budgetVO.getLaborMny());
        changeVO.setBeforeManageMny(budgetVO.getManageMny());
        changeVO.setBeforeManageRate(budgetVO.getManageRate());
        changeVO.setBeforeMaterialMny(budgetVO.getMaterialMny());
        changeVO.setBudgetId(changeVO.getId());
        changeVO.setChangeVersion(budgetVO.getChangeVersion() == null ? 1 : budgetVO.getChangeVersion() + 1);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setTaxRatio(budgetVO.getTaxRatio());
        changeVO.setTaxFee(budgetVO.getTaxFee());

        List<BudgetChangeDetailVO> changeDetailList = changeVO.getDetailList();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            changeDetailList.forEach(changeDetailVO -> {
                changeDetailVO.setBudgetId(changeDetailVO.getBudgetId());
                changeDetailVO.setSrcBid(changeDetailVO.getId());

                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
                changeDetailVO.setChangeType(ChangeTypeEnum.未变更.getCode());
            });
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree(changeDetailList));
        return changeVO;
    }

    @Override
    public BudgetChangeVO queryDetail(Long id) {
        BudgetChangeEntity changeEntity = super.selectById(id);
        BudgetChangeVO changeVO = BeanMapper.map(changeEntity, BudgetChangeVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("changeId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<BudgetChangeDetailEntity> detailEntityList = budgetChangeDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (BudgetChangeDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List<BudgetChangeDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, BudgetChangeDetailVO.class);
            changeVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
        }
        return changeVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<BudgetChangeVO> vos) {
        BudgetChangeVO changeVo = vos.get(0);
        BudgetChangeEntity entity = super.selectById(changeVo.getId());
        //合同变更只有详情页有删除
        BudgetEntity pcentity = budgetService.selectById(entity.getBudgetId());
        //会写合同表
        pcentity.setId(entity.getBudgetId());
        pcentity.setChangeVersion(pcentity.getChangeVersion() - 1);
        pcentity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        pcentity.setChangingCostbudgetMny(BigDecimal.ZERO);//修改变更中金额
        pcentity.setChangingIncomebudgetAdjustMny(BigDecimal.ZERO);//修改变更中金额
        pcentity.setChangingIncomebudgetMny(BigDecimal.ZERO);//修改变更中金额
        pcentity.setChangingLaborMny(BigDecimal.ZERO);//修改变更中金额
        pcentity.setChangingManageMny(BigDecimal.ZERO);//修改变更中金额
        pcentity.setChangingManageRate(BigDecimal.ZERO);//修改变更中金额
        pcentity.setChangingMaterialMny(BigDecimal.ZERO);//修改变更中金额
        pcentity.setChangeCode(null);
        pcentity.setChangeId(null);
        budgetService.update(pcentity, new QueryWrapper<BudgetEntity>().eq("id", pcentity.getId()), false);
        super.removeByIds(vos.stream().map(BudgetChangeVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse<IPage<BudgetChangeVO>> queryListVOs(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        IPage<BudgetChangeEntity> page = queryPage(param, false);
        List<BudgetChangeVO> changeVOList = BeanMapper.mapList(page.getRecords(), BudgetChangeVO.class);
        IPage<BudgetChangeVO> changeVOIPage = new Page<>();
        changeVOIPage.setCurrent(page.getCurrent());
        changeVOIPage.setRecords(changeVOList);
        changeVOIPage.setSize(page.getSize());
        changeVOIPage.setTotal(page.getTotal());
        changeVOIPage.setPages(page.getPages());
        return CommonResponse.success("查询成功！", changeVOIPage);
    }

    @Override
    public List<BudgetChangeRecordVO> queryDetailRecord(Long budgetId) {
        LambdaQueryWrapper<BudgetChangeEntity> lambda = Wrappers.<BudgetChangeEntity>lambdaQuery();
        lambda.eq(BudgetChangeEntity::getBudgetId, budgetId);
        lambda.in(BudgetChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<BudgetChangeEntity> entities = super.list(lambda);
        List<BudgetChangeRecordVO> recordVOList = BeanMapper.mapList(entities, BudgetChangeRecordVO.class);
        recordVOList.forEach(recordVO -> {
                    if (recordVO.getChangeVersion() < 10) {
                        recordVO.setHistoryCode(recordVO.getBillCode() + "-0" + recordVO.getChangeVersion());
                    } else {
                        recordVO.setHistoryCode(recordVO.getBillCode() + "-" + recordVO.getChangeVersion());
                    }
                }
        );
        return recordVOList;
    }

    private BudgetCheckVO getCheckVO(List<BudgetChangeDetailVO> list, String level4) {
        BudgetCheckVO budgetCheckVO = new BudgetCheckVO();
        budgetCheckVO.setLevel4(level4);
        list.forEach(item -> {
            if (item.getLevelNo() == 1) {
                budgetCheckVO.setLevel1(item.getBuildingNo());
            } else if (item.getLevelNo() == 2) {
                budgetCheckVO.setLevel2(item.getBuildContent());
            } else if (item.getLevelNo() == 3) {
                budgetCheckVO.setLevel3(item.getCraft());
            }
        });
        return budgetCheckVO;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, String budgetChangeId, String budgetId, List<BudgetChangeDetailEntity> entities) {
        Set<String> materialNameSet = new HashSet<>();
        List<BudgetCheckVO> checkVOS = new ArrayList<>();
        BudgetCheckVO checkVO;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                long count = entities.stream().filter(item -> item.getInnerCode() == null).count();
                if (count > 0) {
                    return CommonResponse.error("请导入后再手动新增数据，否则会丢失！");
                }
                Map<String, BudgetChangeDetailVO> oldDataMap = getOldDataMap(budgetChangeId, budgetId, materialNameSet, entities);
                boolean levelFlag = false;
                boolean levelBlankFlag = false;
                int oneNo = 0;
                int twoNo = 0;
                int threeNo = 0;
                int fourNo = 0;
                Integer lastLevelNo = -1;
                String nextLevel = "1";
                StringBuffer innerCode = new StringBuffer();
                Map<String, Integer> indexMap = new HashMap<>();
                List<BudgetChangeDetailVO> detailVoList = new ArrayList<>();
                Map<String, BudgetChangeDetailVO> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BudgetChangeDetailVO vo = new BudgetChangeDetailVO();
                    boolean flag = false;
                    String warnType = "";
                    StringBuffer detailIndex = new StringBuffer();
                    String buildingNo = datas.get(0);
                    String buildContent = datas.get(1);
                    String craft = datas.get(2);
                    String materialName = datas.get(9);
                    Integer levelNo = -1;
                    if (StringUtils.isNotBlank(buildingNo)) {
                        oneNo++;
                        levelNo = 1;
                        if (!nextLevel.contains(levelNo.toString())) {
                            warnType = warnType + "层级不对,";
                            flag = true;
                            levelFlag = true;
                        }
                        if (lastLevelNo == 4) {
                            twoNo = 0;
                            threeNo = 0;
                            fourNo = 0;
                        }
                        nextLevel = "2";
                        detailIndex.append(oneNo);
                        levelBlankFlag = true;
                        innerCode = new StringBuffer();
                        innerCode.append(buildingNo).append("&&");
                        vo.setInnerCode(innerCode.toString());
                        vo.setBuildingNo(buildingNo);
                    } else if (StringUtils.isNotBlank(buildContent)) {
                        twoNo++;
                        levelNo = 2;
                        if (!nextLevel.contains(levelNo.toString())) {
                            warnType = warnType + "层级不对,";
                            flag = true;
                            levelFlag = true;
                        }
                        if (lastLevelNo == 4) {
                            threeNo = 0;
                            fourNo = 0;
                            String[] split = innerCode.toString().split("&&");
                            innerCode = new StringBuffer();
                            innerCode.append(split[0]).append("&&");
                        }
                        nextLevel = "3";
                        detailIndex.append(oneNo).append(".").append(twoNo);
                        levelBlankFlag = true;
                        innerCode.append(buildContent).append("&&");
                        vo.setInnerCode(innerCode.toString());
                        vo.setBuildContent(buildContent);
                    } else if (StringUtils.isNotBlank(craft)) {
                        threeNo++;
                        levelNo = 3;
                        if (!nextLevel.contains(levelNo.toString())) {
                            warnType = warnType + "层级不对,";
                            flag = true;
                            levelFlag = true;
                        }
                        if (lastLevelNo == 4) {
                            fourNo = 0;
                            String[] split = innerCode.toString().split("&&");
                            innerCode = new StringBuffer();
                            innerCode.append(split[0]).append("&&").append(split[1]).append("&&");
                        }
                        nextLevel = "4";
                        detailIndex.append(oneNo).append(".").append(twoNo).append(".").append(threeNo);
                        levelBlankFlag = true;
                        innerCode.append(craft).append("&&");
                        vo.setInnerCode(innerCode.toString());
                        vo.setCraft(craft);
                    } else if (StringUtils.isNotBlank(materialName)) {
                        fourNo++;
                        levelNo = 4;
                        if (!nextLevel.contains(levelNo.toString())) {
                            warnType = warnType + "层级不对,";
                            flag = true;
                            levelFlag = true;
                        }
                        nextLevel = "1,2,3,4";
                        detailIndex.append(oneNo).append(".").append(twoNo).append(".").append(threeNo).append(".").append(fourNo);
                        levelBlankFlag = true;
                        materialNameSet.add(materialName.trim());
                        vo.setInnerCode(innerCode.toString() + materialName);
                        vo.setMaterialName(materialName);
                    }
                    lastLevelNo = levelNo;

                    vo.setTreeIndex(detailIndex.toString());

                    //维护父子关系
                    String id = oldDataMap.containsKey(vo.getInnerCode()) ? oldDataMap.get(vo.getInnerCode()).getTid() : UUID.randomUUID().toString().replaceAll("-", "");
                    String[] split = detailIndex.toString().split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex.toString(), vo);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }

                    indexMap.put(detailIndex.toString(), i);

                    if (!levelBlankFlag) {
                        warnType = warnType + "楼号、施工内容、工艺、材料名称不能都为空,";
                        flag = true;
                    }

                    vo.setLevelNo(levelNo);

                    if (levelNo == 3) {
                        if (StringUtils.isBlank(datas.get(4))) {
                            vo.setBudgetNum(null);
                            warnType = warnType + "工程量为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setBudgetNum(new BigDecimal(datas.get(4)));
                            } catch (Exception e) {
                                vo.setBudgetNum(null);
                                warnType = warnType + "工程量只能为数字或小数,";
                                flag = true;
                            }
                        }

                        vo.setBudgetUnit(datas.get(5));//计量单位

                        if (StringUtils.isBlank(datas.get(6))) {
                            vo.setBudgetPrice(null);
                            warnType = warnType + "综合单价为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setBudgetPrice(new BigDecimal(datas.get(6)));
                            } catch (Exception e) {
                                vo.setBudgetPrice(null);
                                warnType = warnType + "综合单价只能为数字或小数,";
                                flag = true;
                            }
                        }

                        vo.setBudgetMoney(ComputeUtil.safeMultiply(vo.getBudgetNum(), vo.getBudgetPrice()));

                        if (StringUtils.isBlank(datas.get(7))) {
                            vo.setCostNum(null);
                            warnType = warnType + "成本工程量为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setCostNum(new BigDecimal(datas.get(7)));
                            } catch (Exception e) {
                                vo.setCostNum(null);
                                warnType = warnType + "成本工程量只能为数字或小数,";
                                flag = true;
                            }
                        }

                        if (StringUtils.isBlank(datas.get(8))) {
                            vo.setCostPrice(null);
                            warnType = warnType + "人工单价为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setCostPrice(new BigDecimal(datas.get(8)));
                            } catch (Exception e) {
                                vo.setCostPrice(null);
                                warnType = warnType + "人工单价只能为数字或小数,";
                                flag = true;
                            }
                        }

                        vo.setCostMoney(ComputeUtil.safeMultiply(vo.getCostNum(), vo.getCostPrice()));
                    }

                    if (levelNo == 4) {
                        if (StringUtils.isBlank(datas.get(9))) {
                            vo.setMaterialName(null);
                            warnType = warnType + "材料名称/体系为空,";
                            flag = true;
                        } else {
                            vo.setMaterialName(datas.get(9));
                        }

                        if (StringUtils.isBlank(datas.get(10))) {
                            vo.setMaterialWeightScale(null);
//                            warnType = warnType + "产值权重为空,";
//                            flag = true;
                        } else {
                            try {
                                vo.setMaterialWeightScale(ComputeUtil.safeMultiply(new BigDecimal(100), new BigDecimal(datas.get(10))));
                            } catch (Exception e) {
                                vo.setMaterialWeightScale(null);
                                warnType = warnType + "产值权重只能为数字或小数,";
                                flag = true;
                            }
                        }

                        if (StringUtils.isBlank(datas.get(11))) {
                            vo.setMaterialUsedScale(null);
//                            warnType = warnType + "产值权重为空,";
//                            flag = true;
                        } else {
                            try {
                                vo.setMaterialUsedScale(ComputeUtil.safeMultiply(new BigDecimal(100), new BigDecimal(datas.get(11))));
                            } catch (Exception e) {
                                vo.setMaterialUsedScale(null);
                                warnType = warnType + "材料使用率只能为数字或小数,";
                                flag = true;
                            }
                        }

                        if (StringUtils.isBlank(datas.get(12))) {
                            vo.setMaterialPrice(null);
                            warnType = warnType + "材料单价为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setMaterialPrice(new BigDecimal(datas.get(12)));
                            } catch (Exception e) {
                                vo.setMaterialPrice(null);
                                warnType = warnType + "材料单价只能为数字或小数,";
                                flag = true;
                            }
                        }

                        if (StringUtils.isBlank(datas.get(13))) {
                            vo.setMaterialUsedNum(null);
                            warnType = warnType + "耗量为空,";
                            flag = true;
                        } else {
                            try {
                                vo.setMaterialUsedNum(new BigDecimal(datas.get(13)));
                            } catch (Exception e) {
                                vo.setMaterialUsedNum(null);
                                warnType = warnType + "耗量只能为数字或小数,";
                                flag = true;
                            }
                        }

                        BigDecimal parCostNum = tidMap.get(vo.getTpid()) != null ? tidMap.get(vo.getTpid()).getCostNum() : null;
                        vo.setMaterialPlanNum(ComputeUtil.safeMultiply(vo.getMaterialUsedNum(), parCostNum));
                        vo.setMaterialMoney(ComputeUtil.safeMultiply(vo.getMaterialPlanNum(), vo.getMaterialPrice()));

                        if (StringUtils.isBlank(datas.get(14))) {
                            vo.setMaterialUnit(null);
                            warnType = warnType + "材料单位为空,";
                            flag = true;
                        } else {
                            vo.setMaterialUnit(datas.get(14));
                        }
                        vo.setLeafFlag(true);
                        // 获取楼号 施工内容 工序
                        checkVO = getCheckVO(detailVoList, datas.get(9));
                        Boolean likeFlag = false;
                        for (BudgetCheckVO item : checkVOS) {
                            if (checkVO.getLevel1().equals(item.getLevel1()) && checkVO.getLevel2().equals(item.getLevel2()) && checkVO.getLevel3().equals(item.getLevel3()) && checkVO.getLevel4().equals(item.getLevel4())) {
                                warnType = warnType + "数据重复,";
                                flag = true;
                                likeFlag = true;
                                break;
                            }
                        }
                        if (!likeFlag) {
                            checkVOS.add(checkVO);
                        }
                    } else {
                        vo.setLeafFlag(false);
                    }
                    // true=可以导入，false=不可导入
                    vo.setImportFlag(!flag);
                    if (flag) {
                        warnType = warnType.substring(0, warnType.length() - 1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
                    detailVoList.add(vo);
                }

                List<BudgetChangeDetailVO> newList = new ArrayList<>();
                for (BudgetChangeDetailVO tVo : detailVoList) {
                    tVo.setTpid(tidMap.get(tVo.getTpid()) != null ? tidMap.get(tVo.getTpid()).getTid() : null);
                    if (oldDataMap.containsKey(tVo.getInnerCode())) {
                        BudgetChangeDetailVO oldDeailVO = oldDataMap.get(tVo.getInnerCode());
                        tVo.setId(oldDeailVO.getId());
                        tVo.setVersion(oldDeailVO.getVersion());
                        tVo.setBudgetId(oldDeailVO.getBudgetId());
                        tVo.setSrcBid(oldDeailVO.getSrcBid());
                        tVo.setChangeType(oldDeailVO.getChangeType());
                        tVo.setRowState(oldDeailVO.getRowState());
                        if (oldDeailVO.getChangeType() == 5) {
                            tVo.setRowState("edit");
                            //非终止
                            tVo.setChangeType(ChangeTypeEnum.未变更.getCode());
                        }
                        oldDataMap.put(tVo.getInnerCode(), tVo);
                    } else {
                        tVo.setRowState("add");
                        //非终止
                        tVo.setChangeType(ChangeTypeEnum.未变更.getCode());
                        newList.add(tVo);
                    }
                }
                Collection<BudgetChangeDetailVO> changeDetailVOCollection = oldDataMap.values();
                List<BudgetChangeDetailVO> changeDetailVOS = new ArrayList<BudgetChangeDetailVO>(changeDetailVOCollection);
                changeDetailVOS.addAll(newList);

                CommonResponse<List<MaterialVO>> materialListresp = materialApi.queryMaterialListByNames(new ArrayList<>(materialNameSet));
                Map<String, MaterialVO> materialMap = null;
                if (materialListresp.isSuccess()) {
                    materialMap = materialListresp.getData().stream().collect(Collectors.toMap(MaterialVO::getName, Function.identity(), (key1, key2) -> key2));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(changeDetailVOS, Map.class));
                //List<Map<String, Object>> mapList = ExcelImportUtil.dealWeightScale(deailTreeData);
                levelFlag = getLevelFlag(deailTreeData, materialMap);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(deailTreeData, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                if (levelFlag) {
                    resp.put("successList", null);
                    resp.put("successNum", 0);
                } else {
                    resp.put("successList", convertJsonToVoList(allList.get(0)));
                    resp.put("successNum", result.size() - errorList.size());
                }
                if (CollectionUtils.isNotEmpty(errorList)) {
                    errorList.forEach(t -> {
                        Object innerCodeObj = t.get("innerCode");
                        if ((Integer) t.get("levelNo") == 3 && innerCodeObj != null) {
                            String s = innerCodeObj.toString();
                            String[] split = s.split("&&");
                            t.put("buildingNo", split[0]);
                            t.put("buildContent", split[1]);
                        }
                    });
                }

                resp.put("errorList", errorList);
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }


    private boolean getLevelFlag(List<Map<String, Object>> mapList, Map<String, MaterialVO> materialMap) {
        for (Map<String, Object> map : mapList) {
            List<Map<String, Object>> child = (List) map.get("children");
            if (child != null) {
                if (getLevelFlag(child, materialMap)) {
                    return true;
                }
            } else {
                if (null != map.get("materialName")) {
                    if (materialMap.containsKey(map.get("materialName"))) {
                        MaterialVO materialVO = materialMap.get(map.get("materialName"));
                        map.put("materialId", materialVO.getId());
                    } else {
                        if (!(Boolean) map.get("importFlag")) {
                            map.put("warnType", map.get("warnType") + ", 根据名称找不到对应的物资");
                        } else {
                            map.put("importFlag", false);
                            map.put("warnType", "根据名称找不到对应的物资");
                        }
                    }
                }

                if (null != map.get("warnType") && ((String) map.get("warnType")).contains("权重和不为1")) {
                    return true;
                }
            }
        }
        return false;
    }

    private List<BudgetChangeDetailVO> convertJsonToVoList(List<Map<String, Object>> successList) {
        List<Map<String, Object>> success = treeToListNoWarn(successList);
        List<BudgetChangeDetailVO> detailVOList = BeanMapper.mapList(success, BudgetChangeDetailVO.class);
        return buildTreeByTid(detailVOList);
    }

    // 树转list
    public List<Map<String, Object>> treeToListNoWarn(List<Map<String, Object>> list) {
        List<Map<String, Object>> reList = new ArrayList<>();
        for (Map<String, Object> stringObjectMap : list) {
            if (stringObjectMap.containsKey("createUserName")) {
                stringObjectMap.remove("createUserName");
            }
            if (stringObjectMap.containsKey("updateUserName")) {
                stringObjectMap.remove("updateUserName");
            }
            if (stringObjectMap.containsKey("parentID")) {
                stringObjectMap.remove("parentID");
            }
            if (stringObjectMap.containsKey("nodeId")) {
                stringObjectMap.remove("nodeId");
            }
            if (null == stringObjectMap.get("changeType") || !stringObjectMap.get("changeType").toString().equals("5")) {
                stringObjectMap.put("changeType", "0");
            }
            List<Map<String, Object>> child = (List) stringObjectMap.get("children");
            if (null != child) {// 有下级
                List<Map<String, Object>> childrenList = treeToListNoWarn(child);
                stringObjectMap.put("children", null);
                reList.add(stringObjectMap);
                reList.addAll(childrenList);
            } else {
                reList.add(stringObjectMap);
            }
        }
        return reList;
    }

    private Map<String, BudgetChangeDetailVO> getOldDataMap(String budgetChangeId, String budgetId, Set<String> materialNameSet, List<BudgetChangeDetailEntity> entitys) {
        Map<String, BudgetChangeDetailVO> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(entitys)) {
            Map<Long, BudgetChangeDetailEntity> detailEntityMap = entitys.stream().collect(Collectors.toMap(BudgetChangeDetailEntity::getId, Function.identity(), (key1, key2) -> key2));

            if (CollectionUtils.isNotEmpty(entitys)) {
                for (BudgetChangeDetailEntity detailEntity : entitys) {
                    String[] pkArray = detailEntity.getInnerCode().split("&&");
                    StringBuffer stringKey = new StringBuffer();
                    for (String pk : pkArray) {
                        BudgetChangeDetailEntity detailEntity1 = detailEntityMap.get(Long.valueOf(pk));
                        if (1 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getBuildingNo()).append("&&");
                        } else if (2 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getBuildContent()).append("&&");
                        } else if (3 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getCraft()).append("&&");
                        } else if (4 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getMaterialName());
                            materialNameSet.add(detailEntity1.getMaterialName().trim());
                        }
                    }
                    BudgetChangeDetailVO changeDetailVO = BeanMapper.map(detailEntity, BudgetChangeDetailVO.class);
                   /* changeDetailVO.setTid(changeDetailVO.getId().toString());
                    changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                    changeDetailVO.setId(null);
                    changeDetailVO.setImportFlag(true);// true=可以导入，false=不可导入
                    changeDetailVO.setRowState("edit");
                    changeDetailVO.setShadowId(changeDetailVO.getTid());
                    changeDetailVO.setChangeType(ChangeTypeEnum.未变更.getCode());//增补项*/
                    map.put(stringKey.toString(), changeDetailVO);
                }
            }
        }
       /* if (StringUtils.isNotBlank(budgetChangeId) && !budgetChangeId.equals("null")) {
            List<BudgetChangeDetailEntity> changeDetailEntities = entitys;
            if(changeDetailEntities.size() == 0){
                LambdaQueryWrapper<BudgetChangeDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(BudgetChangeDetailEntity::getChangeId, budgetChangeId);
                queryWrapper.ne(BudgetChangeDetailEntity::getChangeType, ChangeTypeEnum.中止.getCode());
                changeDetailEntities = budgetChangeDetailService.list(queryWrapper);
            }
            Map<Long, BudgetChangeDetailEntity> detailEntityMap = changeDetailEntities.stream().collect(Collectors.toMap(BudgetChangeDetailEntity::getId, Function.identity(), (key1, key2) -> key2));

            if (CollectionUtils.isNotEmpty(changeDetailEntities)) {
                for (BudgetChangeDetailEntity detailEntity : changeDetailEntities) {
                    String[] pkArray = detailEntity.getInnerCode().split("&&");
                    StringBuffer stringKey = new StringBuffer();
                    for (String pk : pkArray) {
                        BudgetChangeDetailEntity detailEntity1 = detailEntityMap.get(Long.valueOf(pk));
                        if (1 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getBuildingNo()).append("&&");
                        } else if (2 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getBuildContent()).append("&&");
                        } else if (3 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getCraft()).append("&&");
                        } else if (4 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getMaterialName());
                            materialNameSet.add(detailEntity1.getMaterialName().trim());
                        }
                    }
                    BudgetChangeDetailVO changeDetailVO = BeanMapper.map(detailEntity, BudgetChangeDetailVO.class);
                    changeDetailVO.setTid(changeDetailVO.getId().toString());
                    changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                    changeDetailVO.setId(null);
                    changeDetailVO.setImportFlag(true);// true=可以导入，false=不可导入
                    changeDetailVO.setRowState("edit");
                    changeDetailVO.setShadowId(changeDetailVO.getTid());
                    changeDetailVO.setChangeType(ChangeTypeEnum.未变更.getCode());//增补项
                    map.put(stringKey.toString(), changeDetailVO);
                }
            }
        } else if(StringUtils.isNotBlank(budgetId)) {
            List<BudgetDetailEntity> detailEntities = BeanMapper.mapList(entitys,BudgetDetailEntity.class);
            if(detailEntities.size() == 0){
                LambdaQueryWrapper<BudgetDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(BudgetDetailEntity::getBudgetId, budgetId);
                queryWrapper.ne(BudgetDetailEntity::getChangeType, ChangeTypeEnum.中止.getCode());
                detailEntities = budgetDetailService.list(queryWrapper);
            }
            Map<Long, BudgetDetailEntity> detailEntityMap = detailEntities.stream().collect(Collectors.toMap(BudgetDetailEntity::getId, Function.identity(), (key1, key2) -> key2));

            if (CollectionUtils.isNotEmpty(detailEntities)) {
                for (BudgetDetailEntity detailEntity : detailEntities) {
                    String[] pkArray = detailEntity.getInnerCode().split("&&");
                    StringBuffer stringKey = new StringBuffer();
                    for (String pk : pkArray) {
                        BudgetDetailEntity detailEntity1 = detailEntityMap.get(Long.valueOf(pk));
                        if (1 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getBuildingNo()).append("&&");
                        } else if (2 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getBuildContent()).append("&&");
                        } else if (3 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getCraft()).append("&&");
                        } else if (4 == detailEntity1.getLevelNo()) {
                            stringKey.append(detailEntity1.getMaterialName());
                            materialNameSet.add(detailEntity1.getMaterialName().trim());
                        }
                    }
                    BudgetChangeDetailVO changeDetailVO = BeanMapper.map(detailEntity, BudgetChangeDetailVO.class);
                    changeDetailVO.setBudgetId(changeDetailVO.getBudgetId());
                    changeDetailVO.setSrcBid(changeDetailVO.getId());

                    changeDetailVO.setTid(changeDetailVO.getId().toString());
                    changeDetailVO.setTpid(changeDetailVO.getParentId()!= null&&changeDetailVO.getParentId()>0?changeDetailVO.getParentId().toString():"");
                    changeDetailVO.setImportFlag(true);// true=可以导入，false=不可导入
                    //changeDetailVO.setRowState("edit");
                    changeDetailVO.setShadowId(changeDetailVO.getTid());
                    //changeDetailVO.setChangeType(ChangeTypeEnum.未变更.getCode());//增补项
                    map.put(stringKey.toString(), changeDetailVO);
                }
            }
        }*/
        return map;
    }

    /**
     * 构建树
     *
     * @param values 需要组建树的数据List
     * @return 树的根节点
     */
    public static List<BudgetChangeDetailVO> buildTreeByTid(List<BudgetChangeDetailVO> values) {
        Map<String, BudgetChangeDetailVO> nodeMap = new HashMap<>();
        List<BudgetChangeDetailVO> result = new ArrayList<>();
        List<BudgetChangeDetailVO> emptyValueList = new ArrayList<>();
        for (BudgetChangeDetailVO value : values) {
            if (StringUtils.isBlank(value.getTpid())) {
                result.add(value);
            } else {
                BudgetChangeDetailVO parentNode = nodeMap.get(value.getTpid());
                if (parentNode == null) {
                    emptyValueList.add(value);
                } else {
                    parentNode.getChildren().add(value);
                }
            }
            nodeMap.put(value.getTid(), value);
        }
        if (!emptyValueList.isEmpty()) {
            for (BudgetChangeDetailVO value : emptyValueList) {
                BudgetChangeDetailVO parentNode = nodeMap.get(value.getTpid());
                if (parentNode == null) {
                    result.add(value);
                } else {
                    parentNode.getChildren().add(value);
                }
            }
        }
        return result;
    }
}
