package com.ejianc.business.plan.service.impl;

import com.ejianc.business.plan.bean.BudgetPlanEntity;
import com.ejianc.business.plan.consts.ChangeStatusConst;
import com.ejianc.business.plan.service.IBudgetPlanService;
import com.ejianc.business.plan.vo.RecalculateVO;
import com.ejianc.business.utils.CheckUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("budgetPlan")
public class BudgetPlanBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBudgetPlanService budgetPlanService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        logger.info("施工计划提交前回调");
        BudgetPlanEntity entity = budgetPlanService.selectById(billId);
        CommonResponse planItem = CheckUtil.createPlanItem(entity.getId(), entity.getBudgetId(),entity.getStartMonth(),entity.getEndMonth());
        RecalculateVO vo = new RecalculateVO(entity.getProjectId(), null);
        budgetPlanService.recalculate(vo, 3);
        /*List<String> uninBuildingNos = CheckUtil.CheckAllBuilding(1, entity.getId(), entity.getBudgetId());
        if(uninBuildingNos.size() > 0){
            String msg = "该计划下，还有楼号(";
            for (String str:uninBuildingNos
            ) {
                msg = msg + str + ",";
            }
            msg = msg.substring(0,msg.length()-1);
            msg = msg + "),未进行编辑，请编辑保存后,一并提交！";
            return CommonResponse.error(msg);
        }*/
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        BudgetPlanEntity entity = budgetPlanService.selectById(billId);
        CommonResponse planItem = CheckUtil.createPlanItem(entity.getId(), entity.getBudgetId(),entity.getStartMonth(),entity.getEndMonth());
        RecalculateVO vo = new RecalculateVO(entity.getProjectId(), null);
        budgetPlanService.recalculate(vo, 3);
        /*List<String> uninBuildingNos = CheckUtil.CheckAllBuilding(1, entity.getId(), entity.getBudgetId());
        if(uninBuildingNos.size() > 0){
            String msg = "该计划下，还有楼号(";
            for (String str:uninBuildingNos
            ) {
                msg = msg + str + ",";
            }
            msg = msg.substring(0,msg.length()-1);
            msg = msg + "),未进行编辑，请编辑保存后,一并提交！";
            return CommonResponse.error(msg);
        }*/
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetPlanEntity byId = budgetPlanService.getById(billId);
        if (byId.getChangeStatus() != ChangeStatusConst.UN_CHANGE) {
            return CommonResponse.error("施工计划处于变更中或已变更状态不能弃审!");
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
