/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.recoveries.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.PlanCostVO;
import com.ejianc.business.recoveries.BudgetRecoveriesVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetRecoveries"})
public class BudgetRecoveriesController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    private static final Integer QUERY_TIMEOUT = 60;
    private static final Integer BATCH_SIZE = 1000;
    private static final String INDEX_NAME_Receive = "receive_summary";
    @Autowired(required=false)
    private RestHighLevelClient client;

    @RequestMapping(value={"/queryRecoveriesList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetRecoveriesVO>> queryRecoveriesList(@RequestBody QueryParam param) {
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Page page = new Page();
        page.setCurrent((long)pageNumber);
        page.setSize((long)pageSize);
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_Receive});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        Map params = param.getParams();
        if (params != null && params.size() > 0) {
            String endDate = this.getParamValue(params, "createTime");
            if (StringUtils.isNotBlank((CharSequence)endDate)) {
                DateTime date = DateUtil.date();
                int n = DateUtil.year((Date)date);
                endDate = n + "-" + endDate + "-31 23:59:59";
                RangeQueryBuilder createTime = QueryBuilders.rangeQuery((String)"createTime");
                params.remove("createTime");
                createTime.lte((Object)endDate);
                boolQuery.must((QueryBuilder)createTime);
            }
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value = this.getParamValue(params, key);
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
            }
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.sort((SortBuilder)new FieldSortBuilder((FieldSortBuilder)new FieldSortBuilder("orgIdNum").order(SortOrder.ASC)));
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        ArrayList<Object> list = new ArrayList<Object>();
        SearchResponse response = null;
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits searchHits = response.getHits();
            for (SearchHit hit : searchHits) {
                String string = hit.getSourceAsString();
                list.add(JSON.parseObject((String)string, BudgetRecoveriesVO.class));
            }
            if (CollectionUtils.isNotEmpty(list)) {
                Map<Long, List<BudgetRecoveriesVO>> map = list.stream().collect(Collectors.groupingBy(BudgetRecoveriesVO::getOrgId));
                for (BudgetRecoveriesVO budgetRecoveriesVO : list) {
                    Long orgId = budgetRecoveriesVO.getOrgId();
                    List<BudgetRecoveriesVO> ll = map.get(orgId);
                    if (CollectionUtils.isNotEmpty(ll)) {
                        budgetRecoveriesVO.setOrgRowSpan(Integer.valueOf(ll.size()));
                        map.remove(orgId);
                        continue;
                    }
                    budgetRecoveriesVO.setOrgRowSpan(Integer.valueOf(0));
                }
            }
            page.setRecords(list);
            page.setTotal(searchHits.getTotalHits().value);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u672c\u63a7\u5236\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/reloadCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanCostVO> reloadCost(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        try {
            this.deleteESData(INDEX_NAME_Receive);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)"\u91cd\u65b0\u52a0\u8f7d\u6210\u672c\u63a7\u5236\u6570\u636e\u6210\u529f\uff01");
    }

    private long deleteESData(String indexName) throws IOException {
        int i = 0;
        Long resultSize = this.queryIndexSize(indexName);
        Long deleteTimes = resultSize % (long)BATCH_SIZE.intValue();
        if ((long)i < deleteTimes + 1L) {
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{indexName});
            deleteByQueryRequest.setQuery((QueryBuilder)new TermQueryBuilder("tenantId", (Object)InvocationInfoProxy.getTenantid()));
            deleteByQueryRequest.setBatchSize(BATCH_SIZE.intValue());
            BulkByScrollResponse response = this.client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            return response.getDeleted();
        }
        return 0L;
    }

    private Long queryIndexSize(String indexName) {
        Long resultSize = 0L;
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"tenantId", (Object)InvocationInfoProxy.getTenantid());
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)termQueryBuilder);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            resultSize = hits.getTotalHits().value;
        }
        catch (IOException e) {
            try {
                SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                resultSize = hits.getTotalHits().value;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return resultSize;
    }

    @RequestMapping(value={"excelExportInAndOutStoreList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportInAndOutStoreList(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(10000);
        param.setPageIndex(1);
        CommonResponse<IPage<BudgetRecoveriesVO>> voPage = this.queryRecoveriesList(param);
        List list = ((IPage)voPage.getData()).getRecords();
        boolean num = false;
        if (ListUtil.isNotEmpty((List)list)) {
            int i;
            ServletOutputStream outputStream = response.getOutputStream();
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet();
            sheet.createFreezePane(0, 2, 0, 2);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 7));
            XSSFRow row = sheet.createRow(0);
            XSSFCellStyle style = workbook.createCellStyle();
            style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
            style.setFillPattern((short)1);
            style.setAlignment((short)2);
            XSSFCell cell = row.createCell(0);
            cell.setCellValue("\u56de\u6b3e\u6c47\u603b");
            cell.setCellStyle((CellStyle)style);
            row = sheet.createRow(1);
            cell = row.createCell(0);
            cell.setCellValue("\u533a\u57df");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(1);
            cell.setCellValue("\u9879\u76ee\u7ecf\u7406");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(2);
            cell.setCellStyle((CellStyle)style);
            cell.setCellValue("\u9879\u76ee");
            cell = row.createCell(3);
            cell.setCellValue("\u6295\u8d44\u4e3b\u4f53");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(4);
            cell.setCellValue("\u53d1\u5305\u5355\u4f4d");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(5);
            cell.setCellValue("\u56de\u6b3e\u91d1\u989d");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(6);
            cell.setCellValue("\u5b9e\u9645\u56de\u6b3e");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(7);
            cell.setCellValue("\u4f59\u989d");
            cell.setCellStyle((CellStyle)style);
            for (i = 0; i < 7; ++i) {
                sheet.autoSizeColumn(i);
                sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 60 / 10);
            }
            for (i = 0; i < list.size(); ++i) {
                BudgetRecoveriesVO vo = (BudgetRecoveriesVO)list.get(i);
                row = sheet.createRow(i + 2);
                if (vo.getOrgRowSpan() > 0) {
                    cell = row.createCell(0);
                    cell.setCellValue(vo.getOrgName() == null ? "" : vo.getOrgName().toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (vo.getOrgRowSpan() - 1), 0, 0));
                }
                cell = row.createCell(1);
                cell.setCellValue(vo.getProjectManager() != null ? vo.getProjectManager().toString() : null);
                cell = row.createCell(2);
                cell.setCellValue(vo.getProjectName() != null ? vo.getProjectName().toString() : null);
                cell = row.createCell(3);
                cell.setCellValue(vo.getInvestorName() != null ? vo.getInvestorName().toString() : null);
                cell = row.createCell(4);
                cell.setCellValue(vo.getPubUnitName() != null ? vo.getPubUnitName().toString() : null);
                cell = row.createCell(5);
                cell.setCellValue(vo.getSumQuoteTaxMny() != null ? vo.getSumQuoteTaxMny().toString() : null);
                cell = row.createCell(6);
                cell.setCellValue(vo.getReceiveMny() != null ? vo.getReceiveMny().toString() : null);
                cell = row.createCell(7);
                cell.setCellValue(vo.getYue() != null ? vo.getYue().toString() : null);
            }
            ArrayList list1 = new ArrayList();
            list.forEach(item -> {
                if (item.getOrgRowSpan() > 0) {
                    Integer orgRowSpan = item.getOrgRowSpan();
                    list1.add(orgRowSpan);
                    int sum1 = (int)list1.stream().collect(Collectors.summarizingInt(value -> value)).getSum();
                    sheet.shiftRows(sum1 + 2, sheet.getLastRowNum() + 1, 1, true, false);
                    XSSFRow newRow = sheet.createRow(sum1 + 2);
                    XSSFCell newCell = newRow.createCell(0);
                    newCell = newRow.createCell(0);
                    newCell.setCellValue(item.getOrgName() == null ? "" : item.getOrgName().toString());
                    newCell = newRow.createCell(1);
                    newCell.setCellValue("\u5408\u8ba1");
                    BigDecimal sumQuoteTaxMny = list.stream().filter(s -> s.getOrgId().equals(item.getOrgId())).map(BudgetRecoveriesVO::getSumQuoteTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    newCell = newRow.createCell(5);
                    newCell.setCellValue(sumQuoteTaxMny != null ? sumQuoteTaxMny.toString() : null);
                    BigDecimal receiveMny = list.stream().filter(s -> s.getOrgId().equals(item.getOrgId())).map(BudgetRecoveriesVO::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    newCell = newRow.createCell(6);
                    newCell.setCellValue(receiveMny != null ? receiveMny.toString() : null);
                    BigDecimal yun = list.stream().filter(s -> s.getOrgId().equals(item.getOrgId())).map(BudgetRecoveriesVO::getYue).reduce(BigDecimal.ZERO, BigDecimal::add);
                    newCell = newRow.createCell(7);
                    newCell.setCellValue(yun != null ? yun.toString() : null);
                    list1.remove(orgRowSpan);
                    list1.add(orgRowSpan + 1);
                }
            });
            workbook.write((OutputStream)outputStream);
        }
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }
}

