package com.ejianc.business.probuilddiary.project.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 项目日志-施工内容（施工员）
 *
 * @author baipengyan
 */
public class ProjectLogDetailVO extends BaseVO {
	private static final long serialVersionUID = -2273990505520826637L;

	private Long personId; // 个人日志id
	private Long constructId; // 施工区域id
	private String constructName; // 施工区域名称
	private String constructCode; // 施工区域编码
	private String teamName; // 施工班组名称
	private String workNum; // 工作人数
	private String workMemo; // 工作描述
	private Long commitUserId; // 提交人id
	private String commitUserCode; // 提交人账号
	private String commitUserName; // 提交人名称
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date commitDate; // 提交日期
	private Long projectLogId; // 项目日志id
	private String fileType; // 文件类型
	private Boolean updateFlag; // 更新状态
	private String logNumber; // 日志项编码
	private Boolean projectManagerFlag; // 项目经理标识
	private String dutyId; // 责任人id
	private String dutyName; // 责任人名称
	private String dutyCode; // 责任人编码
	private Long projectId; // 项目id

	public Long getPersonId() {
		return personId;
	}

	public void setPersonId(Long personId) {
		this.personId = personId;
	}

	public Long getConstructId() {
		return constructId;
	}

	@ReferDeserialTransfer
	public void setConstructId(Long constructId) {
		this.constructId = constructId;
	}

	public String getConstructName() {
		return constructName;
	}

	public void setConstructName(String constructName) {
		this.constructName = constructName;
	}

	public String getConstructCode() {
		return constructCode;
	}

	public void setConstructCode(String constructCode) {
		this.constructCode = constructCode;
	}

	public String getTeamName() {
		return teamName;
	}

	public void setTeamName(String teamName) {
		this.teamName = teamName;
	}

	public String getWorkNum() {
		return workNum;
	}

	public void setWorkNum(String workNum) {
		this.workNum = workNum;
	}

	public String getWorkMemo() {
		return workMemo;
	}

	public void setWorkMemo(String workMemo) {
		this.workMemo = workMemo;
	}

	public Long getCommitUserId() {
		return commitUserId;
	}

	public void setCommitUserId(Long commitUserId) {
		this.commitUserId = commitUserId;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public Long getProjectLogId() {
		return projectLogId;
	}

	public void setProjectLogId(Long projectLogId) {
		this.projectLogId = projectLogId;
	}

	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	public Boolean getUpdateFlag() {
		return updateFlag;
	}

	public void setUpdateFlag(Boolean updateFlag) {
		this.updateFlag = updateFlag;
	}

	public String getLogNumber() {
		return logNumber;
	}

	public void setLogNumber(String logNumber) {
		this.logNumber = logNumber;
	}

	public Boolean getProjectManagerFlag() {
		return projectManagerFlag;
	}

	public void setProjectManagerFlag(Boolean projectManagerFlag) {
		this.projectManagerFlag = projectManagerFlag;
	}

	public String getDutyId() {
		return dutyId;
	}

	public void setDutyId(String dutyId) {
		this.dutyId = dutyId;
	}

	public String getDutyName() {
		return dutyName;
	}

	public void setDutyName(String dutyName) {
		this.dutyName = dutyName;
	}

	public String getDutyCode() {
		return dutyCode;
	}

	public void setDutyCode(String dutyCode) {
		this.dutyCode = dutyCode;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}
}
