/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.construct.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaDetailEntity;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaEntity;
import com.ejianc.business.probuilddiary.construct.mapper.ConstructAreaMapper;
import com.ejianc.business.probuilddiary.construct.service.IConstructAreaService;
import com.ejianc.business.probuilddiary.construct.utils.TreeNodeBUtil;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaDetailVO;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="constructAreaService")
public class ConstructAreaServiceImpl
extends BaseServiceImpl<ConstructAreaMapper, ConstructAreaEntity>
implements IConstructAreaService {
    private static final String BILL_CODE = "AREA_WORK";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public ConstructAreaVO insertOrUpdate(ConstructAreaVO vo) {
        ConstructAreaEntity entity = (ConstructAreaEntity)((Object)BeanMapper.map((Object)vo, ConstructAreaEntity.class));
        if (entity.getId() == null) {
            entity.setId(IdWorker.getId());
            CommonResponse billCode = this.billCodeApi.generateBillCode(BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo));
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (entity.getHoldStatus() == null) {
                entity.setHoldStatus("1");
            }
        }
        this.resetPid(entity.getDetailList());
        super.saveOrUpdate((Object)entity, false);
        ConstructAreaVO construct = (ConstructAreaVO)BeanMapper.map((Object)((Object)entity), ConstructAreaVO.class);
        return construct;
    }

    @Override
    public ConstructAreaVO queryDetail(Long id) {
        HashMap orderMap = new HashMap();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        orderParams.put("treeIndex", "asc");
        orderMap.put("detailList", orderParams);
        ConstructAreaEntity constructAreaEntity = (ConstructAreaEntity)((Object)super.selectById((Serializable)id, orderMap));
        ConstructAreaVO contractVO = (ConstructAreaVO)BeanMapper.map((Object)((Object)constructAreaEntity), ConstructAreaVO.class);
        if (CollectionUtils.isNotEmpty((Collection)contractVO.getDetailList())) {
            for (ConstructAreaDetailVO detail : contractVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            contractVO.setDetailList(TreeNodeBUtil.buildTree((List)contractVO.getDetailList()));
        }
        return contractVO;
    }

    private void resetPid(List<ConstructAreaDetailEntity> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ConstructAreaDetailEntity cdEntity : detailList) {
                if (!"del".equals(cdEntity.getRowState())) {
                    if (cdEntity.getId() == null) {
                        cdEntity.setId(IdWorker.getId());
                    }
                    idMap.put(cdEntity.getTid().toString(), cdEntity.getId());
                    cdEntity.setParentId(null);
                }
                if (!"add".equals(cdEntity.getRowState())) continue;
                cdEntity.setDetailId(IdWorker.getId());
            }
            for (ConstructAreaDetailEntity cdEntity : detailList) {
                if ("del".equals(cdEntity.getRowState()) || !StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid().toString()));
            }
        }
    }
}

