package com.ejianc.business.probuilddiary.ledger.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.probuilddiary.ledger.bean.*;
import com.ejianc.business.probuilddiary.ledger.mapper.LedgerMapper;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerService;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerTemplateService;
import com.ejianc.business.probuilddiary.ledger.vo.*;
import com.ejianc.business.probuilddiary.project.bean.*;
import com.ejianc.business.probuilddiary.project.dtomapper.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 日志台账
 *
 * @author generator
 */
@Service("ledgerService")
public class LedgerServiceImpl extends BaseServiceImpl<LedgerMapper, LedgerEntity> implements ILedgerService {

	private static final String SCHEDULE_WORK_TYPE = "schedule_work_type";
	private static final String TYPE_WORK_TYPE = "type_work_type";
	private static final String QUALITY_WORK_TYPE = "quality_work_type";
	private static final String SAFETY_WORK_TYPE = "safety_work_type";
	private static final String MATERIAL_WORK_TYPE = "material_work_type";
	private static final String EQUIPMENT_WORK_TYPE = "equipment_work_type";
	private static final String EXAMINE_WORK_TYPE = "examine_work_type";
	private static final String INFORMATION_WORK_TYPE = "information_work_type";
	private static final String OTHER_WORK_TYPE = "other_work_type";

	private static final String SCHEDULE_TITLE = "进度情况（施工员）";
	private static final String TYPE_TITLE = "施工组织设计、方案、交底、变更情况（技术负责人）";
	private static final String QUALITY_TITLE = "工程质量检查、验收情况（质检员）";
	private static final String SAFETY_TITLE = "安全活动情况（安全员）";
	private static final String MATERIAL_TITLE = "材料进场情况（材料员）";
	private static final String EQUIPMENT_TITLE = "设备进场情况（设备管理员）";
	private static final String EXAMINE_TITLE = "原材料检验、时间、试块及见证取样送检等情况（取样员）";
	private static final String INFORMATION_TITLE = "工程资料归档及会议情况（资料员）";
	private static final String OTHER_TITLE = "其他情况";
	private final ILedgerTemplateService templateService;


	public LedgerServiceImpl(ILedgerTemplateService templateService) {
		this.templateService = templateService;
	}

	/**
	 * 查询其他子表数据
	 *
	 * @param id 主键
	 *
	 * @return LedgerSubVO
	 */
	@Override
	public List<JSONObject> fetchOtherSubDetail(Long id) {
		ArrayList<JSONObject> jsonObjects = new ArrayList<>();

		LedgerEntity entity = super.selectById(id);
		LedgerVO ledgerVO = BeanMapper.map(entity, LedgerVO.class);

		List<LedgerScheduleVO> ledgerScheduleList = ledgerVO.getLedgerScheduleList();
		List<LedgerTypeVO> ledgerTypeList = ledgerVO.getLedgerTypeList();
		List<LedgerQualityVO> ledgerQualityList = ledgerVO.getLedgerQualityList();
		List<LedgerSafetyVO> ledgerSafetyList = ledgerVO.getLedgerSafetyList();
		List<LedgerMaterialVO> ledgerMaterialList = ledgerVO.getLedgerMaterialList();
		List<LedgerEquipmentVO> ledgerEquipmentList = ledgerVO.getLedgerEquipmentList();
		List<LedgerExamineVO> ledgerExamineList = ledgerVO.getLedgerExamineList();
		List<LedgerInformationVO> ledgerInformationList = ledgerVO.getLedgerInformationList();
		List<LedgerOtherVO> ledgerOtherList = ledgerVO.getLedgerOtherList();

		// 根据表名简写_work_type查询模版内容
		LambdaQueryWrapper<LedgerTemplateEntity> lambdaQuery = Wrappers.lambdaQuery();
		lambdaQuery.eq(LedgerTemplateEntity::getTemplateType, SCHEDULE_WORK_TYPE);
		List<LedgerTemplateEntity> ledgerTemplates = templateService.list(lambdaQuery);

		// 进度情况（施工员）
		if (CollectionUtils.isNotEmpty(ledgerScheduleList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, SCHEDULE_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerScheduleVO vo : ledgerScheduleList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject1 = new JSONObject();
		jsonObject1.put("title", SCHEDULE_TITLE);
		jsonObject1.put("describe", ledgerScheduleList);
		jsonObjects.add(jsonObject1);

		// 施工组织设计、方案、交底、变更情况（技术负责人）
		if (CollectionUtils.isNotEmpty(ledgerTypeList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, TYPE_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerTypeVO vo : ledgerTypeList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject2 = new JSONObject();
		jsonObject2.put("title", TYPE_TITLE);
		jsonObject2.put("describe", ledgerTypeList);
		jsonObjects.add(jsonObject2);

		// 工程质量检查、验收情况（质检员）
		if (CollectionUtils.isNotEmpty(ledgerQualityList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, QUALITY_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerQualityVO vo : ledgerQualityList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject3 = new JSONObject();
		jsonObject3.put("title", QUALITY_TITLE);
		jsonObject3.put("describe", ledgerQualityList);
		jsonObjects.add(jsonObject3);

		// 安全活动情况（安全员）
		if (CollectionUtils.isNotEmpty(ledgerSafetyList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, SAFETY_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerSafetyVO vo : ledgerSafetyList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject4 = new JSONObject();
		jsonObject4.put("title", SAFETY_TITLE);
		jsonObject4.put("describe", ledgerSafetyList);
		jsonObjects.add(jsonObject4);

		// 材料进场情况（材料员）
		if (CollectionUtils.isNotEmpty(ledgerMaterialList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, MATERIAL_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerMaterialVO vo : ledgerMaterialList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject5 = new JSONObject();
		jsonObject5.put("title", MATERIAL_TITLE);
		jsonObject5.put("describe", ledgerMaterialList);
		jsonObjects.add(jsonObject5);

		// 设备进场情况（设备管理员）
		if (CollectionUtils.isNotEmpty(ledgerEquipmentList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, EQUIPMENT_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerEquipmentVO vo : ledgerEquipmentList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject6 = new JSONObject();
		jsonObject6.put("title", EQUIPMENT_TITLE);
		jsonObject6.put("describe", ledgerEquipmentList);
		jsonObjects.add(jsonObject6);

		// 原材料检验、时间、试块及见证取样送检等情况（取样员）
		if (CollectionUtils.isNotEmpty(ledgerExamineList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, EXAMINE_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerExamineVO vo : ledgerExamineList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject7 = new JSONObject();
		jsonObject7.put("title", EXAMINE_TITLE);
		jsonObject7.put("describe", ledgerExamineList);
		jsonObjects.add(jsonObject7);

		// 工程资料归档及会议情况（资料员）
		if (CollectionUtils.isNotEmpty(ledgerInformationList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, INFORMATION_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerInformationVO vo : ledgerInformationList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject8 = new JSONObject();
		jsonObject8.put("title", INFORMATION_TITLE);
		jsonObject8.put("describe", ledgerInformationList);
		jsonObjects.add(jsonObject8);

		// 其他情况
		if (CollectionUtils.isNotEmpty(ledgerOtherList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, OTHER_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerOtherVO vo : ledgerOtherList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject9 = new JSONObject();
		jsonObject9.put("title", OTHER_TITLE);
		jsonObject9.put("describe", ledgerOtherList);
		jsonObjects.add(jsonObject9);


		return jsonObjects;
	}

	private static List<LedgerTemplateEntity> getTemplateContent(List<LedgerTemplateEntity> ledgerTemplates, String type) {
		return ledgerTemplates.stream().map(e -> {
			if (type.equals(e.getTemplateType())) {
				return e;
			}
			return null;
		}).collect(Collectors.toList());
	}

	/**
	 * 项目日志实体转换日志台账
	 *
	 * @param entity 项目日志实体
	 *
	 * @return 日志台账实体
	 */
	@Override
	public LedgerEntity projectLogConvertToLedger(ProjectLogEntity entity) {
		// todo: perf优化
		LedgerEntity ledgerEntity = ProjectLogMapper.INSTANCE.transToLedgerEntity(entity);
		List<ProjectLogDetailEntity> projectLogDetailList = entity.getProjectLogDetailList();
		List<ProjectLogScheduleEntity> projectLogScheduleList = entity.getProjectLogScheduleList();
		List<ProjectLogTypeEntity> projectLogTypeList = entity.getProjectLogTypeList();
		List<ProjectLogQualityEntity> projectLogQualityList = entity.getProjectLogQualityList();
		List<ProjectLogSafetyEntity> projectLogSafetyList = entity.getProjectLogSafetyList();
		List<ProjectLogMaterialEntity> projectLogMaterialList = entity.getProjectLogMaterialList();
		List<ProjectLogEquipmentEntity> projectLogEquipmentList = entity.getProjectLogEquipmentList();
		List<ProjectLogExamineEntity> projectLogExamineList = entity.getProjectLogExamineList();
		List<ProjectLogInformationEntity> projectLogInformationList = entity.getProjectLogInformationList();
		List<ProjectLogOtherEntity> projectLogOtherList = entity.getProjectLogOtherList();

		if (CollectionUtils.isNotEmpty(projectLogDetailList)) {
			projectLogDetailList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogDetailList)) {
				List<LedgerDetailEntity> entityList = ProjectLogDetailMapper.INSTANCE.transToLedgerDetailEntity(projectLogDetailList);
				ledgerEntity.setLedgerDetailList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogScheduleList)) {
			projectLogScheduleList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogScheduleList)) {
				List<LedgerScheduleEntity> entityList = ProjectLogScheduleMapper.INSTANCE.transToLedgerScheduleEntity(projectLogScheduleList);
				ledgerEntity.setLedgerScheduleList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogTypeList)) {
			projectLogTypeList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogTypeList)) {
				List<LedgerTypeEntity> entityList = ProjectLogTypeMapper.INSTANCE.transToLedgerTypeEntity(projectLogTypeList);
				ledgerEntity.setLedgerTypeList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogQualityList)) {
			projectLogQualityList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogQualityList)) {
				List<LedgerQualityEntity> entityList = ProjectLogQualityMapper.INSTANCE.transToLedgerQualityEntity(projectLogQualityList);
				ledgerEntity.setLedgerQualityList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogSafetyList)) {
			projectLogSafetyList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogSafetyList)) {
				List<LedgerSafetyEntity> entityList = ProjectLogSafetyMapper.INSTANCE.transToLedgerSafetyEntity(projectLogSafetyList);
				ledgerEntity.setLedgerSafetyList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogMaterialList)) {
			projectLogMaterialList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogMaterialList)) {
				List<LedgerMaterialEntity> entityList = ProjectLogMaterialMapper.INSTANCE.transToLedgerMaterialEntity(projectLogMaterialList);
				ledgerEntity.setLedgerMaterialList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogEquipmentList)) {
			projectLogEquipmentList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogEquipmentList)) {
				List<LedgerEquipmentEntity> entityList = ProjectLogEquipmentMapper.INSTANCE.transToLedgerEquipmentEntity(projectLogEquipmentList);
				ledgerEntity.setLedgerEquipmentList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogExamineList)) {
			projectLogExamineList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogExamineList)) {
				List<LedgerExamineEntity> entityList = ProjectLogExamineMapper.INSTANCE.transToLedgerExamineEntity(projectLogExamineList);
				ledgerEntity.setLedgerExamineList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogInformationList)) {
			projectLogInformationList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogInformationList)) {
				List<LedgerInformationEntity> entityList = ProjectLogInformationMapper.INSTANCE.transToLedgerInformationEntity(projectLogInformationList);
				ledgerEntity.setLedgerInformationList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogOtherList)) {
			projectLogOtherList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogOtherList)) {
				List<LedgerOtherEntity> entityList = ProjectLogOtherMapper.INSTANCE.transToLedgerOtherEntity(projectLogOtherList);
				ledgerEntity.setLedgerOtherList(entityList);
			}
		}

		return ledgerEntity;
	}
}
