package com.ejianc.business.probuilddiary.project.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.acceptance.api.IPurchaseAcceptanceApi;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.probuilddiary.ledger.bean.LedgerEntity;
import com.ejianc.business.probuilddiary.ledger.bean.LedgerTemplateEntity;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerTemplateService;
import com.ejianc.business.probuilddiary.ledger.vo.*;
import com.ejianc.business.probuilddiary.person.bean.*;
import com.ejianc.business.probuilddiary.person.service.IPersonService;
import com.ejianc.business.probuilddiary.project.bean.*;
import com.ejianc.business.probuilddiary.project.mapper.*;
import com.ejianc.business.probuilddiary.project.service.IProjectLogService;
import com.ejianc.business.probuilddiary.project.vo.*;
import com.ejianc.business.promaterial.check.api.ICheckApi;
import com.ejianc.business.rent.api.IRentAcceptanceApi;
import com.ejianc.business.warn.vo.CustomWarnSettingVO;
import com.ejianc.business.warn.vo.WarningDTO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目日志
 *
 * @author generator
 */
@Service("projectLogService")
public class ProjectLogServiceImpl extends BaseServiceImpl<ProjectLogMapper, ProjectLogEntity> implements IProjectLogService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String BILL_NAME = "项目日志";
	private static final String AUTO_SOURCE_TYPE = "自动生成";
	private static final String RULE_CODE = "PRO-BUILD-DIARY-PROJECT-LOG";
	private static final String CHECK_INFO = "个人日志已被撤回，请刷新页面重试";
	private static final String PERSON_BILL_TYPE = "EJCBT202209000022";
	private static final String PROJECT_LOG_BILL_TYPE = "EJCBT202209000019";
	private static final String EJC_BILL_ATTACHES = "ejc-bill-attaches";
	private static final String SCHEDULE_WORK_TYPE = "schedule_work_type";
	private static final String TYPE_WORK_TYPE = "type_work_type";
	private static final String QUALITY_WORK_TYPE = "quality_work_type";
	private static final String SAFETY_WORK_TYPE = "safety_work_type";
	private static final String MATERIAL_WORK_TYPE = "material_work_type";
	private static final String EQUIPMENT_WORK_TYPE = "equipment_work_type";
	private static final String EXAMINE_WORK_TYPE = "examine_work_type";
	private static final String INFORMATION_WORK_TYPE = "information_work_type";
	private static final String OTHER_WORK_TYPE = "other_work_type";
	private static final String SCHEDULE_TITLE = "进度情况（施工员）";
	private static final String TYPE_TITLE = "施工组织设计、方案、交底、变更情况（技术负责人）";
	private static final String QUALITY_TITLE = "工程质量检查、验收情况（质检员）";
	private static final String SAFETY_TITLE = "安全活动情况（安全员）";
	private static final String MATERIAL_TITLE = "材料进出场情况（材料员）";
	private static final String EQUIPMENT_TITLE = "设备进出场情况（设备管理员）";
	private static final String EXAMINE_TITLE = "检验试验情况（取样员）";
	private static final String INFORMATION_TITLE = "工程资料归档及会议情况（资料员）";
	private static final String OTHER_TITLE = "其他情况";
	private final ProjectLogMapper mapper;
	private final ProjectLogDetailMapper projectLogDetailMapper;
	private final ProjectLogScheduleMapper projectLogScheduleMapper;
	private final ProjectLogTypeMapper projectLogTypeMapper;
	private final ProjectLogQualityMapper projectLogQualityMapper;
	private final ProjectLogSafetyMapper projectLogSafetyMapper;
	private final ProjectLogMaterialMapper projectLogMaterialMapper;
	private final ProjectLogEquipmentMapper projectLogEquipmentMapper;
	private final ProjectLogExamineMapper projectLogExamineMapper;
	private final ProjectLogInformationMapper projectLogInformationMapper;
	private final ProjectLogOtherMapper projectLogOtherMapper;
	private final IBillCodeApi billCodeApi;
	private final ICheckApi checkApi;
	private final IRentAcceptanceApi rentAcceptanceApi;
	private final IPurchaseAcceptanceApi purchaseAcceptanceApi;
	private final IPersonService personService;
	private final IWarnCenterApi warnCenterApi;
	private final IProjectPoolApi projectPoolApi;
	private final IAttachmentApi attachmentApi;
	@Value(value = "${warning.code}")
	private String WARN_CODE;
	@Value("${common.env.base-host}")
	private String BaseHost;
	@Autowired
	private  ILedgerTemplateService templateService;

	public ProjectLogServiceImpl(ProjectLogMapper mapper, ProjectLogDetailMapper projectLogDetailMapper, ProjectLogScheduleMapper projectLogScheduleMapper, ProjectLogTypeMapper projectLogTypeMapper, ProjectLogQualityMapper projectLogQualityMapper, ProjectLogSafetyMapper projectLogSafetyMapper, ProjectLogMaterialMapper projectLogMaterialMapper, ProjectLogEquipmentMapper projectLogEquipmentMapper, ProjectLogExamineMapper projectLogExamineMapper, ProjectLogInformationMapper projectLogInformationMapper, ProjectLogOtherMapper projectLogOtherMapper, IBillCodeApi billCodeApi, ICheckApi checkApi, IRentAcceptanceApi rentAcceptanceApi, IPurchaseAcceptanceApi purchaseAcceptanceApi, IPersonService personService, IWarnCenterApi warnCenterApi, IProjectPoolApi projectPoolApi, IAttachmentApi attachmentApi) {
		this.mapper = mapper;
		this.projectLogDetailMapper = projectLogDetailMapper;
		this.projectLogScheduleMapper = projectLogScheduleMapper;
		this.projectLogTypeMapper = projectLogTypeMapper;
		this.projectLogQualityMapper = projectLogQualityMapper;
		this.projectLogSafetyMapper = projectLogSafetyMapper;
		this.projectLogMaterialMapper = projectLogMaterialMapper;
		this.projectLogEquipmentMapper = projectLogEquipmentMapper;
		this.projectLogExamineMapper = projectLogExamineMapper;
		this.projectLogInformationMapper = projectLogInformationMapper;
		this.projectLogOtherMapper = projectLogOtherMapper;
		this.billCodeApi = billCodeApi;
		this.checkApi = checkApi;
		this.rentAcceptanceApi = rentAcceptanceApi;
		this.purchaseAcceptanceApi = purchaseAcceptanceApi;
		this.personService = personService;
		this.warnCenterApi = warnCenterApi;
		this.projectPoolApi = projectPoolApi;
		this.attachmentApi = attachmentApi;
	}

	/**
	 * 是否有项目日志
	 *
	 * @param projectId 项目id
	 * @param fillDate  填报日期
	 *
	 * @return boolean
	 */
	@Override
	public boolean hasProjectLog(Long projectId, Date fillDate) {
		QueryWrapper<ProjectLogEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper
				.eq("project_id", projectId)
				.eq("fill_date", fillDate)
				.last("LIMIT 1");
		int count = mapper.selectCount(queryWrapper);
		return count == 1;
	}

	/**
	 * 个人日志转换成项目日志
	 *
	 * @param person        个人日志
	 * @param hasProjectLog 是否有项目日志
	 *
	 * @return 项目日志
	 */
	@Override
	public void personLogConvertToProjectLog(PersonEntity person, boolean hasProjectLog) {
		logger.info("校验当天是否有项目日志：{}，个人日志数据：{}", hasProjectLog, JSON.toJSONString(person, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

		HttpServletRequest request = ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
		HashMap<String, String> headers = new HashMap<>();
		headers.put("authority", request.getHeader("authority"));
		headers.put("ejc-token", request.getHeader("ejc-token"));

		ExecutorService executorService = Executors.newFixedThreadPool(4);


		// 当天有项目日志，则自动汇总到已有项目日志；当天没有项目日志，则根据个人日志生成自由态的项目日志
		if (hasProjectLog) {
			// 查询已存在的项目日志主实体
			LambdaQueryWrapper<ProjectLogEntity> lambdaQuery = Wrappers.lambdaQuery();
			lambdaQuery.eq(ProjectLogEntity::getProjectId, person.getProjectId());
			lambdaQuery.eq(ProjectLogEntity::getFillDate, person.getInformantDate());
			ProjectLogEntity projectLogEntity = super.getOne(lambdaQuery);

			// 项目日志不是审批中、审批通过、已提交，即只有自由态、审批驳回-4、审批驳回-6才汇总
			Integer billState = projectLogEntity.getBillState();
			if (billState.equals(BillStateEnum.UNCOMMITED_STATE.getBillStateCode())
					|| billState.equals(BillStateEnum.UNAPPROVED.getBillStateCode())) {
				// 查询项目日志主实体和子实体
				ProjectLogEntity projectLog = super.selectById(projectLogEntity.getId());
				// 根据个人日志拼接子实体数据
				ProjectLogEntity entity = spliceSubEntity(person, projectLog, headers, executorService);
				super.saveOrUpdate(entity, false);
				writeBackGatherFlag(person.getId());
				// 同步通用附件
				transportCommonAttachment(person, headers, executorService, projectLogEntity.getId());
			}
		} else {
			// 个人日志生成项目日志
			ProjectLogEntity entity = generateProjectLog(person, headers, executorService);
			super.saveOrUpdate(entity, false);
			writeBackGatherFlag(person.getId());
		}
	}

	/**
	 * 同步附件
	 *
	 * @param sourceBillId    从此id单据复制
	 * @param targetBillId    复制到目的单据id
	 * @param sourceType      源文件类型标识
	 * @param headers         请求头
	 * @param executorService 线程池
	 */
	private void transportAttachment(Long sourceBillId, Long targetBillId, String sourceType, HashMap<String, String> headers, ExecutorService executorService) {
		logger.info("个人日志同步附件到项目日志--start，入参：sourceBillId--{}，targetBillId--{}，sourceType--{}，headers--{}", sourceBillId, targetBillId, sourceType, JSON.toJSONString(headers));
		CompletableFuture.runAsync(() -> {
			logger.info("个人日志同步附件到项目日志--start");
			HashMap<String, Object> paramMaps = new HashMap<>();
			paramMaps.put("sourceBillId", sourceBillId);
			paramMaps.put("sourceBillType", PERSON_BILL_TYPE);
			paramMaps.put("sourceBillSourceType", sourceType);
			paramMaps.put("targetBillId", targetBillId);
			paramMaps.put("targetBillType", PROJECT_LOG_BILL_TYPE);
			paramMaps.put("targetBillSourceType", sourceType);
			String responseBody = HttpUtil.createGet(BaseHost + "ejc-file-web/api/attachref/copyFilesFromSourceBillToTargetBill")
					.addHeaders(headers)
					.form(paramMaps)
					.execute()
					.body();
			CommonResponse res = JSON.parseObject(responseBody, CommonResponse.class);
			if (!res.isSuccess()) {
				logger.info("个人日志同步附件到项目日志失败，sourceBillId--{}，sourceBillSourceType--{}，targetBillId--{}，失败原因：{}", sourceBillId, sourceType, targetBillId, res.getMsg());
			}
			logger.info("个人日志同步附件到项目日志--end");
		}, executorService);
	}

	/**
	 * 回写汇总状态
	 *
	 * @param id 个人日志id
	 */
	private void writeBackGatherFlag(Long id) {
		// 回写个人日已汇总
		LambdaUpdateWrapper<PersonEntity> lambdaUpdate = Wrappers.lambdaUpdate();
		lambdaUpdate.eq(PersonEntity::getId, id)
				.set(PersonEntity::getGatherFlag, true);
		personService.update(lambdaUpdate);
	}

	/**
	 * 子实体转换
	 *
	 * @param person          个人日志
	 * @param entity          项目日志
	 * @param headers         请求头
	 * @param executorService 线程池
	 *
	 * @return 转换后的项目日志实体
	 */
	private ProjectLogEntity spliceSubEntity(PersonEntity person, ProjectLogEntity entity, HashMap<String, String> headers, ExecutorService executorService) {
		List<PersonDetailEntity> detailList = person.getDetailList();
		List<PersonScheduleEntity> scheduleList = person.getScheduleList();
		List<PersonTypeEntity> typeList = person.getTypeList();
		List<PersonQualityEntity> qualityList = person.getQualityList();
		List<PersonSafetyEntity> safetyList = person.getSafetyList();
		List<PersonMaterialEntity> materialList = person.getMaterialList();
		List<PersonEquipmentEntity> equipmentList = person.getEquipmentList();
		List<PersonExamineEntity> examineList = person.getExamineList();
		List<PersonInformationEntity> informationList = person.getInformationList();
		List<PersonOtherEntity> otherList = person.getOtherList();

		// 项目日志-施工内容（施工员）
		if (CollectionUtils.isNotEmpty(detailList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogDetailList())) {
				for (PersonDetailEntity e : detailList) {
					ProjectLogDetailEntity p = new ProjectLogDetailEntity();
					p.setPersonId(e.getPersonId());
					p.setConstructId(e.getConstructId());
					p.setConstructName(e.getConstructName());
					p.setConstructCode(e.getConstructCode());
					p.setTeamName(e.getTeamName());
					p.setWorkNum(e.getWorkNum());
					p.setWorkMemo(e.getWorkMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setDutyId(e.getDutyId());
					p.setDutyCode(e.getDutyCode());
					p.setDutyName(e.getDutyName());
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					entity.getProjectLogDetailList().add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
			} else {
				ArrayList<ProjectLogDetailEntity> list = new ArrayList<>();
				for (PersonDetailEntity e : detailList) {
					ProjectLogDetailEntity p = new ProjectLogDetailEntity();
					p.setPersonId(e.getPersonId());
					p.setConstructId(e.getConstructId());
					p.setConstructName(e.getConstructName());
					p.setConstructCode(e.getConstructCode());
					p.setTeamName(e.getTeamName());
					p.setWorkNum(e.getWorkNum());
					p.setWorkMemo(e.getWorkMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setDutyId(e.getDutyId());
					p.setDutyCode(e.getDutyCode());
					p.setDutyName(e.getDutyName());
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					list.add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
				entity.setProjectLogDetailList(list);
			}
		}

		// 项目日志-进度情况（施工员）
		if (CollectionUtils.isNotEmpty(scheduleList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogScheduleList())) {
				for (PersonScheduleEntity e : scheduleList) {
					ProjectLogScheduleEntity p = new ProjectLogScheduleEntity();
					p.setPersonId(e.getPersonId());
					p.setScheduleMemo(e.getScheduleMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					entity.getProjectLogScheduleList().add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
			} else {
				ArrayList<ProjectLogScheduleEntity> list = new ArrayList<>();
				for (PersonScheduleEntity e : scheduleList) {
					ProjectLogScheduleEntity p = new ProjectLogScheduleEntity();
					p.setPersonId(e.getPersonId());
					p.setScheduleMemo(e.getScheduleMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					list.add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
				entity.setProjectLogScheduleList(list);
			}
		}

		// 项目日志-施工组织设计、方案、交底、变更情况（技术负责人）
		if (CollectionUtils.isNotEmpty(typeList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogTypeList())) {
				for (PersonTypeEntity e : typeList) {
					ProjectLogTypeEntity p = new ProjectLogTypeEntity();
					p.setPersonId(e.getPersonId());
					p.setWorkTypeId(e.getWorkTypeId());
					p.setWorkTypeName(e.getWorkTypeName());
					p.setWorkTypeCode(e.getWorkTypeCode());
					p.setWorkTypeMemo(e.getWorkTypeMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					entity.getProjectLogTypeList().add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
			} else {
				ArrayList<ProjectLogTypeEntity> list = new ArrayList<>();
				for (PersonTypeEntity e : typeList) {
					ProjectLogTypeEntity p = new ProjectLogTypeEntity();
					p.setPersonId(e.getPersonId());
					p.setWorkTypeId(e.getWorkTypeId());
					p.setWorkTypeName(e.getWorkTypeName());
					p.setWorkTypeCode(e.getWorkTypeCode());
					p.setWorkTypeMemo(e.getWorkTypeMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					list.add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
				entity.setProjectLogTypeList(list);
			}
		}

		//  项目日志-工程质量检查、验收情况（质检员）
		if (CollectionUtils.isNotEmpty(qualityList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogQualityList())) {
				for (PersonQualityEntity e : qualityList) {
					ProjectLogQualityEntity p = new ProjectLogQualityEntity();
					p.setPersonId(e.getPersonId());
					p.setQualityId(e.getQualityId());
					p.setQualityName(e.getQualityName());
					p.setQualityCode(e.getQualityCode());
					p.setQualityMemo(e.getQualityMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					entity.getProjectLogQualityList().add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
			} else {
				ArrayList<ProjectLogQualityEntity> list = new ArrayList<>();
				for (PersonQualityEntity e : qualityList) {
					ProjectLogQualityEntity p = new ProjectLogQualityEntity();
					p.setPersonId(e.getPersonId());
					p.setQualityId(e.getQualityId());
					p.setQualityName(e.getQualityName());
					p.setQualityCode(e.getQualityCode());
					p.setQualityMemo(e.getQualityMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					list.add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
				entity.setProjectLogQualityList(list);
			}
		}

		// 项目日志-安全活动情况（安全员）
		if (CollectionUtils.isNotEmpty(safetyList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogSafetyList())) {
				for (PersonSafetyEntity e : safetyList) {
					ProjectLogSafetyEntity p = new ProjectLogSafetyEntity();
					p.setPersonId(e.getPersonId());
					p.setSafetyId(e.getSafetyId());
					p.setSafetyName(e.getSafetyName());
					p.setSafetyCode(e.getSafetyCode());
					p.setSafetyMemo(e.getSafetyMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					entity.getProjectLogSafetyList().add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
			} else {
				ArrayList<ProjectLogSafetyEntity> list = new ArrayList<>();
				for (PersonSafetyEntity e : safetyList) {
					ProjectLogSafetyEntity p = new ProjectLogSafetyEntity();
					p.setPersonId(e.getPersonId());
					p.setSafetyId(e.getSafetyId());
					p.setSafetyName(e.getSafetyName());
					p.setSafetyCode(e.getSafetyCode());
					p.setSafetyMemo(e.getSafetyMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					list.add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
				entity.setProjectLogSafetyList(list);
			}
		}

		// 项目日志-材料进出场情况（材料员）
		if (CollectionUtils.isNotEmpty(materialList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogMaterialList())) {
				for (PersonMaterialEntity e : materialList) {
					ProjectLogMaterialEntity p = new ProjectLogMaterialEntity();
					p.setPersonId(e.getPersonId());
					p.setMaterialMemo(e.getMaterialMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					entity.getProjectLogMaterialList().add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
			} else {
				ArrayList<ProjectLogMaterialEntity> list = new ArrayList<>();
				for (PersonMaterialEntity e : materialList) {
					ProjectLogMaterialEntity p = new ProjectLogMaterialEntity();
					p.setPersonId(e.getPersonId());
					p.setMaterialMemo(e.getMaterialMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					list.add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
				entity.setProjectLogMaterialList(list);
			}
		}

		// 项目日志-设备进出场情况（设备管理员）
		if (CollectionUtils.isNotEmpty(equipmentList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogEquipmentList())) {
				for (PersonEquipmentEntity e : equipmentList) {
					ProjectLogEquipmentEntity p = new ProjectLogEquipmentEntity();
					p.setPersonId(e.getPersonId());
					p.setEquipmentMemo(e.getEquipmentMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					entity.getProjectLogEquipmentList().add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
			} else {
				ArrayList<ProjectLogEquipmentEntity> list = new ArrayList<>();
				for (PersonEquipmentEntity e : equipmentList) {
					ProjectLogEquipmentEntity p = new ProjectLogEquipmentEntity();
					p.setPersonId(e.getPersonId());
					p.setEquipmentMemo(e.getEquipmentMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					list.add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
				entity.setProjectLogEquipmentList(list);
			}
		}

		// 项目日志-检验试验情况（取样员）
		if (CollectionUtils.isNotEmpty(examineList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogExamineList())) {
				for (PersonExamineEntity e : examineList) {
					ProjectLogExamineEntity p = new ProjectLogExamineEntity();
					p.setPersonId(e.getPersonId());
					p.setMoldId(e.getMoldId());
					p.setMoldName(e.getMoldName());
					p.setMoldCode(e.getMoldCode());
					p.setMakeName(e.getMakeName());
					p.setInspectName(e.getInspectName());
					p.setExamineName(e.getExamineName());
					p.setExamineNum(e.getExamineNum());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					entity.getProjectLogExamineList().add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
			} else {
				ArrayList<ProjectLogExamineEntity> list = new ArrayList<>();
				for (PersonExamineEntity e : examineList) {
					ProjectLogExamineEntity p = new ProjectLogExamineEntity();
					p.setPersonId(e.getPersonId());
					p.setMoldId(e.getMoldId());
					p.setMoldName(e.getMoldName());
					p.setMoldCode(e.getMoldCode());
					p.setMakeName(e.getMakeName());
					p.setInspectName(e.getInspectName());
					p.setExamineName(e.getExamineName());
					p.setExamineNum(e.getExamineNum());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					list.add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
				entity.setProjectLogExamineList(list);
			}
		}

		// 项目日志-工程资料归档及会议情况（资料员）
		if (CollectionUtils.isNotEmpty(informationList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogInformationList())) {
				for (PersonInformationEntity e : informationList) {
					ProjectLogInformationEntity p = new ProjectLogInformationEntity();
					p.setPersonId(e.getPersonId());
					p.setInformMoldId(e.getInformMoldId());
					p.setInformMoldName(e.getInformMoldName());
					p.setInformMoldCode(e.getInformMoldCode());
					p.setInformationMemo(e.getInformationMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					entity.getProjectLogInformationList().add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
			} else {
				ArrayList<ProjectLogInformationEntity> list = new ArrayList<>();
				for (PersonInformationEntity e : informationList) {
					ProjectLogInformationEntity p = new ProjectLogInformationEntity();
					p.setPersonId(e.getPersonId());
					p.setInformMoldId(e.getInformMoldId());
					p.setInformMoldName(e.getInformMoldName());
					p.setInformMoldCode(e.getInformMoldCode());
					p.setInformationMemo(e.getInformationMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					list.add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
				entity.setProjectLogInformationList(list);
			}
		}

		// 项目日志-其他情况
		if (CollectionUtils.isNotEmpty(otherList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogOtherList())) {
				for (PersonOtherEntity e : otherList) {
					ProjectLogOtherEntity p = new ProjectLogOtherEntity();
					p.setPersonId(e.getPersonId());
					p.setOtherMemo(e.getOtherMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					entity.getProjectLogOtherList().add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
			} else {
				ArrayList<ProjectLogOtherEntity> list = new ArrayList<>();
				for (PersonOtherEntity e : otherList) {
					ProjectLogOtherEntity p = new ProjectLogOtherEntity();
					p.setPersonId(e.getPersonId());
					p.setOtherMemo(e.getOtherMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setFileType(e.getFileType());
					p.setUpdateFlag(Boolean.TRUE);
					list.add(p);

					transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), entity.getId(), e.getFileType(), headers, executorService);
				}
				entity.setProjectLogOtherList(list);
			}
		}


		return entity;
	}

	/**
	 * 同步个人日志子表附件
	 *
	 * @param e               是否同步
	 * @param personId        个人日志id
	 * @param targetBillId    目标日志id
	 * @param sourceType      来源业务类型
	 * @param headers         请求头
	 * @param executorService 线程池
	 */
	private void transportToProjectLogSub(boolean e, Long personId, Long targetBillId, String sourceType, HashMap<String, String> headers, ExecutorService executorService) {
		if (e) {
			transportAttachment(personId, targetBillId, sourceType, headers, executorService);
		}
	}


	private ProjectLogEntity generateProjectLog(PersonEntity person, HashMap<String, String> headers, ExecutorService executorService) {
		ProjectLogEntity entity = new ProjectLogEntity();
		long targetBillId = IdWorker.getId();
		entity.setId(targetBillId);
		entity.setBillCode(generateBillCode());
		entity.setBillName(BILL_NAME);
		entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
		entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());
		entity.setOrgId(person.getOrgId());
		entity.setOrgCode(person.getOrgCode());
		entity.setOrgName(person.getOrgName());
		entity.setParentOrgId(person.getParentOrgId());
		entity.setParentOrgCode(person.getParentOrgCode());
		entity.setParentOrgName(person.getParentOrgName());
		entity.setProjectId(person.getProjectId());
		entity.setProjectCode(person.getProjectCode());
		entity.setProjectName(person.getProjectName());
		entity.setSourceType(AUTO_SOURCE_TYPE);
		entity.setFillDate(person.getInformantDate());
		entity.setWeek(getDayOfTheWeek(person.getInformantDate()));

		// 同步通用附件
		transportCommonAttachment(person, headers, executorService, targetBillId);

		// todo:优化
		entity.setProjectLogDetailList(personConvertToProjectLogDetail(person, person.getDetailList(), headers, executorService, targetBillId));
		entity.setProjectLogScheduleList(personConvertToProjectLogSchedule(person, person.getScheduleList(), headers, executorService, targetBillId));
		entity.setProjectLogTypeList(personConvertToProjectLogType(person, person.getTypeList(), headers, executorService, targetBillId));
		entity.setProjectLogQualityList(personConvertToProjectLogQuality(person, person.getQualityList(), headers, executorService, targetBillId));
		entity.setProjectLogSafetyList(personConvertToProjectLogSafety(person, person.getSafetyList(), headers, executorService, targetBillId));
		entity.setProjectLogMaterialList(personConvertToProjectLogMaterial(person, person.getMaterialList(), headers, executorService, targetBillId));
		entity.setProjectLogEquipmentList(personConvertToProjectLogEquipment(person, person.getEquipmentList(), headers, executorService, targetBillId));
		entity.setProjectLogExamineList(personConvertToProjectLogExamine(person, person.getExamineList(), headers, executorService, targetBillId));
		entity.setProjectLogInformationList(personConvertToProjectLogInformation(person, person.getInformationList(), headers, executorService, targetBillId));
		entity.setProjectLogOtherList(personConvertToProjectLogOther(person, person.getOtherList(), headers, executorService, targetBillId));

		return entity;
	}

	/**
	 * 同步通用附件
	 *
	 * @param person          个人日志实体
	 * @param headers         请求头
	 * @param executorService 线程池
	 * @param targetBillId    目标单据id
	 */
	private void transportCommonAttachment(PersonEntity person, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
		CommonResponse<List<AttachmentVO>> commonResponse = attachmentApi.queryListBySourceId(person.getId(), PERSON_BILL_TYPE, EJC_BILL_ATTACHES, null);
		transportToProjectLogSub(commonResponse.isSuccess() && CollectionUtils.isNotEmpty(commonResponse.getData()), person.getId(), targetBillId, EJC_BILL_ATTACHES, headers, executorService);
	}

	/**
	 * 生成单据编码
	 *
	 * @return 单据编码
	 */
	private String generateBillCode() {
		BillCodeParam billCodeParam = BillCodeParam.build(RULE_CODE, InvocationInfoProxy.getTenantid(), new ProjectLogVO());
		CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
		if (!billCode.isSuccess()) {
			throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
		}
		return billCode.getData();
	}

	/**
	 * 获取星期几
	 *
	 * @param date 填报日期
	 *
	 * @return 星期几
	 */
	private String getDayOfTheWeek(Date date) {
		String[][] strArray = {
				{"MONDAY", "星期一"},
				{"TUESDAY", "星期二"},
				{"WEDNESDAY", "星期三"},
				{"THURSDAY", "星期四"},
				{"FRIDAY", "星期五"},
				{"SATURDAY", "星期六"},
				{"SUNDAY", "星期日"}
		};

		LocalDate currentDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
		String k = String.valueOf(currentDate.getDayOfWeek());
		String week = null;
		for (String[] strings : strArray) {
			if (k.equals(strings[0])) {
				week = strings[1];
				break;
			}
		}
		return week;
	}

	/**
	 * 个人日志转项目日志子实体-施工内容（施工员）
	 *
	 * @param person          个人日志主实体
	 * @param detailList      个人日志子实体
	 * @param headers         请求头
	 * @param executorService 线程池
	 * @param targetBillId    目标单据id
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogDetailEntity> personConvertToProjectLogDetail(PersonEntity person, List<PersonDetailEntity> detailList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
		ArrayList<ProjectLogDetailEntity> list = new ArrayList<>();
		for (PersonDetailEntity e : detailList) {
			ProjectLogDetailEntity p = new ProjectLogDetailEntity();
			p.setPersonId(e.getPersonId());
			p.setConstructId(e.getConstructId());
			p.setConstructName(e.getConstructName());
			p.setConstructCode(e.getConstructCode());
			p.setTeamName(e.getTeamName());
			p.setWorkNum(e.getWorkNum());
			p.setWorkMemo(e.getWorkMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			p.setDutyId(e.getDutyId());
			p.setDutyCode(e.getDutyCode());
			p.setDutyName(e.getDutyName());
			p.setFileType(e.getFileType());
			p.setUpdateFlag(Boolean.TRUE);
			list.add(p);

			transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
		}
		return list;
	}


	/**
	 * 个人日志转项目日志子实体-进度情况（施工员）
	 *
	 * @param person          个人日志主实体
	 * @param scheduleList    个人日志子实体
	 * @param headers         请求头
	 * @param executorService 线程池
	 * @param targetBillId    目标单据id
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogScheduleEntity> personConvertToProjectLogSchedule(PersonEntity person, List<PersonScheduleEntity> scheduleList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
		ArrayList<ProjectLogScheduleEntity> list = new ArrayList<>();
		for (PersonScheduleEntity e : scheduleList) {
			ProjectLogScheduleEntity p = new ProjectLogScheduleEntity();
			p.setPersonId(e.getPersonId());
			p.setScheduleMemo(e.getScheduleMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			p.setFileType(e.getFileType());
			p.setUpdateFlag(Boolean.TRUE);
			list.add(p);

			transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-施工组织设计、方案、交底、变更情况（技术负责人）
	 *
	 * @param person          个人日志主实体
	 * @param typeList        个人日志子实体
	 * @param headers         请求头
	 * @param executorService 线程池
	 * @param targetBillId    目标单据id
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogTypeEntity> personConvertToProjectLogType(PersonEntity person, List<PersonTypeEntity> typeList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
		ArrayList<ProjectLogTypeEntity> list = new ArrayList<>();
		for (PersonTypeEntity e : typeList) {
			ProjectLogTypeEntity p = new ProjectLogTypeEntity();
			p.setPersonId(e.getPersonId());
			p.setWorkTypeId(e.getWorkTypeId());
			p.setWorkTypeName(e.getWorkTypeName());
			p.setWorkTypeCode(e.getWorkTypeCode());
			p.setWorkTypeMemo(e.getWorkTypeMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			p.setFileType(e.getFileType());
			p.setUpdateFlag(Boolean.TRUE);
			list.add(p);

			transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-工程质量检查、验收情况（质检员）
	 *
	 * @param person          个人日志主实体
	 * @param qualityList     个人日志子实体
	 * @param headers         请求头
	 * @param executorService 线程池
	 * @param targetBillId    目标单据id
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogQualityEntity> personConvertToProjectLogQuality(PersonEntity person, List<PersonQualityEntity> qualityList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
		ArrayList<ProjectLogQualityEntity> list = new ArrayList<>();
		for (PersonQualityEntity e : qualityList) {
			ProjectLogQualityEntity p = new ProjectLogQualityEntity();
			p.setPersonId(e.getPersonId());
			p.setQualityId(e.getQualityId());
			p.setQualityName(e.getQualityName());
			p.setQualityCode(e.getQualityCode());
			p.setQualityMemo(e.getQualityMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			p.setFileType(e.getFileType());
			p.setUpdateFlag(Boolean.TRUE);
			list.add(p);

			transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-安全活动情况（安全员）
	 *
	 * @param person          个人日志主实体
	 * @param safetyList      个人日志子实体
	 * @param headers         请求头
	 * @param executorService 线程池
	 * @param targetBillId    目标单据id
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogSafetyEntity> personConvertToProjectLogSafety(PersonEntity person, List<PersonSafetyEntity> safetyList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
		ArrayList<ProjectLogSafetyEntity> list = new ArrayList<>();
		for (PersonSafetyEntity e : safetyList) {
			ProjectLogSafetyEntity p = new ProjectLogSafetyEntity();
			p.setPersonId(e.getPersonId());
			p.setSafetyId(e.getSafetyId());
			p.setSafetyName(e.getSafetyName());
			p.setSafetyCode(e.getSafetyCode());
			p.setSafetyMemo(e.getSafetyMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			p.setFileType(e.getFileType());
			p.setUpdateFlag(Boolean.TRUE);
			list.add(p);

			transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-
	 *
	 * @param person          个人日志主实体
	 * @param materialList    个人日志子实体
	 * @param headers         请求头
	 * @param executorService 线程池
	 * @param targetBillId    目标单据id
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogMaterialEntity> personConvertToProjectLogMaterial(PersonEntity person, List<PersonMaterialEntity> materialList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
		ArrayList<ProjectLogMaterialEntity> list = new ArrayList<>();
		for (PersonMaterialEntity e : materialList) {
			ProjectLogMaterialEntity p = new ProjectLogMaterialEntity();
			p.setPersonId(e.getPersonId());
			p.setMaterialMemo(e.getMaterialMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			p.setFileType(e.getFileType());
			p.setUpdateFlag(Boolean.TRUE);
			list.add(p);

			transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-设备进出场情况（设备管理员）
	 *
	 * @param person          个人日志主实体
	 * @param equipmentList   个人日志子实体
	 * @param headers         请求头
	 * @param executorService 线程池
	 * @param targetBillId    目标单据id
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogEquipmentEntity> personConvertToProjectLogEquipment(PersonEntity person, List<PersonEquipmentEntity> equipmentList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
		ArrayList<ProjectLogEquipmentEntity> list = new ArrayList<>();
		for (PersonEquipmentEntity e : equipmentList) {
			ProjectLogEquipmentEntity p = new ProjectLogEquipmentEntity();
			p.setPersonId(e.getPersonId());
			p.setEquipmentMemo(e.getEquipmentMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			p.setFileType(e.getFileType());
			p.setUpdateFlag(Boolean.TRUE);
			list.add(p);

			transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-检验试验情况（取样员）
	 *
	 * @param person          个人日志主实体
	 * @param examineList     个人日志子实体
	 * @param headers         请求头
	 * @param executorService 线程池
	 * @param targetBillId    目标单据id
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogExamineEntity> personConvertToProjectLogExamine(PersonEntity person, List<PersonExamineEntity> examineList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
		ArrayList<ProjectLogExamineEntity> list = new ArrayList<>();
		for (PersonExamineEntity e : examineList) {
			ProjectLogExamineEntity p = new ProjectLogExamineEntity();
			p.setPersonId(e.getPersonId());
			p.setMoldId(e.getMoldId());
			p.setMoldName(e.getMoldName());
			p.setMoldCode(e.getMoldCode());
			p.setMakeName(e.getMakeName());
			p.setExamineMemo(e.getExamineMemo());
			p.setInspectName(e.getInspectName());
			p.setExamineName(e.getExamineName());
			p.setExamineNum(e.getExamineNum());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			p.setFileType(e.getFileType());
			p.setUpdateFlag(Boolean.TRUE);
			list.add(p);

			transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-工程资料归档及会议情况（资料员）
	 *
	 * @param person          个人日志主实体
	 * @param informationList 个人日志子实体
	 * @param headers         请求头
	 * @param executorService 线程池
	 * @param targetBillId    目标单据id
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogInformationEntity> personConvertToProjectLogInformation(PersonEntity person, List<PersonInformationEntity> informationList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
		ArrayList<ProjectLogInformationEntity> list = new ArrayList<>();
		for (PersonInformationEntity e : informationList) {
			ProjectLogInformationEntity p = new ProjectLogInformationEntity();
			p.setPersonId(e.getPersonId());
			p.setInformMoldId(e.getInformMoldId());
			p.setInformMoldName(e.getInformMoldName());
			p.setInformMoldCode(e.getInformMoldCode());
			p.setInformationMemo(e.getInformationMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			p.setFileType(e.getFileType());
			p.setUpdateFlag(Boolean.TRUE);
			list.add(p);

			transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-其他情况
	 *
	 * @param person          个人日志主实体
	 * @param otherList       个人日志子实体
	 * @param headers         请求头
	 * @param executorService 线程池
	 * @param targetBillId    目标单据id
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogOtherEntity> personConvertToProjectLogOther(PersonEntity person, List<PersonOtherEntity> otherList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
		ArrayList<ProjectLogOtherEntity> list = new ArrayList<>();
		for (PersonOtherEntity e : otherList) {
			ProjectLogOtherEntity p = new ProjectLogOtherEntity();
			p.setPersonId(e.getPersonId());
			p.setOtherMemo(e.getOtherMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			p.setFileType(e.getFileType());
			p.setUpdateFlag(Boolean.TRUE);
			list.add(p);

			transportToProjectLogSub(StringUtils.isNotBlank(e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
		}
		return list;
	}


	/**
	 * 查询验收单据数量
	 *
	 * @param jsonObject 参数
	 *
	 * @return Map<String, Integer>
	 */
	@Override
	public Map<String, Integer> countBillNum(JSONObject jsonObject) {
		if (!jsonObject.containsKey("projectId")) {
			throw new BusinessException("项目id不能为空！");
		}
		if (!jsonObject.containsKey("fillDate")) {
			throw new BusinessException("填报日期不能为空！");
		}
		CommonResponse<Map<String, Integer>> res1 = checkApi.countBillNum(jsonObject);
		if (!res1.isSuccess()) {
			throw new BusinessException("查询消耗材、混凝土单据数量失败，失败原因：" + res1.getMsg());
		}
		Map<String, Integer> data = res1.getData();
		CommonResponse<Integer> res2 = rentAcceptanceApi.countBillNum(jsonObject);
		if (!res2.isSuccess()) {
			throw new BusinessException("查询设备租赁单据数量失败，失败原因：" + res2.getMsg());
		}
		data.put("设备租赁", res2.getData());
		CommonResponse<Integer> res3 = purchaseAcceptanceApi.countBillNum(jsonObject);
		if (!res3.isSuccess()) {
			throw new BusinessException("查询设备采购单据数量失败，失败原因：" + res3.getMsg());
		}
		data.put("设备采购", res3.getData());
		return data;
	}


	/**
	 * 校验个人日志单据状态是否是自由态
	 *
	 * @param entity 项目日志实体
	 */
	@Override
	public void checkPersonBillState(ProjectLogEntity entity) {
		List<ProjectLogDetailEntity> projectLogDetailList = entity.getProjectLogDetailList();
		List<ProjectLogScheduleEntity> projectLogScheduleList = entity.getProjectLogScheduleList();
		List<ProjectLogTypeEntity> projectLogTypeList = entity.getProjectLogTypeList();
		List<ProjectLogQualityEntity> projectLogQualityList = entity.getProjectLogQualityList();
		List<ProjectLogSafetyEntity> projectLogSafetyList = entity.getProjectLogSafetyList();
		List<ProjectLogMaterialEntity> projectLogMaterialList = entity.getProjectLogMaterialList();
		List<ProjectLogEquipmentEntity> projectLogEquipmentList = entity.getProjectLogEquipmentList();
		List<ProjectLogExamineEntity> projectLogExamineList = entity.getProjectLogExamineList();
		List<ProjectLogInformationEntity> projectLogInformationList = entity.getProjectLogInformationList();
		List<ProjectLogOtherEntity> projectLogOtherList = entity.getProjectLogOtherList();

		HashSet<Long> ids = new HashSet<>();

		if (CollectionUtils.isNotEmpty(projectLogDetailList)) {
			ids.addAll(projectLogDetailList.stream().map(ProjectLogDetailEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogScheduleList)) {
			ids.addAll(projectLogScheduleList.stream().map(ProjectLogScheduleEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogTypeList)) {
			ids.addAll(projectLogTypeList.stream().map(ProjectLogTypeEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogQualityList)) {
			ids.addAll(projectLogQualityList.stream().map(ProjectLogQualityEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogSafetyList)) {
			ids.addAll(projectLogSafetyList.stream().map(ProjectLogSafetyEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogMaterialList)) {
			ids.addAll(projectLogMaterialList.stream().map(ProjectLogMaterialEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogEquipmentList)) {
			ids.addAll(projectLogEquipmentList.stream().map(ProjectLogEquipmentEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogExamineList)) {
			ids.addAll(projectLogExamineList.stream().map(ProjectLogExamineEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogInformationList)) {
			ids.addAll(projectLogInformationList.stream().map(ProjectLogInformationEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogOtherList)) {
			ids.addAll(projectLogOtherList.stream().map(ProjectLogOtherEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(ids)) {
			Integer count = personService.countUncommitedState(ids);
			if (count > 0) {
				throw new BusinessException(CHECK_INFO);
			}
		}
	}


	/**
	 * 预警
	 *
	 * @param request 请求信息
	 */
	@Override
	public void warn(HttpServletRequest request) {
		logger.warn("根据调度参数编码：{}，当前组织id：{}", WARN_CODE, InvocationInfoProxy.getOrgId());
		CommonResponse<WarningDTO> commonResponse = warnCenterApi.getWarnSet(WARN_CODE, InvocationInfoProxy.getOrgId());
		if (!commonResponse.isSuccess()) {
			throw new BusinessException("根据调度参数编码：" + WARN_CODE + "，当前组织id：" + InvocationInfoProxy.getOrgId() + ",获取预警配置失败，失败原因：" + commonResponse.getMsg());
		}
		logger.info("查询预警中心设置：{}", JSON.toJSONString(commonResponse, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

		WarningDTO warningDTO = commonResponse.getData();
		List<CustomWarnSettingVO> customWarnSettingVOS = warningDTO.getWarningSetings();
		if (CollectionUtils.isNotEmpty(customWarnSettingVOS)) {
			// 在建项目ids
			CommonResponse<List<ProjectVO>> response = projectPoolApi.queryProjectsByOrgId(InvocationInfoProxy.getOrgId());
			if (!response.isSuccess()) {
				throw new BusinessException("根据当前组织：" + InvocationInfoProxy.getOrgId() + "查询当前组织下所有启用且在建的项目失败，失败原因：" + response.getMsg());
			}
			List<ProjectVO> data = response.getData();
			logger.info("启用且在建的项目：{}", JSON.toJSONString(data, SerializerFeature.WriteMapNullValue));
			if (CollectionUtils.isNotEmpty(data)) {
				CustomWarnSettingVO customWarnSettingVO = customWarnSettingVOS.get(0);

				int day = Integer.parseInt(customWarnSettingVO.getParameterValue());
				LocalDate now = LocalDate.now();
				LocalDate warn = now.minusDays(day);
				DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
				logger.info("当前日期：{}，预警前{}天，要预警的日期：{}", now.format(formatter), day, warn.format(formatter));

				Date warnDate = Date.from(warn.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());

				LambdaQueryWrapper<ProjectLogEntity> lambdaQuery = Wrappers.lambdaQuery();
				lambdaQuery.eq(ProjectLogEntity::getFillDate, warnDate);
				List<ProjectLogEntity> projectLogEntityList = super.list(lambdaQuery);

				List<EarlyWarnTransVO> warnTransVO = new ArrayList<>();
				if (CollectionUtils.isNotEmpty(projectLogEntityList)) {
					logger.info("预警在建启用的项目--part，已填报的项目日志：{}", JSON.toJSONString(projectLogEntityList, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
					Map<Long, ProjectVO> projectVOMap = data.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
					for (ProjectLogEntity projectLogEntity : projectLogEntityList) {
						projectVOMap.remove(projectLogEntity.getProjectId());
					}
					if (!projectVOMap.isEmpty()) {
						Collection<ProjectVO> values = projectVOMap.values();
						logger.info("预警在建启用的项目--part，未填报的项目：{}", JSON.toJSONString(values, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
						splice(warningDTO, warn, formatter, warnTransVO, values);
					}
				} else {
					logger.info("预警在建启用的项目--all");
					splice(warningDTO, warn, formatter, warnTransVO, data);
				}
				if (CollectionUtils.isNotEmpty(warnTransVO)) {
					CommonResponse<String> res = warnCenterApi.sendToWarnCenterByCode(warnTransVO, WARN_CODE);
					if (!res.isSuccess()) {
						logger.info("预警内容发送至预警中心失败，具体参数：{},预警参数编码：{}，失败原因：{}", JSON.toJSONString(warnTransVO), WARN_CODE, res.getMsg());
					}
					logger.info("预警中心响应：{}", JSON.toJSONString(res, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
				}
			}
		}
	}

	/**
	 * 拼接数据
	 *
	 * @param warningDTO  预警配置
	 * @param warn        预警日期
	 * @param formatter   日期格式化模版
	 * @param warnTransVO 预警数据
	 * @param values      未填报的
	 */
	private static void splice(WarningDTO warningDTO, LocalDate warn, DateTimeFormatter formatter, List<EarlyWarnTransVO> warnTransVO, Collection<ProjectVO> values) {
		for (ProjectVO projectVO : values) {
			EarlyWarnTransVO vo = new EarlyWarnTransVO();
			vo.setSourceId(String.valueOf(projectVO.getId()));
			vo.setTenantId(projectVO.getTenantId());
			vo.setOrgId(projectVO.getOrgId());
			vo.setOrgName(projectVO.getOrgName());
			vo.setSendOrgId(String.valueOf(projectVO.getOrgId()));
			vo.setEarlywarnName(warningDTO.getName());
			vo.setBillName(projectVO.getProjectName());
			vo.setEarlywarnContent(warningDTO.getWarningContentTemplate().replace("#projectName#", projectVO.getProjectName()).replace("#fillDate#", warn.format(formatter)));
			vo.setWarnSetId(warningDTO.getId());
			vo.setWarnSetParamId(CollectionUtils.isNotEmpty(warningDTO.getWarningSetings()) ? warningDTO.getWarningSetings().get(0).getId() : null);
			vo.setMoUrl("/ejc-probuilddiary-mobile/#/projectLog/card");
			vo.setPcTitle("项目日志");
			vo.setWarnLevel(warningDTO.getWarningLevel());
			vo.setWarnType(String.valueOf(warningDTO.getWarnType()));
			warnTransVO.add(vo);
		}
	}

	/**
	 * 删除个人日志数据
	 *
	 * @param id            个人日志id
	 * @param projectId
	 * @param informantDate
	 */
	@Override
	public void deleteAllDataByPersonId(Long id, Long projectId, Date informantDate) {
		projectLogDetailMapper.deleteByPersonId(id);
		projectLogScheduleMapper.deleteByPersonId(id);
		projectLogTypeMapper.deleteByPersonId(id);
		projectLogQualityMapper.deleteByPersonId(id);
		projectLogSafetyMapper.deleteByPersonId(id);
		projectLogMaterialMapper.deleteByPersonId(id);
		projectLogEquipmentMapper.deleteByPersonId(id);
		projectLogExamineMapper.deleteByPersonId(id);
		projectLogInformationMapper.deleteByPersonId(id);
		projectLogOtherMapper.deleteByPersonId(id);

		// 根据项目id和填报日期查询项目日志
		LambdaQueryWrapper<ProjectLogEntity> lambdaQuery = Wrappers.lambdaQuery();
		lambdaQuery.eq(ProjectLogEntity::getProjectId, projectId)
				.eq(ProjectLogEntity::getFillDate, informantDate);
        List<ProjectLogEntity> list = super.list(lambdaQuery);
        if(CollectionUtils.isNotEmpty(list)){
			ProjectLogEntity projectLogEntity = list.get(0);
			if(null != projectLogEntity){
				ProjectLogEntity entity = super.selectById(projectLogEntity.getId());
				if(entity != null){
					// 所有子表数据，都为空则删除项目日志主表
					if (CollectionUtils.isEmpty(entity.getProjectLogDetailList())
							&& CollectionUtils.isEmpty(entity.getProjectLogScheduleList())
							&& CollectionUtils.isEmpty(entity.getProjectLogTypeList())
							&& CollectionUtils.isEmpty(entity.getProjectLogQualityList())
							&& CollectionUtils.isEmpty(entity.getProjectLogSafetyList())
							&& CollectionUtils.isEmpty(entity.getProjectLogMaterialList())
							&& CollectionUtils.isEmpty(entity.getProjectLogEquipmentList())
							&& CollectionUtils.isEmpty(entity.getProjectLogExamineList())
							&& CollectionUtils.isEmpty(entity.getProjectLogInformationList())
							&& CollectionUtils.isEmpty(entity.getProjectLogOtherList())) {
						mapper.deleteByProjectIdAndFillDate(projectId, informantDate);
					}
				}
			}
		}



	}

	@Override
	public List<JSONObject> fetchOtherSubDetail(Long id) {
		ArrayList<JSONObject> jsonObjects = new ArrayList<>();

		ProjectLogEntity entity = super.selectById(id);
		ProjectLogVO logVO = BeanMapper.map(entity, ProjectLogVO.class);

		List<ProjectLogScheduleVO> ledgerScheduleList = logVO.getProjectLogScheduleList();
		List<ProjectLogTypeVO> ledgerTypeList = logVO.getProjectLogTypeList();
		List<ProjectLogQualityVO> ledgerQualityList = logVO.getProjectLogQualityList();
		List<ProjectLogSafetyVO> ledgerSafetyList = logVO.getProjectLogSafetyList();
		List<ProjectLogMaterialVO> ledgerMaterialList = logVO.getProjectLogMaterialList();
		List<ProjectLogEquipmentVO> ledgerEquipmentList = logVO.getProjectLogEquipmentList();
		List<ProjectLogExamineVO> ledgerExamineList = logVO.getProjectLogExamineList();
		List<ProjectLogInformationVO> ledgerInformationList = logVO.getProjectLogInformationList();
		List<ProjectLogOtherVO> ledgerOtherList = logVO.getProjectLogOtherList();

		// 根据表名简写_work_type查询模版内容
		List<LedgerTemplateEntity> ledgerTemplates = templateService.list();

		// 进度情况（施工员）
		if (CollectionUtils.isNotEmpty(ledgerScheduleList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, SCHEDULE_WORK_TYPE);
			if (null != collect) {
				for (ProjectLogScheduleVO vo : ledgerScheduleList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject1 = new JSONObject();
		jsonObject1.put("title", SCHEDULE_TITLE);
		jsonObject1.put("describe", ledgerScheduleList);
		jsonObjects.add(jsonObject1);

		// 施工组织设计、方案、交底、变更情况（技术负责人）
		if (CollectionUtils.isNotEmpty(ledgerTypeList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, TYPE_WORK_TYPE);
			if (null != collect) {
				for (ProjectLogTypeVO vo : ledgerTypeList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject2 = new JSONObject();
		jsonObject2.put("title", TYPE_TITLE);
		jsonObject2.put("describe", ledgerTypeList);
		jsonObjects.add(jsonObject2);

		// 工程质量检查、验收情况（质检员）
		if (CollectionUtils.isNotEmpty(ledgerQualityList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, QUALITY_WORK_TYPE);
			if (null != collect) {
				for (ProjectLogQualityVO vo : ledgerQualityList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject3 = new JSONObject();
		jsonObject3.put("title", QUALITY_TITLE);
		jsonObject3.put("describe", ledgerQualityList);
		jsonObjects.add(jsonObject3);

		// 安全活动情况（安全员）
		if (CollectionUtils.isNotEmpty(ledgerSafetyList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, SAFETY_WORK_TYPE);
			if (null != collect) {
				for (ProjectLogSafetyVO vo : ledgerSafetyList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject4 = new JSONObject();
		jsonObject4.put("title", SAFETY_TITLE);
		jsonObject4.put("describe", ledgerSafetyList);
		jsonObjects.add(jsonObject4);

		// 材料进出场情况（材料员）
		if (CollectionUtils.isNotEmpty(ledgerMaterialList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, MATERIAL_WORK_TYPE);
			if (null != collect) {
				for (ProjectLogMaterialVO vo : ledgerMaterialList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject5 = new JSONObject();
		jsonObject5.put("title", MATERIAL_TITLE);
		jsonObject5.put("describe", ledgerMaterialList);
		jsonObjects.add(jsonObject5);

		// 设备进出场情况（设备管理员）
		if (CollectionUtils.isNotEmpty(ledgerEquipmentList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, EQUIPMENT_WORK_TYPE);
			if (null != collect) {
				for (ProjectLogEquipmentVO vo : ledgerEquipmentList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject6 = new JSONObject();
		jsonObject6.put("title", EQUIPMENT_TITLE);
		jsonObject6.put("describe", ledgerEquipmentList);
		jsonObjects.add(jsonObject6);

		// 检验试验情况（取样员）
		if (CollectionUtils.isNotEmpty(ledgerExamineList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, EXAMINE_WORK_TYPE);
			if (null != collect) {
				for (ProjectLogExamineVO vo : ledgerExamineList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject7 = new JSONObject();
		jsonObject7.put("title", EXAMINE_TITLE);
		jsonObject7.put("describe", ledgerExamineList);
		jsonObjects.add(jsonObject7);

		// 工程资料归档及会议情况（资料员）
		if (CollectionUtils.isNotEmpty(ledgerInformationList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, INFORMATION_WORK_TYPE);
			if (null != collect) {
				for (ProjectLogInformationVO vo : ledgerInformationList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject8 = new JSONObject();
		jsonObject8.put("title", INFORMATION_TITLE);
		jsonObject8.put("describe", ledgerInformationList);
		jsonObjects.add(jsonObject8);

		// 其他情况
		if (CollectionUtils.isNotEmpty(ledgerOtherList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, OTHER_WORK_TYPE);
			if (null != collect) {
				for (ProjectLogOtherVO vo : ledgerOtherList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject9 = new JSONObject();
		jsonObject9.put("title", OTHER_TITLE);
		jsonObject9.put("describe", ledgerOtherList);
		jsonObjects.add(jsonObject9);


		return jsonObjects;
	}

	private static LedgerTemplateEntity getTemplateContent(List<LedgerTemplateEntity> ledgerTemplates, String type) {
		for (LedgerTemplateEntity entity : ledgerTemplates) {
			if (type.equals(entity.getTemplateType())) {
				return entity;
			}
		}
		return null;
	}
}
