package com.ejianc.business.procost.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.procost.hystrix.CostDetailHystrix;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 费用项明细中间表交互
 * 
 * @author sunyj
 *
 */
@FeignClient(name= "ejc-procost-web", url="${common.env.feign-client-url}", path="ejc-procost-web", fallback = CostDetailHystrix.class)
public interface ICostDetailApi {

    /**
     *  插入费用项明细
     *
     * @param list
     *
     * @return
     */
    @PostMapping(value = "/api/procost/saveCostDetail")
    public CommonResponse<String> saveSubject(@RequestBody List<CostDetailVO> list);

    @GetMapping(value = "/api/procost/deleteCostDetail")
    public CommonResponse<String> deleteSubject(@RequestParam(value = "id", required = true) Long id);

    /**
     * 根据项目 查询实际成本总额
     *
     * @return
     */
    @RequestMapping(
            value = {"/api/procost/queryCostMnyByProjectId"},
            method = {RequestMethod.GET}
    )
    CommonResponse<JSONObject> queryCostMnyByProjectId(@RequestParam("projectId") Long projectId);


}
