package com.ejianc.business.procost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.procost.vo.ReportDetailVO;

/**
 * 成本分析报告
 * 
 * @author generator
 * 
 */
@ApiModel("成本分析报告")
public class ReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    private java.lang.Integer billState; // 单据状态（审批必须字段）
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("项目Id")
    private Long projectId;
    @ApiModelProperty("")
    private String projectName;
    @ApiModelProperty("项目部编码")
    private String projectCode;
    @ApiModelProperty("项目部Id")
    private Long orgId;
    @ApiModelProperty("")
    private String orgName;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("结构形式")
    private Long structureType;
    @ApiModelProperty("成本类别Id")
    private Long contractCategoryId;
    @ApiModelProperty("成本类别名称")
    private String contractCategoryName;
    @ApiModelProperty("合同模板Id")
    private Long contractTemplateId;
    @ApiModelProperty("合同模板名称")
    private String contractTemplateName;
    private String contractFilePath; // 合同附件路径
    private Long contractFileId; // 合同附件Id
    @ApiModelProperty("工程成本分析节点设置")
    private String def1;
    @ApiModelProperty("合同Id")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("工程造价调整后总金额(不含暂列金额)")
    private BigDecimal nicContractMny;
    @ApiModelProperty("合同计价形式")
    private Long contractValuationType;
    @ApiModelProperty("签约合同价（含税）")
    private BigDecimal contractBaseTaxMny;
    @ApiModelProperty("其中不含税金额")
    private BigDecimal contractBaseMny;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("其中增值税")
    private BigDecimal taxMny;
    @ApiModelProperty("暂列金额（无税）")
    private BigDecimal provisionalMny;
    @ApiModelProperty("工程类别Id")
    private Long engineeringTypeId;
    @ApiModelProperty("工程类别名称")
    private String engineeringTypeName;
    @ApiModelProperty("建筑面积(㎡)")
    private BigDecimal builtArea;
    @ApiModelProperty("承包模式")
    private Long contractualModel;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("合同开工日期")
    private Date startDate;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("合同竣工日期")
    private Date endDate;
    private Long fundsSourceId; // 资金来源(自定义档案)
    @ApiModelProperty("资金来源：0-自筹，1-财政资金，2-财政资金+自筹")
    private String fundsSource;
    @ApiModelProperty("项目地址")
    private String address;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("本次截止日期")
    private Date reportDate;
    @ApiModelProperty("工程进度已完成情况")
    private String completion;
    @ApiModelProperty("收入产值统计（无税）")
    private BigDecimal srcztjMny;
    @ApiModelProperty("目标成本统计（无税）")
    private BigDecimal mbcbtjMny;
    @ApiModelProperty("实际成本（无税）")
    private BigDecimal sjcbtjMny;
    @ApiModelProperty("预算收入-实际成本节超比例")
    private BigDecimal srsjRate;
    @ApiModelProperty("计划成本-实际成本节超比例")
    private BigDecimal mbsjRate;
    @ApiModelProperty("材料费收入产值")
    private BigDecimal materialIncomeMny;
    @ApiModelProperty("目标成本")
    private BigDecimal materialTargetcostMny;
    @ApiModelProperty("实际成本")
    private BigDecimal materialCostMny;
    @ApiModelProperty("收入实际对比盈亏（±）")
    private BigDecimal materialSrsjMny;
    @ApiModelProperty("目标实际对比盈亏（±）")
    private BigDecimal materialMbsjMny;
    @ApiModelProperty("预算收入用量")
    private BigDecimal gjIncomeNum;
    @ApiModelProperty("目标成本用量")
    private BigDecimal gjTargetcostNum;
    @ApiModelProperty("实际成本用量")
    private BigDecimal gjCostNum;
    @ApiModelProperty("收入实际用量对比盈亏（±）")
    private BigDecimal gjSrsjNum;
    @ApiModelProperty("目标实际用量对比盈亏（±）")
    private BigDecimal gjMbsjNum;
    @ApiModelProperty("预算收入金额")
    private BigDecimal gjIncomeMny;
    @ApiModelProperty("目标成本金额")
    private BigDecimal gjTargetcostMny;
    @ApiModelProperty("实际成本金额")
    private BigDecimal gjCostMny;
    @ApiModelProperty("收入实际金额对比盈亏（±）")
    private BigDecimal gjSrsjMny;
    @ApiModelProperty("目标实际金额对比盈亏（±）")
    private BigDecimal gjMbsjMny;
    @ApiModelProperty("预算收入用量")
    private BigDecimal sptIncomeNum;
    @ApiModelProperty("目标成本用量")
    private BigDecimal sptTargetcostNum;
    @ApiModelProperty("实际成本用量")
    private BigDecimal sptCostNum;
    @ApiModelProperty("收入实际用量对比盈亏（±）")
    private BigDecimal sptSrsjNum;
    @ApiModelProperty("目标实际用量对比盈亏（±）")
    private BigDecimal sptMbsjNum;
    @ApiModelProperty("预算收入金额")
    private BigDecimal sptIncomeMny;
    @ApiModelProperty("目标成本金额")
    private BigDecimal sptTargetcostMny;
    @ApiModelProperty("实际成本金额")
    private BigDecimal sptCostMny;
    @ApiModelProperty("收入实际金额对比盈亏（±）")
    private BigDecimal sptSrsjMny;
    @ApiModelProperty("目标实际金额对比盈亏（±）")
    private BigDecimal sptMbsjMny;
    @ApiModelProperty("分包预算收入金额")
    private BigDecimal subIncomeMny;
    @ApiModelProperty("目标成本金额")
    private BigDecimal subTargetcostMny;
    @ApiModelProperty("实际成本金额")
    private BigDecimal subCostMny;
    @ApiModelProperty("收入实际金额对比盈亏（±）")
    private BigDecimal subSrsjMny;
    @ApiModelProperty("目标实际金额对比盈亏（±）")
    private BigDecimal subMbsjMny;
    @ApiModelProperty("预算收入金额")
    private BigDecimal jjfIncomeMny;
    @ApiModelProperty("目标成本金额")
    private BigDecimal jjfTargetcostMny;
    @ApiModelProperty("实际成本金额")
    private BigDecimal jjfCostMny;
    @ApiModelProperty("收入实际金额对比盈亏（±）")
    private BigDecimal jjfSrsjMny;
    @ApiModelProperty("目标实际金额对比盈亏（±）")
    private BigDecimal jjfMbsjMny;
    @ApiModelProperty("业主确认税金")
    private BigDecimal sjIncomeMny;
    @ApiModelProperty("目标税金")
    private BigDecimal sjTargetcostMny;
    @ApiModelProperty("实际税金")
    private BigDecimal sjCostMny;
    @ApiModelProperty("累计税负")
    private BigDecimal sjMny;
    @ApiModelProperty("备注")
    private String memo;

    private BigDecimal ysHappenMnySum; // 累计产值报量
    private BigDecimal cbHappenMnySum; // 累计目标成本
    private BigDecimal happenMnySum; // 累计实际成本
    private BigDecimal srsjdifMnySum; // 实际比收入
    private BigDecimal mbsjdifMnySum; // 实际比目标
    private BigDecimal srsjRateSum; // 实际比收入节超率（%）
    private BigDecimal mbsjRateSum; // 实际比目标节超率（%）
    private String analysisType; // 本次分析类型
    private Long dutyAssessId; // 成本分析节点id
    private String dutyAssessName; // 成本分析节点名称
    private String analysisNum; // 累计成本分析次数


    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("成本分析开始日期")
    private Date reportStartDate;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("成本分析完成日期")
    private Date reportEndDate;

    private String startPeriod; // 实际成本开始期间
    private String endPeriod; // 实际成本完成期间

    @ApiModelProperty("成本分析报告明细")
    private List<ReportDetailVO> reportDetailList = new ArrayList<>();

    private List<ReportMaterialDetailVO> reportMaterialDetailList = new ArrayList<>();

    public String getStartPeriod() {
        return startPeriod;
    }

    public void setStartPeriod(String startPeriod) {
        this.startPeriod = startPeriod;
    }

    public String getEndPeriod() {
        return endPeriod;
    }

    public void setEndPeriod(String endPeriod) {
        this.endPeriod = endPeriod;
    }

    public Date getReportStartDate() {
        return reportStartDate;
    }

    public void setReportStartDate(Date reportStartDate) {
        this.reportStartDate = reportStartDate;
    }

    public Date getReportEndDate() {
        return reportEndDate;
    }

    public void setReportEndDate(Date reportEndDate) {
        this.reportEndDate = reportEndDate;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public BigDecimal getSrsjRate() {
        return srsjRate;
    }

    public void setSrsjRate(BigDecimal srsjRate) {
        this.srsjRate = srsjRate;
    }

    public BigDecimal getMbsjRate() {
        return mbsjRate;
    }

    public void setMbsjRate(BigDecimal mbsjRate) {
        this.mbsjRate = mbsjRate;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 项目Id
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目部编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目部编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目部Id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部Id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 结构形式
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getStructureType() {
        return structureType;
    }

    /**
     * 结构形式
     */
    @ReferDeserialTransfer
    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }
    /**
     * 成本类别Id
     */
    @ReferSerialTransfer(referCode="contractCategory")
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    /**
     * 成本类别Id
     */
    @ReferDeserialTransfer
    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    /**
     * 成本类别名称
     */
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    /**
     * 成本类别名称
     */
    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    /**
     * 合同模板Id
     */
    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    /**
     * 合同模板Id
     */
    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }
    /**
     * 合同模板名称
     */
    public String getContractTemplateName() {
        return contractTemplateName;
    }

    /**
     * 合同模板名称
     */
    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }
    /**
     * 工程成本分析节点设置
     */
    public String getDef1() {
        return def1;
    }

    /**
     * 工程成本分析节点设置
     */
    public void setDef1(String def1) {
        this.def1 = def1;
    }
    /**
     * 合同Id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同Id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 工程造价调整后总金额(不含暂列金额)
     */
    public BigDecimal getNicContractMny() {
        return nicContractMny;
    }

    /**
     * 工程造价调整后总金额(不含暂列金额)
     */
    public void setNicContractMny(BigDecimal nicContractMny) {
        this.nicContractMny = nicContractMny;
    }
    /**
     * 合同计价形式
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractValuationType() {
        return contractValuationType;
    }

    /**
     * 合同计价形式
     */
    @ReferDeserialTransfer
    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }
    /**
     * 签约合同价（含税）
     */
    public BigDecimal getContractBaseTaxMny() {
        return contractBaseTaxMny;
    }

    /**
     * 签约合同价（含税）
     */
    public void setContractBaseTaxMny(BigDecimal contractBaseTaxMny) {
        this.contractBaseTaxMny = contractBaseTaxMny;
    }
    /**
     * 其中不含税金额
     */
    public BigDecimal getContractBaseMny() {
        return contractBaseMny;
    }

    /**
     * 其中不含税金额
     */
    public void setContractBaseMny(BigDecimal contractBaseMny) {
        this.contractBaseMny = contractBaseMny;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 其中增值税
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 其中增值税
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 暂列金额（无税）
     */
    public BigDecimal getProvisionalMny() {
        return provisionalMny;
    }

    /**
     * 暂列金额（无税）
     */
    public void setProvisionalMny(BigDecimal provisionalMny) {
        this.provisionalMny = provisionalMny;
    }
    /**
     * 工程类别Id
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    /**
     * 工程类别Id
     */
    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    /**
     * 工程类别名称
     */
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    /**
     * 工程类别名称
     */
    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    /**
     * 建筑面积(㎡)
     */
    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    /**
     * 建筑面积(㎡)
     */
    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }
    /**
     * 承包模式
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractualModel() {
        return contractualModel;
    }

    /**
     * 承包模式
     */
    @ReferDeserialTransfer
    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }
    /**
     * 合同开工日期
     */
    public Date getStartDate() {
        return startDate;
    }

    /**
     * 合同开工日期
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 合同竣工日期
     */
    public Date getEndDate() {
        return endDate;
    }

    /**
     * 合同竣工日期
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFundsSourceId() {
        return fundsSourceId;
    }

    @ReferDeserialTransfer
    public void setFundsSourceId(Long fundsSourceId) {
        this.fundsSourceId = fundsSourceId;
    }

    /**
     * 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
     */
    public String getFundsSource() {
        return fundsSource;
    }

    /**
     * 资金来源：0-自筹，1-财政资金，2-财政资金+自筹
     */
    public void setFundsSource(String fundsSource) {
        this.fundsSource = fundsSource;
    }
    /**
     * 项目地址
     */
    public String getAddress() {
        return address;
    }

    /**
     * 项目地址
     */
    public void setAddress(String address) {
        this.address = address;
    }
    /**
     * 本次截止日期
     */
    public Date getReportDate() {
        return reportDate;
    }

    /**
     * 本次截止日期
     */
    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }
    /**
     * 工程进度已完成情况
     */
    public String getCompletion() {
        return completion;
    }

    /**
     * 工程进度已完成情况
     */
    public void setCompletion(String completion) {
        this.completion = completion;
    }
    /**
     * 收入产值统计（无税）
     */
    public BigDecimal getSrcztjMny() {
        return srcztjMny;
    }

    /**
     * 收入产值统计（无税）
     */
    public void setSrcztjMny(BigDecimal srcztjMny) {
        this.srcztjMny = srcztjMny;
    }
    /**
     * 目标成本统计（无税）
     */
    public BigDecimal getMbcbtjMny() {
        return mbcbtjMny;
    }

    /**
     * 目标成本统计（无税）
     */
    public void setMbcbtjMny(BigDecimal mbcbtjMny) {
        this.mbcbtjMny = mbcbtjMny;
    }
    /**
     * 实际成本（无税）
     */
    public BigDecimal getSjcbtjMny() {
        return sjcbtjMny;
    }

    /**
     * 实际成本（无税）
     */
    public void setSjcbtjMny(BigDecimal sjcbtjMny) {
        this.sjcbtjMny = sjcbtjMny;
    }
    /**
     * 材料费收入产值
     */
    public BigDecimal getMaterialIncomeMny() {
        return materialIncomeMny;
    }

    /**
     * 材料费收入产值
     */
    public void setMaterialIncomeMny(BigDecimal materialIncomeMny) {
        this.materialIncomeMny = materialIncomeMny;
    }
    /**
     * 目标成本
     */
    public BigDecimal getMaterialTargetcostMny() {
        return materialTargetcostMny;
    }

    /**
     * 目标成本
     */
    public void setMaterialTargetcostMny(BigDecimal materialTargetcostMny) {
        this.materialTargetcostMny = materialTargetcostMny;
    }
    /**
     * 实际成本
     */
    public BigDecimal getMaterialCostMny() {
        return materialCostMny;
    }

    /**
     * 实际成本
     */
    public void setMaterialCostMny(BigDecimal materialCostMny) {
        this.materialCostMny = materialCostMny;
    }
    /**
     * 收入实际对比盈亏（±）
     */
    public BigDecimal getMaterialSrsjMny() {
        return materialSrsjMny;
    }

    /**
     * 收入实际对比盈亏（±）
     */
    public void setMaterialSrsjMny(BigDecimal materialSrsjMny) {
        this.materialSrsjMny = materialSrsjMny;
    }
    /**
     * 目标实际对比盈亏（±）
     */
    public BigDecimal getMaterialMbsjMny() {
        return materialMbsjMny;
    }

    /**
     * 目标实际对比盈亏（±）
     */
    public void setMaterialMbsjMny(BigDecimal materialMbsjMny) {
        this.materialMbsjMny = materialMbsjMny;
    }
    /**
     * 预算收入用量
     */
    public BigDecimal getGjIncomeNum() {
        return gjIncomeNum;
    }

    /**
     * 预算收入用量
     */
    public void setGjIncomeNum(BigDecimal gjIncomeNum) {
        this.gjIncomeNum = gjIncomeNum;
    }
    /**
     * 目标成本用量
     */
    public BigDecimal getGjTargetcostNum() {
        return gjTargetcostNum;
    }

    /**
     * 目标成本用量
     */
    public void setGjTargetcostNum(BigDecimal gjTargetcostNum) {
        this.gjTargetcostNum = gjTargetcostNum;
    }
    /**
     * 实际成本用量
     */
    public BigDecimal getGjCostNum() {
        return gjCostNum;
    }

    /**
     * 实际成本用量
     */
    public void setGjCostNum(BigDecimal gjCostNum) {
        this.gjCostNum = gjCostNum;
    }
    /**
     * 收入实际用量对比盈亏（±）
     */
    public BigDecimal getGjSrsjNum() {
        return gjSrsjNum;
    }

    /**
     * 收入实际用量对比盈亏（±）
     */
    public void setGjSrsjNum(BigDecimal gjSrsjNum) {
        this.gjSrsjNum = gjSrsjNum;
    }
    /**
     * 目标实际用量对比盈亏（±）
     */
    public BigDecimal getGjMbsjNum() {
        return gjMbsjNum;
    }

    /**
     * 目标实际用量对比盈亏（±）
     */
    public void setGjMbsjNum(BigDecimal gjMbsjNum) {
        this.gjMbsjNum = gjMbsjNum;
    }
    /**
     * 预算收入金额
     */
    public BigDecimal getGjIncomeMny() {
        return gjIncomeMny;
    }

    /**
     * 预算收入金额
     */
    public void setGjIncomeMny(BigDecimal gjIncomeMny) {
        this.gjIncomeMny = gjIncomeMny;
    }
    /**
     * 目标成本金额
     */
    public BigDecimal getGjTargetcostMny() {
        return gjTargetcostMny;
    }

    /**
     * 目标成本金额
     */
    public void setGjTargetcostMny(BigDecimal gjTargetcostMny) {
        this.gjTargetcostMny = gjTargetcostMny;
    }
    /**
     * 实际成本金额
     */
    public BigDecimal getGjCostMny() {
        return gjCostMny;
    }

    /**
     * 实际成本金额
     */
    public void setGjCostMny(BigDecimal gjCostMny) {
        this.gjCostMny = gjCostMny;
    }
    /**
     * 收入实际金额对比盈亏（±）
     */
    public BigDecimal getGjSrsjMny() {
        return gjSrsjMny;
    }

    /**
     * 收入实际金额对比盈亏（±）
     */
    public void setGjSrsjMny(BigDecimal gjSrsjMny) {
        this.gjSrsjMny = gjSrsjMny;
    }
    /**
     * 目标实际金额对比盈亏（±）
     */
    public BigDecimal getGjMbsjMny() {
        return gjMbsjMny;
    }

    /**
     * 目标实际金额对比盈亏（±）
     */
    public void setGjMbsjMny(BigDecimal gjMbsjMny) {
        this.gjMbsjMny = gjMbsjMny;
    }
    /**
     * 预算收入用量
     */
    public BigDecimal getSptIncomeNum() {
        return sptIncomeNum;
    }

    /**
     * 预算收入用量
     */
    public void setSptIncomeNum(BigDecimal sptIncomeNum) {
        this.sptIncomeNum = sptIncomeNum;
    }
    /**
     * 目标成本用量
     */
    public BigDecimal getSptTargetcostNum() {
        return sptTargetcostNum;
    }

    /**
     * 目标成本用量
     */
    public void setSptTargetcostNum(BigDecimal sptTargetcostNum) {
        this.sptTargetcostNum = sptTargetcostNum;
    }
    /**
     * 实际成本用量
     */
    public BigDecimal getSptCostNum() {
        return sptCostNum;
    }

    /**
     * 实际成本用量
     */
    public void setSptCostNum(BigDecimal sptCostNum) {
        this.sptCostNum = sptCostNum;
    }
    /**
     * 收入实际用量对比盈亏（±）
     */
    public BigDecimal getSptSrsjNum() {
        return sptSrsjNum;
    }

    /**
     * 收入实际用量对比盈亏（±）
     */
    public void setSptSrsjNum(BigDecimal sptSrsjNum) {
        this.sptSrsjNum = sptSrsjNum;
    }
    /**
     * 目标实际用量对比盈亏（±）
     */
    public BigDecimal getSptMbsjNum() {
        return sptMbsjNum;
    }

    /**
     * 目标实际用量对比盈亏（±）
     */
    public void setSptMbsjNum(BigDecimal sptMbsjNum) {
        this.sptMbsjNum = sptMbsjNum;
    }
    /**
     * 预算收入金额
     */
    public BigDecimal getSptIncomeMny() {
        return sptIncomeMny;
    }

    /**
     * 预算收入金额
     */
    public void setSptIncomeMny(BigDecimal sptIncomeMny) {
        this.sptIncomeMny = sptIncomeMny;
    }
    /**
     * 目标成本金额
     */
    public BigDecimal getSptTargetcostMny() {
        return sptTargetcostMny;
    }

    /**
     * 目标成本金额
     */
    public void setSptTargetcostMny(BigDecimal sptTargetcostMny) {
        this.sptTargetcostMny = sptTargetcostMny;
    }
    /**
     * 实际成本金额
     */
    public BigDecimal getSptCostMny() {
        return sptCostMny;
    }

    /**
     * 实际成本金额
     */
    public void setSptCostMny(BigDecimal sptCostMny) {
        this.sptCostMny = sptCostMny;
    }
    /**
     * 收入实际金额对比盈亏（±）
     */
    public BigDecimal getSptSrsjMny() {
        return sptSrsjMny;
    }

    /**
     * 收入实际金额对比盈亏（±）
     */
    public void setSptSrsjMny(BigDecimal sptSrsjMny) {
        this.sptSrsjMny = sptSrsjMny;
    }
    /**
     * 目标实际金额对比盈亏（±）
     */
    public BigDecimal getSptMbsjMny() {
        return sptMbsjMny;
    }

    /**
     * 目标实际金额对比盈亏（±）
     */
    public void setSptMbsjMny(BigDecimal sptMbsjMny) {
        this.sptMbsjMny = sptMbsjMny;
    }
    /**
     * 分包预算收入金额
     */
    public BigDecimal getSubIncomeMny() {
        return subIncomeMny;
    }

    /**
     * 分包预算收入金额
     */
    public void setSubIncomeMny(BigDecimal subIncomeMny) {
        this.subIncomeMny = subIncomeMny;
    }
    /**
     * 目标成本金额
     */
    public BigDecimal getSubTargetcostMny() {
        return subTargetcostMny;
    }

    /**
     * 目标成本金额
     */
    public void setSubTargetcostMny(BigDecimal subTargetcostMny) {
        this.subTargetcostMny = subTargetcostMny;
    }
    /**
     * 实际成本金额
     */
    public BigDecimal getSubCostMny() {
        return subCostMny;
    }

    /**
     * 实际成本金额
     */
    public void setSubCostMny(BigDecimal subCostMny) {
        this.subCostMny = subCostMny;
    }
    /**
     * 收入实际金额对比盈亏（±）
     */
    public BigDecimal getSubSrsjMny() {
        return subSrsjMny;
    }

    /**
     * 收入实际金额对比盈亏（±）
     */
    public void setSubSrsjMny(BigDecimal subSrsjMny) {
        this.subSrsjMny = subSrsjMny;
    }
    /**
     * 目标实际金额对比盈亏（±）
     */
    public BigDecimal getSubMbsjMny() {
        return subMbsjMny;
    }

    /**
     * 目标实际金额对比盈亏（±）
     */
    public void setSubMbsjMny(BigDecimal subMbsjMny) {
        this.subMbsjMny = subMbsjMny;
    }
    /**
     * 预算收入金额
     */
    public BigDecimal getJjfIncomeMny() {
        return jjfIncomeMny;
    }

    /**
     * 预算收入金额
     */
    public void setJjfIncomeMny(BigDecimal jjfIncomeMny) {
        this.jjfIncomeMny = jjfIncomeMny;
    }
    /**
     * 目标成本金额
     */
    public BigDecimal getJjfTargetcostMny() {
        return jjfTargetcostMny;
    }

    /**
     * 目标成本金额
     */
    public void setJjfTargetcostMny(BigDecimal jjfTargetcostMny) {
        this.jjfTargetcostMny = jjfTargetcostMny;
    }
    /**
     * 实际成本金额
     */
    public BigDecimal getJjfCostMny() {
        return jjfCostMny;
    }

    /**
     * 实际成本金额
     */
    public void setJjfCostMny(BigDecimal jjfCostMny) {
        this.jjfCostMny = jjfCostMny;
    }
    /**
     * 收入实际金额对比盈亏（±）
     */
    public BigDecimal getJjfSrsjMny() {
        return jjfSrsjMny;
    }

    /**
     * 收入实际金额对比盈亏（±）
     */
    public void setJjfSrsjMny(BigDecimal jjfSrsjMny) {
        this.jjfSrsjMny = jjfSrsjMny;
    }
    /**
     * 目标实际金额对比盈亏（±）
     */
    public BigDecimal getJjfMbsjMny() {
        return jjfMbsjMny;
    }

    /**
     * 目标实际金额对比盈亏（±）
     */
    public void setJjfMbsjMny(BigDecimal jjfMbsjMny) {
        this.jjfMbsjMny = jjfMbsjMny;
    }
    /**
     * 业主确认税金
     */
    public BigDecimal getSjIncomeMny() {
        return sjIncomeMny;
    }

    /**
     * 业主确认税金
     */
    public void setSjIncomeMny(BigDecimal sjIncomeMny) {
        this.sjIncomeMny = sjIncomeMny;
    }
    /**
     * 目标税金
     */
    public BigDecimal getSjTargetcostMny() {
        return sjTargetcostMny;
    }

    /**
     * 目标税金
     */
    public void setSjTargetcostMny(BigDecimal sjTargetcostMny) {
        this.sjTargetcostMny = sjTargetcostMny;
    }
    /**
     * 实际税金
     */
    public BigDecimal getSjCostMny() {
        return sjCostMny;
    }

    /**
     * 实际税金
     */
    public void setSjCostMny(BigDecimal sjCostMny) {
        this.sjCostMny = sjCostMny;
    }
    /**
     * 累计税负
     */
    public BigDecimal getSjMny() {
        return sjMny;
    }

    /**
     * 累计税负
     */
    public void setSjMny(BigDecimal sjMny) {
        this.sjMny = sjMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }


    public BigDecimal getYsHappenMnySum() {
        return ysHappenMnySum;
    }

    public void setYsHappenMnySum(BigDecimal ysHappenMnySum) {
        this.ysHappenMnySum = ysHappenMnySum;
    }

    public BigDecimal getCbHappenMnySum() {
        return cbHappenMnySum;
    }

    public void setCbHappenMnySum(BigDecimal cbHappenMnySum) {
        this.cbHappenMnySum = cbHappenMnySum;
    }

    public BigDecimal getHappenMnySum() {
        return happenMnySum;
    }

    public void setHappenMnySum(BigDecimal happenMnySum) {
        this.happenMnySum = happenMnySum;
    }

    public BigDecimal getSrsjdifMnySum() {
        return srsjdifMnySum;
    }

    public void setSrsjdifMnySum(BigDecimal srsjdifMnySum) {
        this.srsjdifMnySum = srsjdifMnySum;
    }

    public BigDecimal getMbsjdifMnySum() {
        return mbsjdifMnySum;
    }

    public void setMbsjdifMnySum(BigDecimal mbsjdifMnySum) {
        this.mbsjdifMnySum = mbsjdifMnySum;
    }

    public BigDecimal getSrsjRateSum() {
        return srsjRateSum;
    }

    public void setSrsjRateSum(BigDecimal srsjRateSum) {
        this.srsjRateSum = srsjRateSum;
    }

    public BigDecimal getMbsjRateSum() {
        return mbsjRateSum;
    }

    public void setMbsjRateSum(BigDecimal mbsjRateSum) {
        this.mbsjRateSum = mbsjRateSum;
    }

    public String getAnalysisType() {
        return analysisType;
    }

    public void setAnalysisType(String analysisType) {
        this.analysisType = analysisType;
    }

    public Long getDutyAssessId() {
        return dutyAssessId;
    }
    @ReferDeserialTransfer
    public void setDutyAssessId(Long dutyAssessId) {
        this.dutyAssessId = dutyAssessId;
    }

    public String getDutyAssessName() {
        return dutyAssessName;
    }

    public void setDutyAssessName(String dutyAssessName) {
        this.dutyAssessName = dutyAssessName;
    }

    public String getAnalysisNum() {
        return analysisNum;
    }

    public void setAnalysisNum(String analysisNum) {
        this.analysisNum = analysisNum;
    }

    /**
      * 成本分析报告明细
      */
      public List<ReportDetailVO> getReportDetailList() {
         return reportDetailList;
      }
     /**
      * 成本分析报告明细
      */
     public void setReportDetailList(List<ReportDetailVO> reportDetailList) {
         this.reportDetailList = reportDetailList;
     }

    public List<ReportMaterialDetailVO> getReportMaterialDetailList() {
        return reportMaterialDetailList;
    }

    public void setReportMaterialDetailList(List<ReportMaterialDetailVO> reportMaterialDetailList) {
        this.reportMaterialDetailList = reportMaterialDetailList;
    }
}
