package com.ejianc.business.procost.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.procost.hystrix.CostDetailHystrix;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 费用项明细中间表交互
 * 
 * @author sunyj
 *
 */
@FeignClient(name= "ejc-procost-web", url="${common.env.feign-client-url}", path="ejc-procost-web", fallback = CostDetailHystrix.class)
public interface ICostDetailApi {

    /**
     *  插入费用项明细
     *
     * @param list
     *
     * @return
     */
    @PostMapping(value = "/api/procost/saveCostDetail")
    public CommonResponse<String> saveSubject(@RequestBody List<CostDetailVO> list);

    @GetMapping(value = "/api/procost/deleteCostDetail")
    public CommonResponse<String> deleteSubject(@RequestParam(value = "id", required = true) Long id);

    /**
     * 更新成本池生效状态
     * sourceId 业务单据id
     * effectiveStatus   生效状态  0-未生效，1-生效
     *
     */
    @GetMapping(value = "/api/procost/updateCostDetail")
    public CommonResponse<String> updateCostDetail(@RequestParam(value = "sourceId", required = true) Long sourceId,@RequestParam(value = "effectiveStatus", required = true) Integer effectiveStatus);
    /**
     * 根据项目 查询实际成本总额
     *
     * @return
     */
    @RequestMapping(
            value = {"/api/procost/queryCostMnyByProjectId"},
            method = {RequestMethod.GET}
    )
    CommonResponse<JSONObject> queryCostMnyByProjectId(@RequestParam("projectId") Long projectId);

    /**
     * 根据科目，项目   查询实际成本总额
     *
     * @return
     */
    @RequestMapping(
            value = {"/api/procost/queryMnyBySubjectId"},
            method = {RequestMethod.GET}
    )
    CommonResponse<List<CostDetailVO>> queryMnyBySubjectId(@RequestParam(value = "sourceId", required = false) Long sourceId,@RequestParam(value = "projectId", required = true) Long projectId,@RequestParam(value = "subjectIds", required = false) List<Long> subjectIds);

    /**
     * 根据项目   查询实际成本总额
     *
     * @return
     */
    @RequestMapping(
            value = {"/api/procost/queryDetailByProjectId"},
            method = {RequestMethod.GET}
    )
    CommonResponse<List<CostDetailVO>> queryDetailByProjectId(@RequestParam(value = "sourceId", required = false) Long sourceId,@RequestParam(value = "projectId", required = true) Long projectId,@RequestParam(value = "subjectIds", required = false) List<Long> subjectIds);


}
