package com.ejianc.business.procost.api;

import com.ejianc.business.procost.hystrix.CostSettingHystrix;
import com.ejianc.business.procost.vo.SettingVO;
import com.ejianc.business.procost.vo.SubjectMaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 成本设置
 * 
 * @author sunyj
 *
 */
@FeignClient(name= "ejc-procost-web", url="${common.env.feign-client-url}", path="ejc-procost-web", fallback = CostSettingHystrix.class)
public interface ICostSettingApi {

    /**
     * 查询成本其间设置
     *
     * @return
     */
    @GetMapping(value = "/api/setting/getSettingInfo")
    CommonResponse<SettingVO> getSettingInfo(@RequestParam Long orgId);

    /**
     *  查看项目是否成本设置
     *
     * @param projectId
     *
     * @return
     */
    @GetMapping(value = "/api/setting/checkSettingFlag")
    public CommonResponse<Boolean> checkSettingFlag(@RequestParam(value = "projectId", required = true) Long projectId);

    /**
     *  根据项目查询科目信息
     *
     * @param projectId
     *
     * @return
     */
    @GetMapping(value = "/api/setting/querySubjectsByProj")
    public CommonResponse<List<SubjectMaterialVO>> querySubjectsByProj(@RequestParam(value = "projectId", required = true) Long projectId);
}
