package com.ejianc.business.procost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.procost.vo.HandshareDetailVO;

/**
 * 成本单据
 * 
 * @author generator
 * 
 */
@ApiModel("成本单据")
public class HandshareVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("是否含税 0-是，1-否")
    private String taxFlag;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("期间")
    private String period;
    @ApiModelProperty("本期分摊成本")
    private BigDecimal costMny;
    @ApiModelProperty("本期分摊成本(含税)")
    private BigDecimal costTaxMny;
    @ApiModelProperty("来源主键")
    private Long sourceId;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("创建人名称")
    private String createUserName;
    @ApiModelProperty("当前期间内的最后一天")
    private String endDay;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("是否财务取数 0-否，1-是")
    private String cwFlag;
    
    @ApiModelProperty("成本单据明细")
    private List<HandshareDetailVO> handshareDetailList = new ArrayList<>();


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 是否含税 0-是，1-否
     */
    public String getTaxFlag() {
        return taxFlag;
    }

    /**
     * 是否含税 0-是，1-否
     */
    public void setTaxFlag(String taxFlag) {
        this.taxFlag = taxFlag;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 期间
     */
    public String getPeriod() {
        return period;
    }

    /**
     * 期间
     */
    public void setPeriod(String period) {
        this.period = period;
    }
    /**
     * 本期分摊成本
     */
    public BigDecimal getCostMny() {
        return costMny;
    }

    /**
     * 本期分摊成本
     */
    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    /**
     * 本期分摊成本(含税)
     */
    public BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    /**
     * 本期分摊成本(含税)
     */
    public void setCostTaxMny(BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }
    /**
     * 来源主键
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源主键
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 创建人名称
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    /**
     * 当前期间内的最后一天
     */
    public String getEndDay() {
        return endDay;
    }

    /**
     * 当前期间内的最后一天
     */
    public void setEndDay(String endDay) {
        this.endDay = endDay;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 是否财务取数 0-否，1-是
     */
    public String getCwFlag() {
        return cwFlag;
    }

    /**
     * 是否财务取数 0-否，1-是
     */
    public void setCwFlag(String cwFlag) {
        this.cwFlag = cwFlag;
    }
    
     /**
      * 成本单据明细
      */
      public List<HandshareDetailVO> getHandshareDetailList() {
         return handshareDetailList;
      }
     /**
      * 成本单据明细
      */
     public void setHandshareDetailList(List<HandshareDetailVO> handshareDetailList) {
         this.handshareDetailList = handshareDetailList;
     }
}
