package com.ejianc.business.procurement.plan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 采购计划实体
 * 
 * @author generator
 * 
 */
public class PurchasePlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    private String billCode; // 单据编号
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private String orgName; // 项目部名称
    private String orgCode; // 项目部编码
    private String parentOrgName; // 项目部上级名称
    private String parentOrgCode; // 项目部上级编码
    private String allOrgName; // 所属组织(所属单位-项目经理部)
    private String employeeName; // 经办人名称
    private String businessType; // 业务类别1-工程，2-货物，3-服务
    private String memo; // 备注
    private String planObject; // 采购主要标的物
    private String specialCode; // 特殊事项单号
    private Long specialId; // 特殊事项主键
    private Integer billState; // 单据状态
    private Integer planType; // 计划类型 1-年度，2-季度，3-月度，4-临时，5-紧急
    private Integer permissionType; // 实施权限 1-一级集采，2-二级集采，3-所属单位，4-项目经理部
    private Integer specialType; // 是否特殊事项采购 1-是，2-否
    private Integer specialMatter; // 特殊事项 1-拟邀请招标，2-拟不招标
    private Integer specialStatus; // 特殊事项状态 1-未完成，2-已完成
    private Integer abnormalStatus; // 计划异常状态 1-正常，2-取消采购，3-暂停采购
    private Long projectId; // 项目Id
    private Long orgId; // 项目部Id
    private Long parentOrgId; // 项目部上级Id
    private Long employeeId; // 经办人
    private BigDecimal ctrlTaxMny; // 控制含税总额
    private BigDecimal preTaxMny; // 预估含税总额
    private BigDecimal bidTaxMny; // 投标含税总额
    private Integer authStatus; // 是否已授权 1-是，2-否
    private Integer allocateStatus; // 是否已分配 1-是，2-否
    private String name;
    private List<PurchasePlanDetailVO> purchasePlanDetailList = new ArrayList<>(); // 采购计划明细

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getAuthStatus() {
        return authStatus;
    }

    public void setAuthStatus(Integer authStatus) {
        this.authStatus = authStatus;
    }

    public Integer getAllocateStatus() {
        return allocateStatus;
    }

    public void setAllocateStatus(Integer allocateStatus) {
        this.allocateStatus = allocateStatus;
    }

    public Long getSpecialId() {
        return specialId;
    }

    public void setSpecialId(Long specialId) {
        this.specialId = specialId;
    }

    public BigDecimal getCtrlTaxMny() {
        return ctrlTaxMny;
    }

    public void setCtrlTaxMny(BigDecimal ctrlTaxMny) {
        this.ctrlTaxMny = ctrlTaxMny;
    }

    public BigDecimal getPreTaxMny() {
        return preTaxMny;
    }

    public void setPreTaxMny(BigDecimal preTaxMny) {
        this.preTaxMny = preTaxMny;
    }

    public BigDecimal getBidTaxMny() {
        return bidTaxMny;
    }

    public void setBidTaxMny(BigDecimal bidTaxMny) {
        this.bidTaxMny = bidTaxMny;
    }

    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getAllOrgName() {
        return allOrgName;
    }

    public void setAllOrgName(String allOrgName) {
        this.allOrgName = allOrgName;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getPlanObject() {
        return planObject;
    }

    public void setPlanObject(String planObject) {
        this.planObject = planObject;
    }
    public String getSpecialCode() {
        return specialCode;
    }

    public void setSpecialCode(String specialCode) {
        this.specialCode = specialCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getPlanType() {
        return planType;
    }

    public void setPlanType(Integer planType) {
        this.planType = planType;
    }
    public Integer getPermissionType() {
        return permissionType;
    }

    public void setPermissionType(Integer permissionType) {
        this.permissionType = permissionType;
    }
    public Integer getSpecialType() {
        return specialType;
    }

    public void setSpecialType(Integer specialType) {
        this.specialType = specialType;
    }
    public Integer getSpecialMatter() {
        return specialMatter;
    }

    public void setSpecialMatter(Integer specialMatter) {
        this.specialMatter = specialMatter;
    }
    public Integer getSpecialStatus() {
        return specialStatus;
    }

    public void setSpecialStatus(Integer specialStatus) {
        this.specialStatus = specialStatus;
    }
    public Integer getAbnormalStatus() {
        return abnormalStatus;
    }

    public void setAbnormalStatus(Integer abnormalStatus) {
        this.abnormalStatus = abnormalStatus;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    
     public List<PurchasePlanDetailVO> getPurchasePlanDetailList() {
        return purchasePlanDetailList;
     }

     public void setPurchasePlanDetailList(List<PurchasePlanDetailVO> purchasePlanDetailList) {
        this.purchasePlanDetailList = purchasePlanDetailList;
     }
}
