package com.ejianc.business.procurement.plan.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 需求计划-明细
 *
 * @author generator
 *
 */
public class DemandPlanDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private BigDecimal num; // 采购计划数量
    private BigDecimal ctrlDetailTaxMny; // 控制含税金额
    private BigDecimal ctrlDetailTaxPrice; // 控制含税单价
    private BigDecimal preDetailTaxMny; // 预估含税金额
    private BigDecimal preDetailTaxPrice; // 预估含税单价
    private BigDecimal bidDetailTaxMny; // 投标含税金额
    private BigDecimal bidDetailTaxPrice; // 投标含税单价
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date deliveryDate; // 要求到货日期
    private String materialCode; // 档案编码
    private String materialName; // 档案名称
    private String materialTypeName; // 分类名称
    private String materialTypeCode; // 分类编码
    private String spec; // 规则/型号
    private String unitName; // 计量单位
    private String brand; // 品牌
    private String place; // 产地
    private String materialAttribute; // 材质属性
    private String standardNumber; // 标准号
    private String manufacturer; // 制造商
    private String memo; // 备注
    private String purchasePlace; // 采购地点
    private String deliveryPlace; // 交货地点
    private String supplierNames; // 推荐的潜在供应商名称及联系方式
    private String subjectName; // 成本科目名称
    private String sourceBillId; // 来源数据主表Id
    private String sourceType; // 来源类型：1-物资档案,2-工程档案,3-服务档案,4-需求计划,5-采购策划
    private String sourceBillCode; // 来源数据编码
    private String sourceId; // 来源Id
    private String purchaseCategoryName; // 一级集采类别名称
    private String useforName; // 用途名称
    private String wbsName; // 工程部位名称
    private String usageCategoryName; // 材料/设备使用类别名称
    private String planObject; // 采购标的
    private String demandUnit; // 需求单位
    private Integer planPermissionType; // 采购计划实施权限 1-一级集采，2-二级集采，3-所属单位，4-项目经理部
    private Integer authPermissionType; // 授权实施权限 1-一级集采，2-二级集采，3-所属单位，4-项目经理部
    private Integer authStatus; // 是否已授权 1-是，2-否
    private Integer allocateStatus; // 是否已分配 1-是，2-否
    private Long planId; // 计划Id
    private Long materialId; // 档案Id
    private Long materialTypeId; // 分类Id
    private Long unitId; // 计量单位主键
    private Long subjectId; // 成本科目id
    private Long purchaseCategoryId; // 一级集采类别id
    private Long useforId; // 用途id
    private Long wbsId; // 工程部位id
    private Long usageCategoryId; // 材料/设备使用类别id


    private String billCode; // 单据编号
    private String projectName; // 项目
    private String allOrgName; // 所属组织

    public BigDecimal getPreDetailTaxMny() {
        return preDetailTaxMny;
    }

    public void setPreDetailTaxMny(BigDecimal preDetailTaxMny) {
        this.preDetailTaxMny = preDetailTaxMny;
    }

    public BigDecimal getPreDetailTaxPrice() {
        return preDetailTaxPrice;
    }

    public void setPreDetailTaxPrice(BigDecimal preDetailTaxPrice) {
        this.preDetailTaxPrice = preDetailTaxPrice;
    }

    public BigDecimal getBidDetailTaxMny() {
        return bidDetailTaxMny;
    }

    public void setBidDetailTaxMny(BigDecimal bidDetailTaxMny) {
        this.bidDetailTaxMny = bidDetailTaxMny;
    }

    public String getDemandUnit() {
        return demandUnit;
    }

    public void setDemandUnit(String demandUnit) {
        this.demandUnit = demandUnit;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getAllOrgName() {
        return allOrgName;
    }

    public void setAllOrgName(String allOrgName) {
        this.allOrgName = allOrgName;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getCtrlDetailTaxMny() {
        return ctrlDetailTaxMny;
    }

    public void setCtrlDetailTaxMny(BigDecimal ctrlDetailTaxMny) {
        this.ctrlDetailTaxMny = ctrlDetailTaxMny;
    }

    public BigDecimal getCtrlDetailTaxPrice() {
        return ctrlDetailTaxPrice;
    }

    public void setCtrlDetailTaxPrice(BigDecimal ctrlDetailTaxPrice) {
        this.ctrlDetailTaxPrice = ctrlDetailTaxPrice;
    }

    public BigDecimal getBidDetailTaxPrice() {
        return bidDetailTaxPrice;
    }

    public void setBidDetailTaxPrice(BigDecimal bidDetailTaxPrice) {
        this.bidDetailTaxPrice = bidDetailTaxPrice;
    }

    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getPlace() {
        return place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public String getMaterialAttribute() {
        return materialAttribute;
    }

    public void setMaterialAttribute(String materialAttribute) {
        this.materialAttribute = materialAttribute;
    }

    public String getStandardNumber() {
        return standardNumber;
    }

    public void setStandardNumber(String standardNumber) {
        this.standardNumber = standardNumber;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getPurchasePlace() {
        return purchasePlace;
    }

    public void setPurchasePlace(String purchasePlace) {
        this.purchasePlace = purchasePlace;
    }

    public String getDeliveryPlace() {
        return deliveryPlace;
    }

    public void setDeliveryPlace(String deliveryPlace) {
        this.deliveryPlace = deliveryPlace;
    }

    public String getSupplierNames() {
        return supplierNames;
    }

    public void setSupplierNames(String supplierNames) {
        this.supplierNames = supplierNames;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSourceBillId() {
        return sourceBillId;
    }

    public void setSourceBillId(String sourceBillId) {
        this.sourceBillId = sourceBillId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getPurchaseCategoryName() {
        return purchaseCategoryName;
    }

    public void setPurchaseCategoryName(String purchaseCategoryName) {
        this.purchaseCategoryName = purchaseCategoryName;
    }

    public String getUseforName() {
        return useforName;
    }

    public void setUseforName(String useforName) {
        this.useforName = useforName;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    public String getUsageCategoryName() {
        return usageCategoryName;
    }

    public void setUsageCategoryName(String usageCategoryName) {
        this.usageCategoryName = usageCategoryName;
    }

    public String getPlanObject() {
        return planObject;
    }

    public void setPlanObject(String planObject) {
        this.planObject = planObject;
    }

    public Integer getPlanPermissionType() {
        return planPermissionType;
    }

    public void setPlanPermissionType(Integer planPermissionType) {
        this.planPermissionType = planPermissionType;
    }

    public Integer getAuthPermissionType() {
        return authPermissionType;
    }

    public void setAuthPermissionType(Integer authPermissionType) {
        this.authPermissionType = authPermissionType;
    }

    public Integer getAuthStatus() {
        return authStatus;
    }

    public void setAuthStatus(Integer authStatus) {
        this.authStatus = authStatus;
    }

    public Integer getAllocateStatus() {
        return allocateStatus;
    }

    public void setAllocateStatus(Integer allocateStatus) {
        this.allocateStatus = allocateStatus;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    @ReferSerialTransfer(referCode = "Material001")
    public Long getMaterialId() {
        return materialId;
    }

    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    @ReferSerialTransfer(referCode = "MaterialCategory001")
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    @ReferDeserialTransfer
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    @ReferSerialTransfer(referCode = "procurement-catalog-item")
    public Long getPurchaseCategoryId() {
        return purchaseCategoryId;
    }

    @ReferDeserialTransfer
    public void setPurchaseCategoryId(Long purchaseCategoryId) {
        this.purchaseCategoryId = purchaseCategoryId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getUseforId() {
        return useforId;
    }

    @ReferDeserialTransfer
    public void setUseforId(Long useforId) {
        this.useforId = useforId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getWbsId() {
        return wbsId;
    }

    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getUsageCategoryId() {
        return usageCategoryId;
    }

    @ReferDeserialTransfer
    public void setUsageCategoryId(Long usageCategoryId) {
        this.usageCategoryId = usageCategoryId;
    }

}
