package com.ejianc.business.procurement.perform.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description: 业务状态 1-正常，2-取消采购，3-暂停采购，4-重新采购
 * @author songlx
 * @date 2025/12/11
 * @version 1.0
 */
public enum BusinessStateEnum {

    ZHENG_CHANG(1, "正常"),
    QU_XIAO(2, "取消采购"),
    ZAN_TING(3, "暂停采购"),
    CHONG_XIN(4, "重新采购");

    private static Map<Integer, BusinessStateEnum> enumMap = new HashMap();

    static {
        enumMap = EnumSet.allOf(BusinessStateEnum.class).stream().collect(Collectors.toMap(BusinessStateEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }


    public static String getNameByCode(Integer code) {
        return enumMap.get(code) != null ? enumMap.get(code).getName() : "未定义";
    }

    private Integer code;

    private String name;

    BusinessStateEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
