package com.ejianc.business.procurement.plan.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 计划答疑清单
 * 
 * @author generator
 * 
 */
public class AnswerVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    private String billCode; // 单据编号
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private String orgName; // 项目部名称
    private String orgCode; // 项目部编码
    private String parentOrgName; // 项目部上级名称
    private String parentOrgCode; // 项目部上级编码
    private String allOrgName; // 所属组织(所属单位-项目经理部)
    private String employeeName; // 经办人名称
    private String businessType; // 业务类别1-工程，2-货物，3-服务
    private String memo; // 备注
    private String purchaseOrgName; // 采购单位name
    private String informerName; // 通知人名称
    private String answerType; // 答疑数据 -1 , 回复数据-2
    private Integer billState; // 单据状态
    private String billStateName; // 单据状态
    private Long projectId; // 项目Id
    private Long orgId; // 项目部Id
    private Long parentOrgId; // 项目部上级Id
    private Long employeeId; // 经办人
    private Long purchaseOrgId; // 采购单位id
    private Long informerId; // 通知人id
    private String purchasePlanName; // 采购计划name
    private Long purchasePlanId; // 采购计划id
    private String purchasePlanCode; // 采购计划code
    private Integer replyStatus; // 回复状态 1-待回复,2-已回复


    private List<AnswerDetailVO> answerDetailList = new ArrayList<>(); // 计划答疑清单-子表

    public Integer getReplyStatus() {
        return replyStatus;
    }

    public void setReplyStatus(Integer replyStatus) {
        this.replyStatus = replyStatus;
    }

    public String getPurchasePlanName() {
        return purchasePlanName;
    }

    public void setPurchasePlanName(String purchasePlanName) {
        this.purchasePlanName = purchasePlanName;
    }
    @ReferSerialTransfer(referCode="purchase_plan_code")
    public Long getPurchasePlanId() {
        return purchasePlanId;
    }
    @ReferDeserialTransfer
    public void setPurchasePlanId(Long purchasePlanId) {
        this.purchasePlanId = purchasePlanId;
    }

    public String getPurchasePlanCode() {
        return purchasePlanCode;
    }

    public void setPurchasePlanCode(String purchasePlanCode) {
        this.purchasePlanCode = purchasePlanCode;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getAllOrgName() {
        return allOrgName;
    }

    public void setAllOrgName(String allOrgName) {
        this.allOrgName = allOrgName;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getPurchaseOrgName() {
        return purchaseOrgName;
    }

    public void setPurchaseOrgName(String purchaseOrgName) {
        this.purchaseOrgName = purchaseOrgName;
    }
    public String getInformerName() {
        return informerName;
    }

    public void setInformerName(String informerName) {
        this.informerName = informerName;
    }
    public String getAnswerType() {
        return answerType;
    }

    public void setAnswerType(String answerType) {
        this.answerType = answerType;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getPurchaseOrgId() {
        return purchaseOrgId;
    }
    @ReferDeserialTransfer
    public void setPurchaseOrgId(Long purchaseOrgId) {
        this.purchaseOrgId = purchaseOrgId;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getInformerId() {
        return informerId;
    }
    @ReferDeserialTransfer
    public void setInformerId(Long informerId) {
        this.informerId = informerId;
    }

    public List<AnswerDetailVO> getAnswerDetailList() {
        return answerDetailList;
    }

    public void setAnswerDetailList(List<AnswerDetailVO> answerDetailList) {
        this.answerDetailList = answerDetailList;
    }
}

