package com.ejianc.business.procurement.perform.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 专家抽取记录
 *
 * @author generator
 *
 */
public class ExpertExtractionVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String memo; // 备注
    private String recommendWay; // 推荐方式
    private String otherType; // 其他类型
    private String expertTypeName; // 所需专家类别
    private Long expertTypeId; // 所需专家类别
    private Integer extractNum; // 抽取人数
    private Integer appointNum; // 专家中指定人数
    private Integer expertNum; // 专家人数
    private Integer inviteNum; // 采购方代表人数
    private Integer juryNum; // 评标委员会
    private Integer needTime; // 评标所需时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    private String employeeName; // 经办人名称
    private Long employeeId; // 经办人
    private String purchaseProjectCode; // 采购项目编号
    private Long purchaseProjectId; // 采购项目
    private String place; // 评标地点
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date expertDate; // 专家选取日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startDate; // 评标开始时间
    private BigDecimal budgetTaxMny; // 采购预算
    private String inviteTenderCode; // 拟邀请事项申报表编码
    private Long inviteTenderId; // 拟邀请事项申报表
    private Integer publishType; // 采购公开程度：公开、邀请
    private Integer processType; // 流程类型1平台全流程2平台半流程3全线下
    private Integer biddingProgram; // 招标执行程序：1-法定必招项目；2-一般必招项目
    private Integer purchaseDeployPlace; // 采购实施地点：1-境内；2-境外
    private String planObject; // 采购标的
    private String purchaseProjectName; // 采购项目名称
    private String purchaseType; // 采购方式：1-带量；2-入围；3-框架
    private String executePlanName; // 执行计划名称
    private String executePlanCode; // 执行计划编码
    private Long executePlanId; // 执行计划
    private String businessType; // 业务类别1-工程，2-货物，3-服务
    private Integer organizeShape; // 采购组织形式1-自主采购,2-委托采购
    private Integer permissionType; // 实施权限1-一级集采，2-二级集采，3-所属单位，4-项目经理部
    private String performWay; // 采购实施方式1-招标，2-非招标
    private String orgCode; // 采购实施单位编码
    private String orgName; // 采购实施单位名称
    private Long orgId; // 采购实施单位Id
    private String billCode; // 采购项目编号
    private Integer billState; // 单据状态

    private List<ExpertExtractionSuperviseVO> superviseList = new ArrayList<>(); // 专家抽取记录-监督记录情况表
    private List<ExpertExtractionMemberVO> memberList = new ArrayList<>(); // 专家抽取记录-评标委员会情况

    public Integer getJuryNum() {
        return juryNum;
    }

    public void setJuryNum(Integer juryNum) {
        this.juryNum = juryNum;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getRecommendWay() {
        return recommendWay;
    }

    public void setRecommendWay(String recommendWay) {
        this.recommendWay = recommendWay;
    }

    public String getOtherType() {
        return otherType;
    }

    public void setOtherType(String otherType) {
        this.otherType = otherType;
    }

    public String getExpertTypeName() {
        return expertTypeName;
    }

    public void setExpertTypeName(String expertTypeName) {
        this.expertTypeName = expertTypeName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getExpertTypeId() {
        return expertTypeId;
    }

    @ReferDeserialTransfer
    public void setExpertTypeId(Long expertTypeId) {
        this.expertTypeId = expertTypeId;
    }

    public Integer getExtractNum() {
        return extractNum;
    }

    public void setExtractNum(Integer extractNum) {
        this.extractNum = extractNum;
    }

    public Integer getAppointNum() {
        return appointNum;
    }

    public void setAppointNum(Integer appointNum) {
        this.appointNum = appointNum;
    }

    public Integer getExpertNum() {
        return expertNum;
    }

    public void setExpertNum(Integer expertNum) {
        this.expertNum = expertNum;
    }

    public Integer getInviteNum() {
        return inviteNum;
    }

    public void setInviteNum(Integer inviteNum) {
        this.inviteNum = inviteNum;
    }

    public Integer getNeedTime() {
        return needTime;
    }

    public void setNeedTime(Integer needTime) {
        this.needTime = needTime;
    }

    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getPurchaseProjectCode() {
        return purchaseProjectCode;
    }

    public void setPurchaseProjectCode(String purchaseProjectCode) {
        this.purchaseProjectCode = purchaseProjectCode;
    }

    @ReferSerialTransfer(referCode = "procurement-purchase-project")
    public Long getPurchaseProjectId() {
        return purchaseProjectId;
    }

    @ReferDeserialTransfer
    public void setPurchaseProjectId(Long purchaseProjectId) {
        this.purchaseProjectId = purchaseProjectId;
    }

    public String getPlace() {
        return place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public Date getExpertDate() {
        return expertDate;
    }

    public void setExpertDate(Date expertDate) {
        this.expertDate = expertDate;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    public void setBudgetTaxMny(BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }

    public String getInviteTenderCode() {
        return inviteTenderCode;
    }

    public void setInviteTenderCode(String inviteTenderCode) {
        this.inviteTenderCode = inviteTenderCode;
    }

    public Long getInviteTenderId() {
        return inviteTenderId;
    }

    public void setInviteTenderId(Long inviteTenderId) {
        this.inviteTenderId = inviteTenderId;
    }

    public Integer getPublishType() {
        return publishType;
    }

    public void setPublishType(Integer publishType) {
        this.publishType = publishType;
    }

    public Integer getProcessType() {
        return processType;
    }

    public void setProcessType(Integer processType) {
        this.processType = processType;
    }

    public Integer getBiddingProgram() {
        return biddingProgram;
    }

    public void setBiddingProgram(Integer biddingProgram) {
        this.biddingProgram = biddingProgram;
    }

    public Integer getPurchaseDeployPlace() {
        return purchaseDeployPlace;
    }

    public void setPurchaseDeployPlace(Integer purchaseDeployPlace) {
        this.purchaseDeployPlace = purchaseDeployPlace;
    }

    public String getPlanObject() {
        return planObject;
    }

    public void setPlanObject(String planObject) {
        this.planObject = planObject;
    }

    public String getPurchaseProjectName() {
        return purchaseProjectName;
    }

    public void setPurchaseProjectName(String purchaseProjectName) {
        this.purchaseProjectName = purchaseProjectName;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getExecutePlanName() {
        return executePlanName;
    }

    public void setExecutePlanName(String executePlanName) {
        this.executePlanName = executePlanName;
    }

    public String getExecutePlanCode() {
        return executePlanCode;
    }

    public void setExecutePlanCode(String executePlanCode) {
        this.executePlanCode = executePlanCode;
    }

    @ReferSerialTransfer(referCode = "ejc_procurement_execute_plan")
    public Long getExecutePlanId() {
        return executePlanId;
    }

    @ReferDeserialTransfer
    public void setExecutePlanId(Long executePlanId) {
        this.executePlanId = executePlanId;
    }


    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public Integer getOrganizeShape() {
        return organizeShape;
    }

    public void setOrganizeShape(Integer organizeShape) {
        this.organizeShape = organizeShape;
    }

    public Integer getPermissionType() {
        return permissionType;
    }

    public void setPermissionType(Integer permissionType) {
        this.permissionType = permissionType;
    }

    public String getPerformWay() {
        return performWay;
    }

    public void setPerformWay(String performWay) {
        this.performWay = performWay;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<ExpertExtractionSuperviseVO> getSuperviseList() {
        return superviseList;
    }

    public void setSuperviseList(List<ExpertExtractionSuperviseVO> superviseList) {
        this.superviseList = superviseList;
    }

    public List<ExpertExtractionMemberVO> getMemberList() {
        return memberList;
    }

    public void setMemberList(List<ExpertExtractionMemberVO> memberList) {
        this.memberList = memberList;
    }
}
