package com.ejianc.business.procurement.perform.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 采购招标电子商务平台问题受理单
 * 
 * @author generator
 * 
 */
public class ProblemReceiveVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String suggestMemo; // 建议修改意见
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitPhone; // 提交人联系方式
    private String commitName; //  提交人
    private Long commitId; //  提交人
    private String problemName; //  问题所属板块
    private Long problemId; //  问题所属板块
    private String businessType; // 业务类别1-工程，2-货物，3-服务
    private String problemMemo; // 问题描述
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    private String employeeName; // 经办人名称
    private Long employeeId; // 经办人
    private String orgCode; // 采购实施单位编码
    private String orgName; // 采购实施单位名称
    private Long orgId; // 采购实施单位id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long projectId; // 项目Id
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    

    public String getSuggestMemo() {
        return suggestMemo;
    }

    public void setSuggestMemo(String suggestMemo) {
        this.suggestMemo = suggestMemo;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitPhone() {
        return commitPhone;
    }

    public void setCommitPhone(String commitPhone) {
        this.commitPhone = commitPhone;
    }
    public String getCommitName() {
        return commitName;
    }

    public void setCommitName(String commitName) {
        this.commitName = commitName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getCommitId() {
        return commitId;
    }
    @ReferDeserialTransfer
    public void setCommitId(Long commitId) {
        this.commitId = commitId;
    }
    public String getProblemName() {
        return problemName;
    }

    public void setProblemName(String problemName) {
        this.problemName = problemName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProblemId() {
        return problemId;
    }
    @ReferDeserialTransfer
    public void setProblemId(Long problemId) {
        this.problemId = problemId;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public String getProblemMemo() {
        return problemMemo;
    }

    public void setProblemMemo(String problemMemo) {
        this.problemMemo = problemMemo;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode = "procurement-purchase-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
