package com.ejianc.business.procurement.perform.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 采购结果审批
 * 
 * @author generator
 * 
 */
public class ResultVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long approveId; // 资格性符合性审查id
    private String collecterName; // 组长name
    private Long collecterId; // 组长id
    private String purchaseProjectCode; // 采购项目code
    private String purchaseProjectName; // 采购项目name
    private Long purchaseProjectId; // 采购项目id
    private Integer businessState; // 业务状态
    private Integer negotiationMethod; // 谈判方式
    private Integer nobidMethod; // 非招标交易方式
    private Integer directFlag; // 直接采前公告结果标识
    private String purchaseStage; // 入围阶段：1-一阶段；2-二阶段
    private Integer expertFlag; // 专家抽取记录标识
    private String memo; // 备注
    private Integer bidExtractNum; // 招标-抽取专家人数
    private Integer bidAppointNum; // 招标-专家指定人数
    private Integer bidExpertNum; // 招标-专家人数
    private Integer bidInviteNum; // 招标-采购方代表人数
    private Integer bidJuryNum; // 招标-评委委员会人数
    private String recommendWay; // 推荐方式
    private String auditWay; // 评审方式
    private Date openDate; // 计划开标时间
    private Date sendDate; // 计划发标时间
    private Integer extractNum; // 抽取人数
    private Integer appointNum; // 专家中指定人数
    private Integer expertNum; // 专家人数
    private Integer inviteNum; // 招标代表
    private Integer juryNum; // 评标委员会
    private Date reviewDate; // 技术资格预审审查时间
    private Date noticeDate; // 计划发布资格预审公告时间
    private Date makeDate; // 编制日期
    private String employeeName; // 经办人名称
    private Long employeeId; // 经办人
    private String purchaseStrategyCode; // 采购策划编号
    private Long purchaseStrategyId; // 采购策划
    private Integer bidFileWay; // 招标文件生成方式
    private Integer awarded; // 是否兼中
    private Integer lotNum; // 标段数量
    private Integer lotSplit; // 是否分标段
    private Integer bidMethod; // 评标办法
    private Integer reviewWay; // 资格审查方式
    private String teamName; // 采购小组名单
    private Date needDate; // 采购标的需求时间
    private BigDecimal budgetTaxMny; // 采购预算
    private Integer fundingSituation; // 采购资金落实情况
    private Integer fundingSource; // 资金来源
    private Integer technicalCondition; // 技术条件
    private String uninviteTenderCode; // 拟不招标审批单编号
    private Long uninviteTenderId; // 拟不招标审批单
    private String inviteTenderCode; // 拟邀请事项申报表编码
    private Long inviteTenderId; // 拟邀请事项申报表
    private Integer publishType; // 采购公开程度：公开、邀请
    private Integer processType; // 流程类型1平台全流程2平台半流程3全线下
    private String platformName; // 平台名称
    private Integer infoPlatform; // 采购信息发布平台：1线上(中色电子采购平台)2线上(其他)3线下
    private Integer biddingProgram; // 招标执行程序：1-法定必招项目；2-一般必招项目
    private Integer contractEffective; // 投资项目以获取批准或与业主承包合同已生效：1-是；0-否
    private Integer purchaseDeployPlace; // 采购实施地点：1-境内；2-境外
    private String planObject; // 采购标的
    private String purchaseType; // 采购方式：1-带量；2-入围；3-框架
    private String executePlanName; // 执行计划名称
    private String executePlanCode; // 执行计划编码
    private Long executePlanId; // 执行计划
    private String businessType; // 业务类别1-工程，2-货物，3-服务
    private Integer organizeShape; // 采购组织形式1-自主采购,2-委托采购
    private Integer permissionType; // 实施权限1-一级集采，2-二级集采，3-所属单位，4-项目经理部
    private String performWay; // 采购实施方式1-招标，2-非招标
    private String orgCode; // 采购实施单位编码
    private String orgName; // 采购实施单位名称
    private Long orgId; // 采购实施单位Id
    private String billCode; // 采购项目编号
    private Integer billState; // 单据状态

    private String permissionTypeName;
    private String businessTypeName;

    private List<ResultSupplierVO> resultSupplierList = new ArrayList<>(); // 采购结果审批-供应商
    private List<ResultDetailVO> resultDetailList = new ArrayList<>(); // 采购结果审批-清单


    private List<ResultSupplierVO> resultSupplierList1 = new ArrayList<>(); 
    private List<ResultSupplierVO> resultSupplierList2 = new ArrayList<>(); 
    private List<ResultSupplierVO> resultSupplierList3 = new ArrayList<>(); 
    private List<ResultSupplierVO> resultSupplierList4 = new ArrayList<>(); 
    private List<ResultSupplierVO> resultSupplierList5 = new ArrayList<>(); 
    private List<ResultSupplierVO> resultSupplierList6 = new ArrayList<>(); 
    private List<ResultSupplierVO> resultSupplierList7 = new ArrayList<>(); 
    private List<ResultSupplierVO> resultSupplierList8 = new ArrayList<>(); 
    private List<ResultSupplierVO> resultSupplierList9 = new ArrayList<>(); 
    private List<ResultSupplierVO> resultSupplierList10 = new ArrayList<>(); 

    public void sumSupplierList() {
        resultSupplierList = new ArrayList<>();
        resultSupplierList.addAll(resultSupplierList1);
        resultSupplierList.addAll(resultSupplierList2);
        resultSupplierList.addAll(resultSupplierList3);
        resultSupplierList.addAll(resultSupplierList4);
        resultSupplierList.addAll(resultSupplierList5);
        resultSupplierList.addAll(resultSupplierList6);
        resultSupplierList.addAll(resultSupplierList7);
        resultSupplierList.addAll(resultSupplierList8);
        resultSupplierList.addAll(resultSupplierList9);
        resultSupplierList.addAll(resultSupplierList10);
    }

    public void splitSupplierList() {
        Map<Integer, List<ResultSupplierVO>> groupByLot = resultSupplierList.stream().collect(Collectors.groupingBy(ResultSupplierVO::getLot));
        for (Map.Entry<Integer, List<ResultSupplierVO>> entry : groupByLot.entrySet()) {
            int lot = entry.getKey().intValue();
            if (lot == 1) {
                resultSupplierList1.addAll(entry.getValue());
            } else if (lot == 2) {
                resultSupplierList2.addAll(entry.getValue());
            } else if (lot == 3) {
                resultSupplierList3.addAll(entry.getValue());
            } else if (lot == 4) {
                resultSupplierList4.addAll(entry.getValue());
            } else if (lot == 5) {
                resultSupplierList5.addAll(entry.getValue());
            } else if (lot == 6) {
                resultSupplierList6.addAll(entry.getValue());
            } else if (lot == 7) {
                resultSupplierList7.addAll(entry.getValue());
            } else if (lot == 8) {
                resultSupplierList8.addAll(entry.getValue());
            } else if (lot == 9) {
                resultSupplierList9.addAll(entry.getValue());
            } else if (lot == 10) {
                resultSupplierList10.addAll(entry.getValue());
            }
        }
    }


    private List<ResultDetailVO> resultDetailList1 = new ArrayList<>(); 
    private List<ResultDetailVO> resultDetailList2 = new ArrayList<>(); 
    private List<ResultDetailVO> resultDetailList3 = new ArrayList<>(); 
    private List<ResultDetailVO> resultDetailList4 = new ArrayList<>(); 
    private List<ResultDetailVO> resultDetailList5 = new ArrayList<>(); 
    private List<ResultDetailVO> resultDetailList6 = new ArrayList<>(); 
    private List<ResultDetailVO> resultDetailList7 = new ArrayList<>(); 
    private List<ResultDetailVO> resultDetailList8 = new ArrayList<>(); 
    private List<ResultDetailVO> resultDetailList9 = new ArrayList<>(); 
    private List<ResultDetailVO> resultDetailList10 = new ArrayList<>(); 

    public void sumDetailList() {
        resultDetailList = new ArrayList<>();
        resultDetailList.addAll(resultDetailList1);
        resultDetailList.addAll(resultDetailList2);
        resultDetailList.addAll(resultDetailList3);
        resultDetailList.addAll(resultDetailList4);
        resultDetailList.addAll(resultDetailList5);
        resultDetailList.addAll(resultDetailList6);
        resultDetailList.addAll(resultDetailList7);
        resultDetailList.addAll(resultDetailList8);
        resultDetailList.addAll(resultDetailList9);
        resultDetailList.addAll(resultDetailList10);
    }

    public void splitDetailList() {
        Map<Integer, List<ResultDetailVO>> groupByLot = resultDetailList.stream().collect(Collectors.groupingBy(ResultDetailVO::getLot));
        for (Map.Entry<Integer, List<ResultDetailVO>> entry : groupByLot.entrySet()) {
            int lot = entry.getKey().intValue();
            if (lot == 1) {
                resultDetailList1.addAll(entry.getValue());
            } else if (lot == 2) {
                resultDetailList2.addAll(entry.getValue());
            } else if (lot == 3) {
                resultDetailList3.addAll(entry.getValue());
            } else if (lot == 4) {
                resultDetailList4.addAll(entry.getValue());
            } else if (lot == 5) {
                resultDetailList5.addAll(entry.getValue());
            } else if (lot == 6) {
                resultDetailList6.addAll(entry.getValue());
            } else if (lot == 7) {
                resultDetailList7.addAll(entry.getValue());
            } else if (lot == 8) {
                resultDetailList8.addAll(entry.getValue());
            } else if (lot == 9) {
                resultDetailList9.addAll(entry.getValue());
            } else if (lot == 10) {
                resultDetailList10.addAll(entry.getValue());
            }
        }
    }

    public String getPermissionTypeName() {
        return permissionTypeName;
    }

    public void setPermissionTypeName(String permissionTypeName) {
        this.permissionTypeName = permissionTypeName;
    }

    public String getBusinessTypeName() {
        return businessTypeName;
    }

    public void setBusinessTypeName(String businessTypeName) {
        this.businessTypeName = businessTypeName;
    }

    public List<ResultSupplierVO> getResultSupplierList1() {
        return resultSupplierList1;
    }

    public void setResultSupplierList1(List<ResultSupplierVO> resultSupplierList1) {
        this.resultSupplierList1 = resultSupplierList1;
    }

    public List<ResultSupplierVO> getResultSupplierList2() {
        return resultSupplierList2;
    }

    public void setResultSupplierList2(List<ResultSupplierVO> resultSupplierList2) {
        this.resultSupplierList2 = resultSupplierList2;
    }

    public List<ResultSupplierVO> getResultSupplierList3() {
        return resultSupplierList3;
    }

    public void setResultSupplierList3(List<ResultSupplierVO> resultSupplierList3) {
        this.resultSupplierList3 = resultSupplierList3;
    }

    public List<ResultSupplierVO> getResultSupplierList4() {
        return resultSupplierList4;
    }

    public void setResultSupplierList4(List<ResultSupplierVO> resultSupplierList4) {
        this.resultSupplierList4 = resultSupplierList4;
    }

    public List<ResultSupplierVO> getResultSupplierList5() {
        return resultSupplierList5;
    }

    public void setResultSupplierList5(List<ResultSupplierVO> resultSupplierList5) {
        this.resultSupplierList5 = resultSupplierList5;
    }

    public List<ResultSupplierVO> getResultSupplierList6() {
        return resultSupplierList6;
    }

    public void setResultSupplierList6(List<ResultSupplierVO> resultSupplierList6) {
        this.resultSupplierList6 = resultSupplierList6;
    }

    public List<ResultSupplierVO> getResultSupplierList7() {
        return resultSupplierList7;
    }

    public void setResultSupplierList7(List<ResultSupplierVO> resultSupplierList7) {
        this.resultSupplierList7 = resultSupplierList7;
    }

    public List<ResultSupplierVO> getResultSupplierList8() {
        return resultSupplierList8;
    }

    public void setResultSupplierList8(List<ResultSupplierVO> resultSupplierList8) {
        this.resultSupplierList8 = resultSupplierList8;
    }

    public List<ResultSupplierVO> getResultSupplierList9() {
        return resultSupplierList9;
    }

    public void setResultSupplierList9(List<ResultSupplierVO> resultSupplierList9) {
        this.resultSupplierList9 = resultSupplierList9;
    }

    public List<ResultSupplierVO> getResultSupplierList10() {
        return resultSupplierList10;
    }

    public void setResultSupplierList10(List<ResultSupplierVO> resultSupplierList10) {
        this.resultSupplierList10 = resultSupplierList10;
    }

    public List<ResultDetailVO> getResultDetailList1() {
        return resultDetailList1;
    }

    public void setResultDetailList1(List<ResultDetailVO> resultDetailList1) {
        this.resultDetailList1 = resultDetailList1;
    }

    public List<ResultDetailVO> getResultDetailList2() {
        return resultDetailList2;
    }

    public void setResultDetailList2(List<ResultDetailVO> resultDetailList2) {
        this.resultDetailList2 = resultDetailList2;
    }

    public List<ResultDetailVO> getResultDetailList3() {
        return resultDetailList3;
    }

    public void setResultDetailList3(List<ResultDetailVO> resultDetailList3) {
        this.resultDetailList3 = resultDetailList3;
    }

    public List<ResultDetailVO> getResultDetailList4() {
        return resultDetailList4;
    }

    public void setResultDetailList4(List<ResultDetailVO> resultDetailList4) {
        this.resultDetailList4 = resultDetailList4;
    }

    public List<ResultDetailVO> getResultDetailList5() {
        return resultDetailList5;
    }

    public void setResultDetailList5(List<ResultDetailVO> resultDetailList5) {
        this.resultDetailList5 = resultDetailList5;
    }

    public List<ResultDetailVO> getResultDetailList6() {
        return resultDetailList6;
    }

    public void setResultDetailList6(List<ResultDetailVO> resultDetailList6) {
        this.resultDetailList6 = resultDetailList6;
    }

    public List<ResultDetailVO> getResultDetailList7() {
        return resultDetailList7;
    }

    public void setResultDetailList7(List<ResultDetailVO> resultDetailList7) {
        this.resultDetailList7 = resultDetailList7;
    }

    public List<ResultDetailVO> getResultDetailList8() {
        return resultDetailList8;
    }

    public void setResultDetailList8(List<ResultDetailVO> resultDetailList8) {
        this.resultDetailList8 = resultDetailList8;
    }

    public List<ResultDetailVO> getResultDetailList9() {
        return resultDetailList9;
    }

    public void setResultDetailList9(List<ResultDetailVO> resultDetailList9) {
        this.resultDetailList9 = resultDetailList9;
    }

    public List<ResultDetailVO> getResultDetailList10() {
        return resultDetailList10;
    }

    public void setResultDetailList10(List<ResultDetailVO> resultDetailList10) {
        this.resultDetailList10 = resultDetailList10;
    }

    public Long getApproveId() {
        return approveId;
    }

    public void setApproveId(Long approveId) {
        this.approveId = approveId;
    }
    public String getCollecterName() {
        return collecterName;
    }

    public void setCollecterName(String collecterName) {
        this.collecterName = collecterName;
    }
    public Long getCollecterId() {
        return collecterId;
    }

    public void setCollecterId(Long collecterId) {
        this.collecterId = collecterId;
    }
    public String getPurchaseProjectCode() {
        return purchaseProjectCode;
    }

    public void setPurchaseProjectCode(String purchaseProjectCode) {
        this.purchaseProjectCode = purchaseProjectCode;
    }
    public String getPurchaseProjectName() {
        return purchaseProjectName;
    }

    public void setPurchaseProjectName(String purchaseProjectName) {
        this.purchaseProjectName = purchaseProjectName;
    }
    @ReferSerialTransfer(referCode = "procurement-purchase-project")
    public Long getPurchaseProjectId() {
        return purchaseProjectId;
    }
    @ReferDeserialTransfer
    public void setPurchaseProjectId(Long purchaseProjectId) {
        this.purchaseProjectId = purchaseProjectId;
    }
    public Integer getBusinessState() {
        return businessState;
    }

    public void setBusinessState(Integer businessState) {
        this.businessState = businessState;
    }
    public Integer getNegotiationMethod() {
        return negotiationMethod;
    }

    public void setNegotiationMethod(Integer negotiationMethod) {
        this.negotiationMethod = negotiationMethod;
    }
    public Integer getNobidMethod() {
        return nobidMethod;
    }

    public void setNobidMethod(Integer nobidMethod) {
        this.nobidMethod = nobidMethod;
    }
    public Integer getDirectFlag() {
        return directFlag;
    }

    public void setDirectFlag(Integer directFlag) {
        this.directFlag = directFlag;
    }
    public String getPurchaseStage() {
        return purchaseStage;
    }

    public void setPurchaseStage(String purchaseStage) {
        this.purchaseStage = purchaseStage;
    }
    public Integer getExpertFlag() {
        return expertFlag;
    }

    public void setExpertFlag(Integer expertFlag) {
        this.expertFlag = expertFlag;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBidExtractNum() {
        return bidExtractNum;
    }

    public void setBidExtractNum(Integer bidExtractNum) {
        this.bidExtractNum = bidExtractNum;
    }
    public Integer getBidAppointNum() {
        return bidAppointNum;
    }

    public void setBidAppointNum(Integer bidAppointNum) {
        this.bidAppointNum = bidAppointNum;
    }
    public Integer getBidExpertNum() {
        return bidExpertNum;
    }

    public void setBidExpertNum(Integer bidExpertNum) {
        this.bidExpertNum = bidExpertNum;
    }
    public Integer getBidInviteNum() {
        return bidInviteNum;
    }

    public void setBidInviteNum(Integer bidInviteNum) {
        this.bidInviteNum = bidInviteNum;
    }
    public Integer getBidJuryNum() {
        return bidJuryNum;
    }

    public void setBidJuryNum(Integer bidJuryNum) {
        this.bidJuryNum = bidJuryNum;
    }
    public String getRecommendWay() {
        return recommendWay;
    }

    public void setRecommendWay(String recommendWay) {
        this.recommendWay = recommendWay;
    }
    public String getAuditWay() {
        return auditWay;
    }

    public void setAuditWay(String auditWay) {
        this.auditWay = auditWay;
    }
    public Date getOpenDate() {
        return openDate;
    }

    public void setOpenDate(Date openDate) {
        this.openDate = openDate;
    }
    public Date getSendDate() {
        return sendDate;
    }

    public void setSendDate(Date sendDate) {
        this.sendDate = sendDate;
    }
    public Integer getExtractNum() {
        return extractNum;
    }

    public void setExtractNum(Integer extractNum) {
        this.extractNum = extractNum;
    }
    public Integer getAppointNum() {
        return appointNum;
    }

    public void setAppointNum(Integer appointNum) {
        this.appointNum = appointNum;
    }
    public Integer getExpertNum() {
        return expertNum;
    }

    public void setExpertNum(Integer expertNum) {
        this.expertNum = expertNum;
    }
    public Integer getInviteNum() {
        return inviteNum;
    }

    public void setInviteNum(Integer inviteNum) {
        this.inviteNum = inviteNum;
    }
    public Integer getJuryNum() {
        return juryNum;
    }

    public void setJuryNum(Integer juryNum) {
        this.juryNum = juryNum;
    }
    public Date getReviewDate() {
        return reviewDate;
    }

    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }
    public Date getNoticeDate() {
        return noticeDate;
    }

    public void setNoticeDate(Date noticeDate) {
        this.noticeDate = noticeDate;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getPurchaseStrategyCode() {
        return purchaseStrategyCode;
    }

    public void setPurchaseStrategyCode(String purchaseStrategyCode) {
        this.purchaseStrategyCode = purchaseStrategyCode;
    }
    @ReferSerialTransfer(referCode = "procurement-purchase-strategy")
    public Long getPurchaseStrategyId() {
        return purchaseStrategyId;
    }

    @ReferDeserialTransfer
    public void setPurchaseStrategyId(Long purchaseStrategyId) {
        this.purchaseStrategyId = purchaseStrategyId;
    }
    public Integer getBidFileWay() {
        return bidFileWay;
    }

    public void setBidFileWay(Integer bidFileWay) {
        this.bidFileWay = bidFileWay;
    }
    public Integer getAwarded() {
        return awarded;
    }

    public void setAwarded(Integer awarded) {
        this.awarded = awarded;
    }
    public Integer getLotNum() {
        return lotNum;
    }

    public void setLotNum(Integer lotNum) {
        this.lotNum = lotNum;
    }
    public Integer getLotSplit() {
        return lotSplit;
    }

    public void setLotSplit(Integer lotSplit) {
        this.lotSplit = lotSplit;
    }
    public Integer getBidMethod() {
        return bidMethod;
    }

    public void setBidMethod(Integer bidMethod) {
        this.bidMethod = bidMethod;
    }
    public Integer getReviewWay() {
        return reviewWay;
    }

    public void setReviewWay(Integer reviewWay) {
        this.reviewWay = reviewWay;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    public Date getNeedDate() {
        return needDate;
    }

    public void setNeedDate(Date needDate) {
        this.needDate = needDate;
    }
    public BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    public void setBudgetTaxMny(BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    public Integer getFundingSituation() {
        return fundingSituation;
    }

    public void setFundingSituation(Integer fundingSituation) {
        this.fundingSituation = fundingSituation;
    }
    public Integer getFundingSource() {
        return fundingSource;
    }

    public void setFundingSource(Integer fundingSource) {
        this.fundingSource = fundingSource;
    }
    public Integer getTechnicalCondition() {
        return technicalCondition;
    }

    public void setTechnicalCondition(Integer technicalCondition) {
        this.technicalCondition = technicalCondition;
    }
    public String getUninviteTenderCode() {
        return uninviteTenderCode;
    }

    public void setUninviteTenderCode(String uninviteTenderCode) {
        this.uninviteTenderCode = uninviteTenderCode;
    }
    @ReferSerialTransfer(referCode = "un_tender_matter_code")
    public Long getUninviteTenderId() {
        return uninviteTenderId;
    }

    @ReferDeserialTransfer
    public void setUninviteTenderId(Long uninviteTenderId) {
        this.uninviteTenderId = uninviteTenderId;
    }
    public String getInviteTenderCode() {
        return inviteTenderCode;
    }

    public void setInviteTenderCode(String inviteTenderCode) {
        this.inviteTenderCode = inviteTenderCode;
    }
    @ReferSerialTransfer(referCode = "invited_tender_matter_code")
    public Long getInviteTenderId() {
        return inviteTenderId;
    }

    @ReferDeserialTransfer
    public void setInviteTenderId(Long inviteTenderId) {
        this.inviteTenderId = inviteTenderId;
    }
    public Integer getPublishType() {
        return publishType;
    }

    public void setPublishType(Integer publishType) {
        this.publishType = publishType;
    }
    public Integer getProcessType() {
        return processType;
    }

    public void setProcessType(Integer processType) {
        this.processType = processType;
    }
    public String getPlatformName() {
        return platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }
    public Integer getInfoPlatform() {
        return infoPlatform;
    }

    public void setInfoPlatform(Integer infoPlatform) {
        this.infoPlatform = infoPlatform;
    }
    public Integer getBiddingProgram() {
        return biddingProgram;
    }

    public void setBiddingProgram(Integer biddingProgram) {
        this.biddingProgram = biddingProgram;
    }
    public Integer getContractEffective() {
        return contractEffective;
    }

    public void setContractEffective(Integer contractEffective) {
        this.contractEffective = contractEffective;
    }
    public Integer getPurchaseDeployPlace() {
        return purchaseDeployPlace;
    }

    public void setPurchaseDeployPlace(Integer purchaseDeployPlace) {
        this.purchaseDeployPlace = purchaseDeployPlace;
    }
    public String getPlanObject() {
        return planObject;
    }

    public void setPlanObject(String planObject) {
        this.planObject = planObject;
    }
    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getExecutePlanName() {
        return executePlanName;
    }

    public void setExecutePlanName(String executePlanName) {
        this.executePlanName = executePlanName;
    }
    public String getExecutePlanCode() {
        return executePlanCode;
    }

    public void setExecutePlanCode(String executePlanCode) {
        this.executePlanCode = executePlanCode;
    }
    @ReferSerialTransfer(referCode = "ejc_procurement_execute_plan")
    public Long getExecutePlanId() {
        return executePlanId;
    }
    @ReferDeserialTransfer
    public void setExecutePlanId(Long executePlanId) {
        this.executePlanId = executePlanId;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public Integer getOrganizeShape() {
        return organizeShape;
    }

    public void setOrganizeShape(Integer organizeShape) {
        this.organizeShape = organizeShape;
    }
    public Integer getPermissionType() {
        return permissionType;
    }

    public void setPermissionType(Integer permissionType) {
        this.permissionType = permissionType;
    }
    public String getPerformWay() {
        return performWay;
    }

    public void setPerformWay(String performWay) {
        this.performWay = performWay;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<ResultSupplierVO> getResultSupplierList() {
        return resultSupplierList;
     }

     public void setResultSupplierList(List<ResultSupplierVO> resultSupplierList) {
        this.resultSupplierList = resultSupplierList;
     }
     public List<ResultDetailVO> getResultDetailList() {
        return resultDetailList;
     }

     public void setResultDetailList(List<ResultDetailVO> resultDetailList) {
        this.resultDetailList = resultDetailList;
     }
}
