package com.ejianc.business.procurement.plan.vo;

import com.ejianc.business.procurement.plan.vo.YearBudgetDetailVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 年度预算
 * 
 * @author generator
 * 
 */
public class YearBudgetVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private BigDecimal planTotalTaxMny; // 计划值合计金额
    private BigDecimal lastYearTotalTaxMny; // 上年实际值合计金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    private String billCode; // 单据编号
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private String orgName; // 项目部名称
    private String orgCode; // 项目部编码
    private String parentOrgName; // 项目部上级名称
    private String parentOrgCode; // 项目部上级编码
    private String allOrgName; // 所属组织(所属单位-项目经理部)
    private String employeeName; // 经办人名称
    private String memo; // 备注
    private Integer billState; // 单据状态
    private Long projectId; // 项目Id
    private Long orgId; // 项目部Id
    private Long parentOrgId; // 项目部上级Id
    private Long employeeId; // 经办人
    
    private List<YearBudgetDetailVO> yearBudgetDetailList = new ArrayList<>(); // 年度预算-明细

    public BigDecimal getPlanTotalTaxMny() {
        return planTotalTaxMny;
    }

    public void setPlanTotalTaxMny(BigDecimal planTotalTaxMny) {
        this.planTotalTaxMny = planTotalTaxMny;
    }
    public BigDecimal getLastYearTotalTaxMny() {
        return lastYearTotalTaxMny;
    }

    public void setLastYearTotalTaxMny(BigDecimal lastYearTotalTaxMny) {
        this.lastYearTotalTaxMny = lastYearTotalTaxMny;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getAllOrgName() {
        return allOrgName;
    }

    public void setAllOrgName(String allOrgName) {
        this.allOrgName = allOrgName;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    
     public List<YearBudgetDetailVO> getYearBudgetDetailList() {
        return yearBudgetDetailList;
     }

     public void setYearBudgetDetailList(List<YearBudgetDetailVO> yearBudgetDetailList) {
        this.yearBudgetDetailList = yearBudgetDetailList;
     }
}
