package com.ejianc.business.procurement.perform.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.procurement.perform.vo.FeeReductionDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 供应商费用减免申请表
 * 
 * @author generator
 * 
 */
public class FeeReductionVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private BigDecimal shouldPayMny; // 应交总额
    private BigDecimal reductionMny; // 减免总额
    private BigDecimal lastPayMny; // 最终缴纳金额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    private String billCode; // 单据编号
    private String orgName; // 采购实施单位名称
    private String orgCode; // 采购实施单位编码
    private String allOrgName; // 所属组织(所属单位-项目经理部)
    private String employeeName; // 经办人名称
    private String memo; // 备注
    private String name; // 计划分配名称
    private String purchaseProjectName; // 采购项目名称
    private String purchaseProjectCode; // 采购项目编码
    private String businessType; // 标的物类别1-工程，2-货物，3-服务
    private String supplierName; // 供应商名称
    private String gradeName; // 供应商等级名称
    private String socCode; // 统一社会信用代码
    private String legalPerson; // 法人代表
    private String legalPhone; // 联系电话
    private String authPhone; // 授权人联系电话
    private Integer billState; // 单据状态
    private Long orgId; // 采购实施单位Id
    private Long employeeId; // 经办人
    private Long purchaseProjectId; // 采购项目id
    private Long supplierId; // 供应商id
    private Long gradeId; // 供应商等级
    private Long authPerson; // 授权人id
    
    private List<FeeReductionDetailVO> feeReductionDetailList = new ArrayList<>(); // 供应商费用减免申请表明细

    public BigDecimal getShouldPayMny() {
        return shouldPayMny;
    }

    public void setShouldPayMny(BigDecimal shouldPayMny) {
        this.shouldPayMny = shouldPayMny;
    }
    public BigDecimal getReductionMny() {
        return reductionMny;
    }

    public void setReductionMny(BigDecimal reductionMny) {
        this.reductionMny = reductionMny;
    }
    public BigDecimal getLastPayMny() {
        return lastPayMny;
    }

    public void setLastPayMny(BigDecimal lastPayMny) {
        this.lastPayMny = lastPayMny;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getAllOrgName() {
        return allOrgName;
    }

    public void setAllOrgName(String allOrgName) {
        this.allOrgName = allOrgName;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getPurchaseProjectName() {
        return purchaseProjectName;
    }

    public void setPurchaseProjectName(String purchaseProjectName) {
        this.purchaseProjectName = purchaseProjectName;
    }
    public String getPurchaseProjectCode() {
        return purchaseProjectCode;
    }

    public void setPurchaseProjectCode(String purchaseProjectCode) {
        this.purchaseProjectCode = purchaseProjectCode;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    public String getSocCode() {
        return socCode;
    }

    public void setSocCode(String socCode) {
        this.socCode = socCode;
    }
    public String getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }
    public String getLegalPhone() {
        return legalPhone;
    }

    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }
    public String getAuthPhone() {
        return authPhone;
    }

    public void setAuthPhone(String authPhone) {
        this.authPhone = authPhone;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    @ReferSerialTransfer(referCode = "procurement-purchase-project")
    public Long getPurchaseProjectId() {
        return purchaseProjectId;
    }
    @ReferDeserialTransfer
    public void setPurchaseProjectId(Long purchaseProjectId) {
        this.purchaseProjectId = purchaseProjectId;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public Long getGradeId() {
        return gradeId;
    }

    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getAuthPerson() {
        return authPerson;
    }
    @ReferDeserialTransfer
    public void setAuthPerson(Long authPerson) {
        this.authPerson = authPerson;
    }
    
     public List<FeeReductionDetailVO> getFeeReductionDetailList() {
        return feeReductionDetailList;
     }

     public void setFeeReductionDetailList(List<FeeReductionDetailVO> feeReductionDetailList) {
        this.feeReductionDetailList = feeReductionDetailList;
     }
}
