package com.ejianc.business.procurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procurement.bean.CatalogCategoryEntity;
import com.ejianc.business.procurement.service.ICatalogCategoryService;
import com.ejianc.business.procurement.vo.CatalogCategoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 一级集采目录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("catalogCategory")
public class CatalogCategoryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "CATALOG_CATEGORY_CODE";

    @Autowired
    private ICatalogCategoryService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CatalogCategoryVO> saveOrUpdate(@RequestBody CatalogCategoryVO saveOrUpdateVO) {
        CatalogCategoryEntity entity = BeanMapper.map(saveOrUpdateVO, CatalogCategoryEntity.class);
        if (StringUtils.isBlank(entity.getCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            LambdaQueryWrapper<CatalogCategoryEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(CatalogCategoryEntity::getTenantId, InvocationInfoProxy.getTenantid());
            queryWrapper.eq(CatalogCategoryEntity::getCode, entity.getCode().trim());
            if (service.count(queryWrapper) > 0) {
                throw new BusinessException("编码已存在，请重新填写！");
            }
        }
        if (entity.getId() == null) {
            entity.setId(IdWorker.getId());
        }
        if (entity.getParentId() != null && entity.getParentId() > 0) {
            CatalogCategoryEntity uniqueBean = service.getById(entity.getParentId());
            entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        service.saveOrUpdate(entity, false);
        CatalogCategoryVO vo = BeanMapper.map(entity, CatalogCategoryVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CatalogCategoryVO> queryDetail(Long id) {
        CatalogCategoryEntity entity = service.selectById(id);
        CatalogCategoryVO vo = BeanMapper.map(entity, CatalogCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CatalogCategoryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CatalogCategoryVO vo : vos) {
                //有子节点不允许删除
                LambdaQueryWrapper<CatalogCategoryEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(CatalogCategoryEntity::getParentId, vo.getId());
                if (service.count(queryWrapper) > 0) {
                    return CommonResponse.error("该分类下有子分类不允许删除");
                }
            }
        }
        service.removeByIds(vos.stream().map(CatalogCategoryVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<CatalogCategoryEntity> dataList = service.queryList(param);

        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success(jsonObject);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<CatalogCategoryEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CatalogCategory-export.xlsx", beans, response);
    }


    @RequestMapping(value = "/refCatalogCategoryTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refCatalogCategoryTree(@RequestParam(required = false) String condition,
                                                              @RequestParam(required = false) Long pid, @RequestParam(required = false) String searchText) {
        List<CatalogCategoryEntity> dataList = null;
        try {
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
            if (pid != null) {
                param.getParams().put("parentId", new Parameter(QueryParam.EQ, pid));
            }
            dataList = service.queryList(param);
            List<Map> map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData(map);
        } catch (Exception e) {
            return null;
        }
    }

    @RequestMapping(value = "/enableOrDisable", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> enableOrDisable(@RequestBody CatalogCategoryVO categoryVO) {
        if (categoryVO.getId() != null && categoryVO.getEnabled() != null) {
            LambdaUpdateWrapper<CatalogCategoryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(CatalogCategoryEntity::getId, categoryVO.getId());
            updateWrapper.set(CatalogCategoryEntity::getEnabled, categoryVO.getEnabled());
            service.update(updateWrapper);
        }
        return CommonResponse.success("操作成功");
    }
}
