package com.ejianc.business.procurement.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.plan.bean.PurchaseStrategyDetailEntity;
import com.ejianc.business.procurement.plan.bean.PurchaseStrategyEntity;
import com.ejianc.business.procurement.plan.bean.PurchaseStrategyRecordEntity;
import com.ejianc.business.procurement.plan.service.IPurchaseStrategyDetailService;
import com.ejianc.business.procurement.plan.service.IPurchaseStrategyRecordService;
import com.ejianc.business.procurement.plan.service.IPurchaseStrategyService;
import com.ejianc.business.procurement.plan.vo.PurchaseStrategyDetailVO;
import com.ejianc.business.procurement.plan.vo.PurchaseStrategyRecordVO;
import com.ejianc.business.procurement.plan.vo.PurchaseStrategyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 采购策划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("purchaseStrategy")
public class PurchaseStrategyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PURCHASE_STRATEGY_CODE";

    @Autowired
    private IPurchaseStrategyService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IPurchaseStrategyDetailService detailService;

    @Autowired
    private IPurchaseStrategyRecordService recordService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseStrategyVO> saveOrUpdate(@RequestBody PurchaseStrategyVO saveOrUpdateVO) {
        PurchaseStrategyEntity entity = BeanMapper.map(saveOrUpdateVO, PurchaseStrategyEntity.class);
        if (StringUtils.isBlank(entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (null == entity.getId()) {
            //设置为未变更
            entity.setChangeState(0);
            //变更版本号
            entity.setChangeVersion(1);
        }
        service.saveOrUpdate(entity, false);
        PurchaseStrategyVO vo = BeanMapper.map(entity, PurchaseStrategyVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseStrategyVO> queryDetail(Long id) {
        PurchaseStrategyEntity entity = service.selectById(id);
        PurchaseStrategyVO vo = BeanMapper.map(entity, PurchaseStrategyVO.class);
        if (null != vo && vo.getChangeState().intValue() == 2) {
            LambdaQueryWrapper<PurchaseStrategyRecordEntity> hisQuery = new LambdaQueryWrapper<>();
            hisQuery.eq(PurchaseStrategyRecordEntity::getSourcePlanId, id);
            hisQuery.orderByDesc(PurchaseStrategyRecordEntity::getCreateTime);
            List<PurchaseStrategyRecordEntity> list = recordService.list(hisQuery);
            List<PurchaseStrategyRecordVO> purchaseStrategyRecordVOS = BeanMapper.mapList(list, PurchaseStrategyRecordVO.class);
            vo.setHistoryList(purchaseStrategyRecordVOS);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseStrategyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PurchaseStrategyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PurchaseStrategyVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchaseStrategyVO>> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "projectCode", "allOrgName", "employeeName"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<PurchaseStrategyEntity> page = service.queryPage(param, false);
        IPage<PurchaseStrategyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseStrategyVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "projectCode", "allOrgName", "employeeName"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PurchaseStrategyEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("PurchaseStrategy-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchaseStrategyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchaseStrategyVO>> refPurchaseStrategyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PurchaseStrategyEntity> page = service.queryPage(param, false);
        IPage<PurchaseStrategyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseStrategyVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchaseStrategyDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchaseStrategyDetailVO>> refPurchaseStrategyDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                         String condition,
                                                                                         String searchObject,
                                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PurchaseStrategyDetailEntity> page = detailService.queryPage(param, false);
        IPage<PurchaseStrategyDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseStrategyDetailVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
