package com.ejianc.business.procurement.plan.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.procurement.plan.bean.PurchaseStrategyChangeDetailEntity;
/**
 * 采购策划变更
 * 
 * @author generator
 * 
 */
 @TableName("ejc_procurement_purchase_strategy_change")
public class PurchaseStrategyChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="pre_tax_mny")
    private BigDecimal preTaxMny; // 策划暂估金额(万元)
    @TableField(value="bid_tax_mny")
    private BigDecimal bidTaxMny; // 市场投标金额(万元)
    @TableField(value="sub_tax_mny")
    private BigDecimal subTaxMny; // 拟分包金额(万元)
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效时间
    @TableField(value="make_date")
    private Date makeDate; // 编制日期
    @TableField(value="cur_changing_plan_code")
    private String curChangingPlanCode; // 变更编码
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级编码
    @TableField(value="all_org_name")
    private String allOrgName; // 所属组织(所属单位-项目经理部)
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="business_type")
    private String businessType; // 业务类别1-工程，2-货物，3-服务
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="change_version")
    private Integer changeVersion; // 版本
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="change_state")
    private Integer changeState; // 变更状态: 0-未变更，1-变更中，2-已变更
    @TableField(value="cur_changing_plan_id")
    private Long curChangingPlanId; // 变更id
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="org_id")
    private Long orgId; // 项目部Id
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级Id
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="source_plan_id")
    private Long sourcePlanId; // 原计划id
    @TableField(value = "change_reason")
    private String changeReason; // 变更原因
    
    @TableField(exist=false)
    @SubEntity(serviceName="purchaseStrategyChangeDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<PurchaseStrategyChangeDetailEntity> purchaseStrategyDetailList = new ArrayList<>(); // 采购策划变更-明细

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public BigDecimal getPreTaxMny() {
        return preTaxMny;
    }

    public void setPreTaxMny(BigDecimal preTaxMny) {
        this.preTaxMny = preTaxMny;
    }
    public BigDecimal getBidTaxMny() {
        return bidTaxMny;
    }

    public void setBidTaxMny(BigDecimal bidTaxMny) {
        this.bidTaxMny = bidTaxMny;
    }
    public BigDecimal getSubTaxMny() {
        return subTaxMny;
    }

    public void setSubTaxMny(BigDecimal subTaxMny) {
        this.subTaxMny = subTaxMny;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getCurChangingPlanCode() {
        return curChangingPlanCode;
    }

    public void setCurChangingPlanCode(String curChangingPlanCode) {
        this.curChangingPlanCode = curChangingPlanCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getAllOrgName() {
        return allOrgName;
    }

    public void setAllOrgName(String allOrgName) {
        this.allOrgName = allOrgName;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Long getCurChangingPlanId() {
        return curChangingPlanId;
    }

    public void setCurChangingPlanId(Long curChangingPlanId) {
        this.curChangingPlanId = curChangingPlanId;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Long getSourcePlanId() {
        return sourcePlanId;
    }

    public void setSourcePlanId(Long sourcePlanId) {
        this.sourcePlanId = sourcePlanId;
    }

    public List<PurchaseStrategyChangeDetailEntity> getPurchaseStrategyDetailList() {
        return purchaseStrategyDetailList;
    }

    public void setPurchaseStrategyDetailList(List<PurchaseStrategyChangeDetailEntity> purchaseStrategyDetailList) {
        this.purchaseStrategyDetailList = purchaseStrategyDetailList;
    }
}
