package com.ejianc.business.procurement.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procurement.plan.bean.*;
import com.ejianc.business.procurement.plan.service.IPurchaseStrategyChangeService;
import com.ejianc.business.procurement.plan.service.IPurchaseStrategyDetailService;
import com.ejianc.business.procurement.plan.service.IPurchaseStrategyRecordService;
import com.ejianc.business.procurement.plan.service.IPurchaseStrategyService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("purchaseStrategyChange")
public class PurchaseStrategyChangeBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IPurchaseStrategyChangeService changeService;

    @Autowired
    private IPurchaseStrategyService strategyService;

    @Autowired
    private IPurchaseStrategyDetailService strategyDetailService;

    @Autowired
    private IPurchaseStrategyRecordService recordService;

    @Autowired
    private IBillTypeApi billTypeApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //变更表
        Date effectiveDate = new Date();
        PurchaseStrategyChangeEntity changeEntity = changeService.selectById(billId);
        LambdaUpdateWrapper<PurchaseStrategyChangeEntity> projectChangeProEntityLambdaUpdateWrapper = new LambdaUpdateWrapper<>();
        projectChangeProEntityLambdaUpdateWrapper.eq(PurchaseStrategyChangeEntity::getId, billId);
        projectChangeProEntityLambdaUpdateWrapper.set(PurchaseStrategyChangeEntity::getEffectiveDate, effectiveDate);
        changeService.update(projectChangeProEntityLambdaUpdateWrapper);

        //策划主表
        PurchaseStrategyEntity budgetEntity = strategyService.selectById(changeEntity.getSourcePlanId());
        PurchaseStrategyRecordEntity historyEntity = BeanMapper.map(budgetEntity, PurchaseStrategyRecordEntity.class);
        historyEntity.setSourcePlanId(changeEntity.getSourcePlanId());//原策划主键
        historyEntity.setId(null);
        historyEntity.setCreateUserCode(null);
        historyEntity.setCreateTime(changeEntity.getCreateTime());
        historyEntity.setVersion(null);
        historyEntity.setUpdateTime(null);
        historyEntity.setUpdateUserCode(null);
        historyEntity.setCurChangingPlanCode(changeEntity.getBillCode());
        historyEntity.setChangeReason(changeEntity.getChangeReason());
        historyEntity.setEffectiveDate(effectiveDate);
        historyEntity.setBillCode(budgetEntity.getBillCode() + "-" + budgetEntity.getChangeVersion());
        List<PurchaseStrategyRecordDetailEntity> historyDetailList = historyEntity.getPurchaseStrategyDetailList();
        if (CollectionUtils.isNotEmpty(historyDetailList)) {
            for (PurchaseStrategyRecordDetailEntity historyProEntity : historyDetailList) {
                historyProEntity.setTargetMainId(budgetEntity.getId());//原策划主键
                historyProEntity.setTargetId(historyProEntity.getId());
                historyProEntity.setId(null);
            }
        }
        //同步原合同到记录表
        recordService.saveOrUpdate(historyEntity, false);

        //回写项目预算主表 会写标体金额字段
        LambdaUpdateWrapper<PurchaseStrategyEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(PurchaseStrategyEntity::getId, budgetEntity.getId());
        updateWrapper.set(PurchaseStrategyEntity::getPreTaxMny, changeEntity.getPreTaxMny());
        updateWrapper.set(PurchaseStrategyEntity::getSubTaxMny, changeEntity.getSubTaxMny());
        updateWrapper.set(PurchaseStrategyEntity::getBidTaxMny, changeEntity.getBidTaxMny());
        updateWrapper.set(PurchaseStrategyEntity::getCurChangingPlanId, changeEntity.getId());
        updateWrapper.set(PurchaseStrategyEntity::getChangeState, 2);
        updateWrapper.set(PurchaseStrategyEntity::getCurChangingPlanCode, changeEntity.getBillCode());
        updateWrapper.set(PurchaseStrategyEntity::getChangeReason, changeEntity.getChangeReason());
        updateWrapper.set(PurchaseStrategyEntity::getChangeVersion, changeEntity.getVersion());
        strategyService.update(updateWrapper);
        //更新子表
        List<PurchaseStrategyChangeDetailEntity> changeDetailList = changeEntity.getPurchaseStrategyDetailList();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            List<PurchaseStrategyDetailEntity> addOrUpdateList = new ArrayList<>();
            List<Long> delList = new ArrayList<>();
            //需要判断是走更新还是新增
            List<PurchaseStrategyDetailEntity> detailList = budgetEntity.getPurchaseStrategyDetailList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                Map<Long, PurchaseStrategyDetailEntity> detailMap = detailList.stream().collect(Collectors.toMap(k -> k.getId(), (k) -> k));
                Map<Long, PurchaseStrategyChangeDetailEntity> changeDetailMap = changeDetailList.stream().collect(Collectors.toMap(k -> k.getId(), (k) -> k));
                for (PurchaseStrategyChangeDetailEntity detailChangeProEntity : changeDetailList) {
                    if (detailMap.containsKey(detailChangeProEntity.getTargetId())) {
                        //修改
                        PurchaseStrategyDetailEntity detailProEntity = detailMap.get(detailChangeProEntity.getTargetId());
                        if (detailProEntity != null) {
                            PurchaseStrategyDetailEntity entity = BeanMapper.map(detailChangeProEntity, PurchaseStrategyDetailEntity.class);
                            entity.setTargetMainId(changeEntity.getId());
                            entity.setTargetId(detailChangeProEntity.getId());
                            entity.setId(detailProEntity.getId());
                            entity.setVersion(detailProEntity.getVersion());
                            entity.setPid(detailProEntity.getPid());
                            addOrUpdateList.add(entity);
                            detailMap.remove(detailChangeProEntity.getTargetId());
                        }
                    } else {
                        //新增
                        PurchaseStrategyDetailEntity entity = BeanMapper.map(detailChangeProEntity, PurchaseStrategyDetailEntity.class);
                        entity.setTargetMainId(changeEntity.getId());
                        entity.setTargetId(detailChangeProEntity.getId());
                        entity.setVersion(1);
                        entity.setPid(budgetEntity.getId());
                        addOrUpdateList.add(entity);
                    }
                }
                if (!detailMap.isEmpty()) {
                    delList.addAll(detailMap.keySet());
                }
                //删除
                if (CollectionUtils.isNotEmpty(delList)) {
                    strategyDetailService.removeByIds(delList);
                }
                //修改or新增
                if (CollectionUtils.isNotEmpty(addOrUpdateList)) {
                    strategyDetailService.saveOrUpdateBatch(addOrUpdateList, addOrUpdateList.size());
                }
            } else {
                //原清单为空全部新增 变更子表同步->原清单
                List<PurchaseStrategyDetailEntity> detailProEntityList = BeanMapper.mapList(changeDetailList, PurchaseStrategyDetailEntity.class);
                for (PurchaseStrategyDetailEntity budgetProjectDetailProEntity : detailProEntityList) {
                    budgetProjectDetailProEntity.setTargetMainId(changeEntity.getId());
                    budgetProjectDetailProEntity.setTargetId(changeEntity.getId());
                    budgetProjectDetailProEntity.setPid(budgetEntity.getId());
                    budgetProjectDetailProEntity.setVersion(1);
                }
                strategyDetailService.saveOrUpdateBatch(detailProEntityList);
            }
        } else {
            //变更的子表为空删除主表的子表
            LambdaQueryWrapper<PurchaseStrategyDetailEntity> re = new LambdaQueryWrapper<>();
            re.eq(PurchaseStrategyDetailEntity::getPid, budgetEntity.getId());
            strategyDetailService.remove(re);
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }

}
