package com.ejianc.business.procurement.plan.service.impl;

import com.ejianc.business.procurement.plan.bean.PurchaseStrategyEntity;
import com.ejianc.business.procurement.plan.bean.PurchaseStrategyRecordEntity;
import com.ejianc.business.procurement.plan.mapper.PurchaseStrategyMapper;
import com.ejianc.business.procurement.plan.service.IPurchaseStrategyRecordService;
import com.ejianc.business.procurement.plan.service.IPurchaseStrategyService;
import com.ejianc.business.procurement.plan.vo.PurchaseStrategyDetailVO;
import com.ejianc.business.procurement.plan.vo.PurchaseStrategyRecordDetailVO;
import com.ejianc.business.procurement.plan.vo.PurchaseStrategyRecordVO;
import com.ejianc.business.procurement.plan.vo.PurchaseStrategyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 采购策划
 * 
 * @author generator
 * 
 */
@Service("purchaseStrategyService")
public class PurchaseStrategyServiceImpl extends BaseServiceImpl<PurchaseStrategyMapper, PurchaseStrategyEntity> implements IPurchaseStrategyService{


    @Autowired
    private IPurchaseStrategyRecordService recordService;

    @Override
    public  List<PurchaseStrategyDetailVO> compareDetail(Long id, Long historyId) {
        PurchaseStrategyEntity entity = this.selectById(id);
        PurchaseStrategyVO vo = BeanMapper.map(entity, PurchaseStrategyVO.class);
        List<PurchaseStrategyDetailVO> detailList = vo.getPurchaseStrategyDetailList();
        PurchaseStrategyRecordEntity  recordEntity = recordService.selectById(historyId);
        PurchaseStrategyRecordVO historyVO = BeanMapper.map(recordEntity, PurchaseStrategyRecordVO.class);
        List<PurchaseStrategyRecordDetailVO> list = historyVO.getPurchaseStrategyDetailList();
        if (CollectionUtils.isNotEmpty(list)) {
            CompareDifferenceUtil.compareList(list, detailList, true);
        }
        return detailList;
    }
}
