/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.plan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.plan.bean.DemandPlanEntity;
import com.ejianc.business.procurement.plan.service.IDemandPlanDetailService;
import com.ejianc.business.procurement.plan.service.IDemandPlanService;
import com.ejianc.business.procurement.plan.vo.DemandPlanDetailVO;
import com.ejianc.business.procurement.plan.vo.DemandPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"demandPlan"})
public class DemandPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDemandPlanService service;
    @Autowired
    private IDemandPlanDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    private static Map<String, String> codeRuleMap = new HashMap<String, String>();

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DemandPlanVO> saveOrUpdate(@RequestBody DemandPlanVO saveOrUpdateVO) {
        DemandPlanEntity entity = (DemandPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DemandPlanEntity.class));
        if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)codeRuleMap.get(entity.getBusinessType()), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        DemandPlanVO vo = (DemandPlanVO)BeanMapper.map((Object)((Object)entity), DemandPlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DemandPlanVO> queryDetail(Long id) {
        DemandPlanEntity entity = (DemandPlanEntity)((Object)this.service.selectById(id));
        DemandPlanVO vo = (DemandPlanVO)BeanMapper.map((Object)((Object)entity), DemandPlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DemandPlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DemandPlanVO demandPlanVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DemandPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("allOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("planObject");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DemandPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("allOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("planObject");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("DemandPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDemandPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DemandPlanVO> refDemandPlanData(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        List dataList;
        List list;
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.containsKey((Object)"orgId")) {
                Long orgId = _con.getLong("orgId");
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
            if (_con.containsKey((Object)"businessType")) {
                param.getParams().put("businessType", new Parameter("eq", _con.get((Object)"businessType")));
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(list = BeanMapper.mapList((Iterable)(dataList = this.service.queryList(param)), DemandPlanVO.class)))) {
            for (DemandPlanVO vo : list) {
                vo.setName(vo.getBillCode());
            }
        }
        return list;
    }

    @RequestMapping(value={"/refDemandPlanDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DemandPlanDetailVO>> refDemandPlanDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, @RequestParam(required=false) String relyCondition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        DemandPlanEntity planEntity = new DemandPlanEntity();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5de6\u4fa7\u6570\u636e\uff01");
        }
        Long planId = Long.valueOf(relyCondition.split("=")[1]);
        param.getParams().put("planId", new Parameter("eq", (Object)planId));
        planEntity = (DemandPlanEntity)((Object)this.service.selectById(planId));
        IPage page = this.detailService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resList = BeanMapper.mapList((Iterable)page.getRecords(), DemandPlanDetailVO.class);
            for (DemandPlanDetailVO vo : resList) {
                vo.setBillCode(planEntity.getBillCode());
                vo.setProjectName(planEntity.getProjectName());
                vo.setAllOrgName(planEntity.getAllOrgName());
            }
        }
        pageData.setRecords(resList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    static {
        codeRuleMap.put("2", "DEMAND_PLAN_CODE");
        codeRuleMap.put("1", "DEMAND_PLAN_GC_CODE");
        codeRuleMap.put("3", "DEMAND_PLAN_FW_CODE");
    }
}

