/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procurement.plan.bean.AnswerDetailEntity;
import com.ejianc.business.procurement.plan.bean.AnswerEntity;
import com.ejianc.business.procurement.plan.bean.ReplyDetailEntity;
import com.ejianc.business.procurement.plan.bean.ReplyEntity;
import com.ejianc.business.procurement.plan.service.IAnswerService;
import com.ejianc.business.procurement.plan.service.IReplyDetailService;
import com.ejianc.business.procurement.plan.service.IReplyService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="answer")
public class AnswerBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAnswerService answerService;
    @Autowired
    private IReplyService replyService;
    @Autowired
    private IReplyDetailService replyDetailService;
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String HW_BILL_CODE = "BT202512000002";
    private static final String REPLY_HW_BILL_CODE = "BT202512000010";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        AnswerEntity answerEntity = (AnswerEntity)((Object)this.answerService.selectById(billId));
        ReplyEntity replyEntity = (ReplyEntity)((Object)BeanMapper.map((Object)((Object)answerEntity), ReplyEntity.class));
        replyEntity.setId(IdWorker.getId());
        replyEntity.setBillState(0);
        replyEntity.setBillState(1);
        this.replyService.save((Object)replyEntity);
        List<AnswerDetailEntity> answerDetailList = answerEntity.getAnswerDetailList();
        List replyDetailEntities = BeanMapper.mapList(answerDetailList, ReplyDetailEntity.class);
        for (ReplyDetailEntity replyDetailEntity : replyDetailEntities) {
            replyDetailEntity.setSourceDetailId(replyDetailEntity.getId());
            replyDetailEntity.setId(IdWorker.getId());
            replyDetailEntity.setSourceId(answerEntity.getId());
            CommonResponse responseCopy = this.attachmentApi.copyFilesFromSourceBillToTargetBill(replyDetailEntity.getSourceDetailId().toString(), HW_BILL_CODE, "answerYwFile", replyDetailEntity.getId().toString(), REPLY_HW_BILL_CODE, "replyYwFile");
            if (responseCopy.isSuccess()) continue;
            throw new BusinessException("\u62db\u6807\u7acb\u9879\u5411\u62db\u6807\u6587\u4ef6\u9644\u4ef6\u590d\u5236\u5931\u8d25:" + responseCopy.getMsg());
        }
        this.replyDetailService.saveBatch(replyDetailEntities);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaQueryWrapper lambdaReply = Wrappers.lambdaQuery();
        lambdaReply.eq(ReplyEntity::getSourceAnswerId, (Object)billId);
        ReplyEntity replyEntity = (ReplyEntity)((Object)this.replyService.getOne((Wrapper)lambdaReply));
        if (replyEntity.getReplyStatus() == 2) {
            return CommonResponse.error((String)"\u4e0b\u6e38\u5df2\u56de\u590d,\u4e0d\u80fd\u64a4\u56de!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaQueryWrapper lambdaReply = Wrappers.lambdaQuery();
        lambdaReply.eq(ReplyEntity::getSourceAnswerId, (Object)billId);
        this.replyService.remove((Wrapper)lambdaReply);
        return CommonResponse.success();
    }
}

