/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procurement.plan.bean.CatalogCategoryEntity;
import com.ejianc.business.procurement.plan.bean.CatalogItemEntity;
import com.ejianc.business.procurement.plan.mapper.CatalogCategoryMapper;
import com.ejianc.business.procurement.plan.service.ICatalogCategoryService;
import com.ejianc.business.procurement.plan.service.ICatalogItemService;
import com.ejianc.business.procurement.plan.vo.CatalogCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="catalogCategoryService")
public class CatalogCategoryServiceImpl
extends BaseServiceImpl<CatalogCategoryMapper, CatalogCategoryEntity>
implements ICatalogCategoryService {
    @Autowired
    private ICatalogItemService itemService;

    @Override
    public void enableOrDisable(CatalogCategoryVO categoryVO) {
        Long categoryVOId = categoryVO.getId();
        Integer enabled = categoryVO.getEnabled();
        CatalogCategoryEntity categoryEntity = (CatalogCategoryEntity)((Object)this.getById(categoryVOId));
        if (categoryEntity != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.like(CatalogCategoryEntity::getInnerCode, (Object)categoryEntity.getInnerCode());
            queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            List categoryEntities = this.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)categoryEntities)) {
                List categoryIds = categoryEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.in(CatalogItemEntity::getCategoryId, categoryIds);
                updateWrapper.set(CatalogItemEntity::getEnabled, (Object)enabled);
                this.itemService.update((Wrapper)updateWrapper);
                LambdaUpdateWrapper updater = new LambdaUpdateWrapper();
                updater.in(BaseEntity::getId, categoryIds);
                updater.set(CatalogCategoryEntity::getEnabled, (Object)enabled);
                this.update((Wrapper)updater);
            }
        }
    }
}

