package com.ejianc.business.procurement.plan.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.procurement.plan.bean.PlanAllicateDetailEntity;
/**
 * 采购计划分配
 * 
 * @author generator
 * 
 */
 @TableName("ejc_procurement_plan_allicate")
public class PlanAllicateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="ctrl_tax_mny")
    private BigDecimal ctrlTaxMny; // 控制含税总额
    @TableField(value="pre_tax_mny")
    private BigDecimal preTaxMny; // 预估含税总额
    @TableField(value="bid_tax_mny")
    private BigDecimal bidTaxMny; // 投标含税总额
    @TableField(value="make_date")
    private Date makeDate; // 编制日期
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_name")
    private String orgName; // 采购实施单位名称
    @TableField(value="org_code")
    private String orgCode; // 采购实施单位编码
    @TableField(value="all_org_name")
    private String allOrgName; // 所属组织(所属单位-项目经理部)
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="business_type")
    private String businessType; // 业务类别1-工程，2-货物，3-服务
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="name")
    private String name; // 计划分配名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="permission_type")
    private Integer permissionType; // 实施权限 1-一级集采，2-二级集采，3-所属单位，4-项目经理部
    @TableField(value="abnormal_status")
    private Integer abnormalStatus; // 计划异常状态 1-正常，2-取消采购，3-暂停采购
    @TableField(value="org_id")
    private Long orgId; // 采购实施单位Id
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="planAllicateDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<PlanAllicateDetailEntity> planAllicateDetailList = new ArrayList<>(); // 采购计划分配-明细
    

    public BigDecimal getCtrlTaxMny() {
        return ctrlTaxMny;
    }

    public void setCtrlTaxMny(BigDecimal ctrlTaxMny) {
        this.ctrlTaxMny = ctrlTaxMny;
    }
    public BigDecimal getPreTaxMny() {
        return preTaxMny;
    }

    public void setPreTaxMny(BigDecimal preTaxMny) {
        this.preTaxMny = preTaxMny;
    }
    public BigDecimal getBidTaxMny() {
        return bidTaxMny;
    }

    public void setBidTaxMny(BigDecimal bidTaxMny) {
        this.bidTaxMny = bidTaxMny;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getAllOrgName() {
        return allOrgName;
    }

    public void setAllOrgName(String allOrgName) {
        this.allOrgName = allOrgName;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getPermissionType() {
        return permissionType;
    }

    public void setPermissionType(Integer permissionType) {
        this.permissionType = permissionType;
    }
    public Integer getAbnormalStatus() {
        return abnormalStatus;
    }

    public void setAbnormalStatus(Integer abnormalStatus) {
        this.abnormalStatus = abnormalStatus;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    
    public List<PlanAllicateDetailEntity> getPlanAllicateDetailList() {
        return planAllicateDetailList;
    }

    public void setPlanAllicateDetailList(List<PlanAllicateDetailEntity> planAllicateDetailList) {
        this.planAllicateDetailList = planAllicateDetailList;
    }
}
