package com.ejianc.business.procurement.plan.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 拟不招标事项申请表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_procurement_un_tendering_matter")
public class UnTenderMatterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="matter_tax_mny")
    private BigDecimal matterTaxMny; // 各标的预算
    @TableField(value="pre_tax_mny")
    private BigDecimal preTaxMny; // 预计合同总金额
    @TableField(value="make_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级编码
    @TableField(value="all_org_name")
    private String allOrgName; // 所属组织(所属单位-项目经理部)
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="tender_type")
    private String tenderType; // 招标执行程序1-法定必招项目，2-一般招标项目
    @TableField(value="purchase_matter")
    private String purchaseMatter; // 采购标的
    @TableField(value="un_legal_bidding_name")
    private String unLegalBiddingName; // 拟邀请招标情形名称（法定必招）
    @TableField(value="person_name")
    private String personName; // 联系人名称
    @TableField(value="person_phone")
    private String personPhone; // 联系电话
    @TableField(value="plan_name")
    private String planName; // 采购计划名称
    @TableField(value="background_memo")
    private String backgroundMemo; // 采购项目背景
    @TableField(value="cause_memo")
    private String causeMemo; // 拟不进行招标原因
    @TableField(value="other_memo")
    private String otherMemo; // 其他需要说明的情况
    @TableField(value="un_ordinary_bidding_name")
    private String unOrdinaryBiddingName; // 拟邀请招标情形名称(一般招标）
    @TableField(value="purchase_memo")
    private String purchaseMemo; // 拟采用的采购方式
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="org_id")
    private Long orgId; // 项目部Id
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级Id
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="un_legal_bidding")
    private Long unLegalBidding; // 拟邀请招标情形（法定必招）
    @TableField(value="person_id")
    private Long personId; // 联系人id
    @TableField(value="plan_id")
    private Long planId; // 采购计划单号
    @TableField(value="un_ordinary_bidding")
    private Long unOrdinaryBidding; // 拟邀请招标情形(一般招标）
    @TableField(value="business_type")
    private String businessType; // 标的物类别1-工程，2-货物，3-服务

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public BigDecimal getMatterTaxMny() {
        return matterTaxMny;
    }

    public void setMatterTaxMny(BigDecimal matterTaxMny) {
        this.matterTaxMny = matterTaxMny;
    }
    public BigDecimal getPreTaxMny() {
        return preTaxMny;
    }

    public void setPreTaxMny(BigDecimal preTaxMny) {
        this.preTaxMny = preTaxMny;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getAllOrgName() {
        return allOrgName;
    }

    public void setAllOrgName(String allOrgName) {
        this.allOrgName = allOrgName;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getTenderType() {
        return tenderType;
    }

    public void setTenderType(String tenderType) {
        this.tenderType = tenderType;
    }
    public String getPurchaseMatter() {
        return purchaseMatter;
    }

    public void setPurchaseMatter(String purchaseMatter) {
        this.purchaseMatter = purchaseMatter;
    }
    public String getUnLegalBiddingName() {
        return unLegalBiddingName;
    }

    public void setUnLegalBiddingName(String unLegalBiddingName) {
        this.unLegalBiddingName = unLegalBiddingName;
    }
    public String getPersonName() {
        return personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }
    public String getPersonPhone() {
        return personPhone;
    }

    public void setPersonPhone(String personPhone) {
        this.personPhone = personPhone;
    }
    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }
    public String getBackgroundMemo() {
        return backgroundMemo;
    }

    public void setBackgroundMemo(String backgroundMemo) {
        this.backgroundMemo = backgroundMemo;
    }
    public String getCauseMemo() {
        return causeMemo;
    }

    public void setCauseMemo(String causeMemo) {
        this.causeMemo = causeMemo;
    }
    public String getOtherMemo() {
        return otherMemo;
    }

    public void setOtherMemo(String otherMemo) {
        this.otherMemo = otherMemo;
    }
    public String getUnOrdinaryBiddingName() {
        return unOrdinaryBiddingName;
    }

    public void setUnOrdinaryBiddingName(String unOrdinaryBiddingName) {
        this.unOrdinaryBiddingName = unOrdinaryBiddingName;
    }
    public String getPurchaseMemo() {
        return purchaseMemo;
    }

    public void setPurchaseMemo(String purchaseMemo) {
        this.purchaseMemo = purchaseMemo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Long getUnLegalBidding() {
        return unLegalBidding;
    }

    public void setUnLegalBidding(Long unLegalBidding) {
        this.unLegalBidding = unLegalBidding;
    }
    public Long getPersonId() {
        return personId;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }
    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    public Long getUnOrdinaryBidding() {
        return unOrdinaryBidding;
    }

    public void setUnOrdinaryBidding(Long unOrdinaryBidding) {
        this.unOrdinaryBidding = unOrdinaryBidding;
    }
    
}
