package com.ejianc.business.procurement.plan.service.impl;

import com.ejianc.business.procurement.plan.bean.ExecutePlanDetailEntity;
import com.ejianc.business.procurement.plan.bean.PlanAllicateDetailEntity;
import com.ejianc.business.procurement.plan.bean.PlanAllicateEntity;
import com.ejianc.business.procurement.plan.bean.PurchasePlanEntity;
import com.ejianc.business.procurement.plan.service.IExecutePlanDetailService;
import com.ejianc.business.procurement.plan.service.IPlanAllicateService;
import com.ejianc.business.procurement.plan.service.IPurchasePlanService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

@Service("planAllicate") 
public class PlanAllicateBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IPlanAllicateService service;
	@Autowired
	private IExecutePlanDetailService executePlanDetailService;
	@Autowired
	private IPurchasePlanService planService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *  按照清单，任一清单做了采购执行计划； 不允许撤回
	 *  按照采购计划：采购计划异常状态为 取消采购 和 暂停采购 ： 不允许撤回
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		PlanAllicateEntity entity = service.selectById(billId);
		if(ListUtil.isNotEmpty(entity.getPlanAllicateDetailList())){
			List<Long> ids = entity.getPlanAllicateDetailList().stream().map(BaseEntity::getId).collect(Collectors.toList());
			QueryParam queryWrapper = new QueryParam();
			queryWrapper.getParams().put("sourceId",new Parameter(QueryParam.IN,ids));
			List<ExecutePlanDetailEntity> detailList = executePlanDetailService.queryList(queryWrapper,false);
			for(ExecutePlanDetailEntity e : detailList){
				return CommonResponse.error("该分配单明细已做执行计划！不支持撤回！");
			}
			ids = entity.getPlanAllicateDetailList().stream().map(PlanAllicateDetailEntity::getPlanId).distinct().collect(Collectors.toList());
			queryWrapper = new QueryParam();
			queryWrapper.getParams().put("id",new Parameter(QueryParam.IN,ids));
			queryWrapper.getParams().put("abnormalStatus",new Parameter(QueryParam.IN,"2,3"));
			List<PurchasePlanEntity> planList = planService.queryList(queryWrapper,false);
			if(ListUtil.isNotEmpty(planList)){
				return CommonResponse.error("该分配单存在异常状态为【取消采购】 或者 【暂停采购】的采购计划！不支持撤回！");
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		PlanAllicateEntity entity = service.selectById(billId);
		if(ListUtil.isNotEmpty(entity.getPlanAllicateDetailList())){
			List<Long> ids = entity.getPlanAllicateDetailList().stream().map(BaseEntity::getId).collect(Collectors.toList());
			QueryParam queryWrapper = new QueryParam();
			queryWrapper.getParams().put("sourceId",new Parameter(QueryParam.IN,ids));
			List<ExecutePlanDetailEntity> detailList = executePlanDetailService.queryList(queryWrapper,false);
			for(ExecutePlanDetailEntity e : detailList){
				return CommonResponse.error("该分配单明细已做执行计划！不支持弃审！");
			}
			ids = entity.getPlanAllicateDetailList().stream().map(PlanAllicateDetailEntity::getPlanId).distinct().collect(Collectors.toList());
			queryWrapper = new QueryParam();
			queryWrapper.getParams().put("id",new Parameter(QueryParam.IN,ids));
			queryWrapper.getParams().put("abnormalStatus",new Parameter(QueryParam.IN,"2,3"));
			List<PurchasePlanEntity> planList = planService.queryList(queryWrapper,false);
			if(ListUtil.isNotEmpty(planList)){
				return CommonResponse.error("该分配单存在异常状态为【取消采购】 或者 【暂停采购】的采购计划！不支持弃审！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
