package com.ejianc.business.procurement.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.ejianc.business.procurement.plan.bean.AnswerDetailEntity;
import com.ejianc.business.procurement.plan.bean.AnswerEntity;
import com.ejianc.business.procurement.plan.bean.ReplyDetailEntity;
import com.ejianc.business.procurement.plan.bean.ReplyEntity;
import com.ejianc.business.procurement.plan.service.IAnswerDetailService;
import com.ejianc.business.procurement.plan.service.IAnswerService;
import com.ejianc.business.procurement.plan.service.IReplyService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("reply") 
public class ReplyBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IReplyService replyService;
    @Autowired
    private IAnswerService answerService;
    @Autowired
    private IAnswerDetailService answerDetailService;

	private final Logger logger = LoggerFactory.getLogger(getClass());


	@Autowired
	private IAttachmentApi attachmentApi;

	private static final String HW_BILL_CODE = "BT202512000002";//货物

	private static final String REPLY_HW_BILL_CODE = "BT202512000010";//待回复货物


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//
		ReplyEntity replyEntity = replyService.selectById(billId);
		replyEntity.setReplyStatus(2);
		replyService.updateById(replyEntity);

		List<ReplyDetailEntity> replyDetailList = replyEntity.getReplyDetailList();
		Map<Long, ReplyDetailEntity> replyDetailEntityMap = new HashMap<>();
		if (CollectionUtils.isNotEmpty(replyDetailList)){
			replyDetailEntityMap = replyDetailList.stream().collect(Collectors.toMap(ReplyDetailEntity::getSourceDetailId, Function.identity()));
		}


		//查询出答疑清单子表数据
		AnswerEntity answerEntity = answerService.selectById(replyEntity.getSourceAnswerId());
		List<AnswerDetailEntity> answerDetailList = answerEntity.getAnswerDetailList();

		if (CollectionUtils.isNotEmpty(answerDetailList)){
			for (AnswerDetailEntity answerDetailEntity : answerDetailList){
				if (replyDetailEntityMap.containsKey(answerDetailEntity.getId())){
					ReplyDetailEntity replyDetailEntity = replyDetailEntityMap.get(answerDetailEntity.getId());
					answerDetailEntity.setReplyId(replyDetailEntity.getReplyId());
					answerDetailEntity.setReplyName(replyDetailEntity.getReplyName());
					answerDetailEntity.setContent(replyDetailEntity.getContent());
				}
			}


		}

		//回写答疑清单子表信息
		answerDetailService.updateBatchById(answerDetailList);

		//回写答疑清单附件信息

		if (CollectionUtils.isNotEmpty(replyDetailList)){
			for (ReplyDetailEntity replyDetailEntity : replyDetailList){
				CommonResponse<String> responseCopy = attachmentApi.copyFilesFromSourceBillToTargetBill(
						replyDetailEntity.getId().toString(),
						REPLY_HW_BILL_CODE,
						"replyFile",
						replyDetailEntity.getSourceDetailId().toString(),
						HW_BILL_CODE,
						"answerFile"
				);
				if (!responseCopy.isSuccess()) {
					throw new BusinessException("招标立项向招标文件附件复制失败:" + responseCopy.getMsg());
				}
			}

		}



		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//清空答疑清单的子表回复信息
		ReplyEntity replyEntity = replyService.selectById(billId);
		replyEntity.setReplyStatus(1);
		replyService.updateById(replyEntity);

//		List<ReplyDetailEntity> replyDetailList = replyEntity.getReplyDetailList();
//		Map<Long, ReplyDetailEntity> replyDetailEntityMap = new HashMap<>();
//		if (CollectionUtils.isNotEmpty(replyDetailList)){
//			replyDetailEntityMap = replyDetailList.stream().collect(Collectors.toMap(ReplyDetailEntity::getSourceDetailId, Function.identity()));
//		}


		//查询出答疑清单子表数据
		AnswerEntity answerEntity = answerService.selectById(replyEntity.getSourceAnswerId());
		List<AnswerDetailEntity> answerDetailList = answerEntity.getAnswerDetailList();

		if (CollectionUtils.isNotEmpty(answerDetailList)){
			for (AnswerDetailEntity answerDetailEntity : answerDetailList){
				answerDetailEntity.setReplyId(null);
				answerDetailEntity.setReplyName(null);
				answerDetailEntity.setContent(null);
			}
			answerDetailService.updateBatchById(answerDetailList);
			//删除回复附件信息

			List<Long> attachIds = answerDetailList.stream().map(AnswerDetailEntity::getId).collect(Collectors.toList());
			Map<String, List<Long>> map = new HashMap<>();
			map.put("sourceIds",attachIds);
			logger.info("附件请求信息 --"+ JSONObject.toJSONString(attachIds));
			JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
			CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
			List<AttachmentVO> attachmentVOList = listCommonResponse.getData();
			if (CollectionUtils.isNotEmpty(attachmentVOList)) {
				logger.info("开始删除附件信息-----");
				String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
				CommonResponse<String> deleteResponse = attachmentApi.delete(ids);
				logger.info("删除文件结束，删除结果：{}", deleteResponse.getData());
			}
		}
		return CommonResponse.success();
	}

}
