package com.ejianc.business.procurement.plan.service.impl;

import com.ejianc.business.procurement.plan.bean.*;
import com.ejianc.business.procurement.plan.service.*;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

@Service("planException") 
public class PlanExceptionBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IPlanExceptionService service;
	@Autowired
	private IPurchasePlanService planService;
	@Autowired
	private IPlanAllicateService allocateService;
	@Autowired
	private IPlanAllicateDetailService allocateDetailService;
	@Autowired
	private IExecutePlanService executePlanService;
	@Autowired
	private IExecutePlanDetailService executePlanDetailService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.error("不支持撤回！");
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *  2取消采购: 更新 采购计划 和 终止的 执行计划 以 及 主表采购计划下所有的计划分配，设置异常状态为取消采购;----释放终止的执行计划清单里面其他采购计划的清单执行数量; 更新采购计划下所有的计划分配，设置异常状态为取消采购;
	 *  4重新采购: 更新 终止的执行计划的 计划异常状态为 重新采购;  不影响授权、分配，需要释放执行计划数量
	 *  3暂停采购: 更新 采购计划 和 采购计划下所有的执行计划 及 执行计划对应的执行计划分配 异常状态为暂停采购；更新采购计划下所有的计划分配，设置异常状态为取消采购;
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		PlanExceptionEntity planExceptionEntity = service.selectById(billId);
		if(planExceptionEntity.getAbnormalStatus() == 2){//取消采购
			//1、更新采购计划状态为取消采购
			PurchasePlanEntity purchasePlanEntity = planService.selectById(planExceptionEntity.getPlanId());
			purchasePlanEntity.setAbnormalStatus(2);//采购计划状态取消采购
			planService.saveOrUpdate(purchasePlanEntity, false);
			//2、更新终止的 执行计划 状态为取消采购
			if(ListUtil.isNotEmpty(planExceptionEntity.getPlanExceptionDetailList())){
				List<Long> executePlanIdList = planExceptionEntity.getPlanExceptionDetailList().stream().filter(PlanExceptionDetailEntity::getClosed).map(PlanExceptionDetailEntity::getSourceId).distinct().collect(Collectors.toList());
				if(ListUtil.isNotEmpty(executePlanIdList)){
					QueryParam param = new QueryParam();
					param.getParams().put("id", new Parameter(QueryParam.IN,executePlanIdList));
					List<ExecutePlanEntity> executePlanList = executePlanService.queryList(param,false);
					for(ExecutePlanEntity executePlanEntity : executePlanList){
						executePlanEntity.setAbnormalStatus(2);
					}
					executePlanService.saveOrUpdateBatch(executePlanList);
					//3、释放终止的执行计划清单里面 其他采购计划的 清单 执行数量
					param = new QueryParam();
					param.getParams().put("pid", new Parameter(QueryParam.IN,executePlanIdList));
					param.getParams().put("planId", new Parameter(QueryParam.NE,planExceptionEntity.getPlanId()));
					List<ExecutePlanDetailEntity> executePlanDetailList = executePlanDetailService.queryList(param,false);
					if(ListUtil.isNotEmpty(executePlanDetailList)){
						for(ExecutePlanDetailEntity executePlanDetailEntity : executePlanDetailList){
							param = new QueryParam();
							param.getParams().put("sourceId", new Parameter(QueryParam.EQ,executePlanDetailEntity.getSourceId()));
							param.getParams().put("id", new Parameter(QueryParam.NE,executePlanDetailEntity.getId()));
							List<ExecutePlanDetailEntity> executePlanDetail = executePlanDetailService.queryList(param,false);
							BigDecimal executeNum = BigDecimal.ZERO;
							if(CollectionUtils.isNotEmpty(executePlanDetail)){
								executeNum = executePlanDetail.stream().map(ExecutePlanDetailEntity::getExecuteNum).reduce(BigDecimal.ZERO, BigDecimal::add);
							}
							PlanAllicateDetailEntity detailEntity = allocateDetailService.selectById(executePlanDetailEntity.getSourceId());
							detailEntity.setExecutedNum(executeNum);
							executePlanDetailEntity.setExecuteNum(BigDecimal.ZERO);
							executePlanDetailService.saveOrUpdate(executePlanDetailEntity, false);
							allocateDetailService.saveOrUpdate(detailEntity, false);
						}
					}
				}

			}
			//4、更新采购计划下所有的计划分配，设置异常状态为取消采购
			QueryParam param = new QueryParam();
			param.getParams().put("planId", new Parameter(QueryParam.EQ,planExceptionEntity.getPlanId()));
			List<PlanAllicateDetailEntity> allocateDetailEntities = allocateDetailService.queryList(param,false);
			if(ListUtil.isNotEmpty(allocateDetailEntities)){
				param = new QueryParam();
				param.getParams().put("id", new Parameter(QueryParam.IN,allocateDetailEntities.stream().map(PlanAllicateDetailEntity::getPid).collect(Collectors.toList())));
				List<PlanAllicateEntity> allocateList = allocateService.queryList(param,false);
				for(PlanAllicateEntity allocateEntity : allocateList){
					allocateEntity.setAbnormalStatus(2);
				}
				allocateService.saveOrUpdateBatch(allocateList);
			}
		}else if(planExceptionEntity.getAbnormalStatus() == 4){//重新采购
			//1、更新终止的执行计划 状态为重新采购
			if(ListUtil.isNotEmpty(planExceptionEntity.getPlanExceptionDetailList())){
				List<Long> executePlanIdList = planExceptionEntity.getPlanExceptionDetailList().stream().filter(PlanExceptionDetailEntity::getClosed).map(PlanExceptionDetailEntity::getSourceId).distinct().collect(Collectors.toList());
				if(ListUtil.isNotEmpty(executePlanIdList)){
					QueryParam param = new QueryParam();
					param.getParams().put("id", new Parameter(QueryParam.IN,executePlanIdList));
					List<ExecutePlanEntity> executePlanList = executePlanService.queryList(param,false);
					for(ExecutePlanEntity executePlanEntity : executePlanList){
						executePlanEntity.setAbnormalStatus(4);
					}
					executePlanService.saveOrUpdateBatch(executePlanList);
					//2、释放终止的执行计划清单 执行数量
					param = new QueryParam();
					param.getParams().put("pid", new Parameter(QueryParam.IN,executePlanIdList));
					List<ExecutePlanDetailEntity> executePlanDetailList = executePlanDetailService.queryList(param,false);
					if(ListUtil.isNotEmpty(executePlanDetailList)){
						for(ExecutePlanDetailEntity executePlanDetailEntity : executePlanDetailList){
							param = new QueryParam();
							param.getParams().put("sourceId", new Parameter(QueryParam.EQ,executePlanDetailEntity.getSourceId()));
							param.getParams().put("id", new Parameter(QueryParam.NE,executePlanDetailEntity.getId()));
							List<ExecutePlanDetailEntity> executePlanDetail = executePlanDetailService.queryList(param,false);
							BigDecimal executeNum = BigDecimal.ZERO;
							if(CollectionUtils.isNotEmpty(executePlanDetail)){
								executeNum = executePlanDetail.stream().map(ExecutePlanDetailEntity::getExecuteNum).reduce(BigDecimal.ZERO, BigDecimal::add);
							}
							PlanAllicateDetailEntity detailEntity = allocateDetailService.selectById(executePlanDetailEntity.getSourceId());
							detailEntity.setExecutedNum(executeNum);
							executePlanDetailEntity.setExecuteNum(BigDecimal.ZERO);
							executePlanDetailService.saveOrUpdate(executePlanDetailEntity, false);
							allocateDetailService.saveOrUpdate(detailEntity, false);
						}
					}
				}
			}
		}else if(planExceptionEntity.getAbnormalStatus() == 3){//暂停采购
			//1、更新采购计划状态 为暂停采购
			PurchasePlanEntity purchasePlanEntity = planService.selectById(planExceptionEntity.getPlanId());
			purchasePlanEntity.setAbnormalStatus(3);//采购计划状态取消采购
			planService.saveOrUpdate(purchasePlanEntity, false);
			//2、更新 采购计划所有执行计划清单 为暂停采购
			QueryParam param = new QueryParam();
			param.getParams().put("planId", new Parameter(QueryParam.EQ,planExceptionEntity.getPlanId()));
			List<ExecutePlanDetailEntity> executePlanDetailList = executePlanDetailService.queryList(param,false);
			if(ListUtil.isNotEmpty(executePlanDetailList)){
				param = new QueryParam();
				param.getParams().put("id", new Parameter(QueryParam.IN,executePlanDetailList.stream().map(ExecutePlanDetailEntity::getPid).collect(Collectors.toList())));
				List<ExecutePlanEntity> executePlanList = executePlanService.queryList(param,false);
				for(ExecutePlanEntity executePlanEntity : executePlanList){
					executePlanEntity.setAbnormalStatus(3);
				}
				executePlanService.saveOrUpdateBatch(executePlanList);
			}
			//3、更新 采购计划所有执行分配清单 为暂停采购
			List<PlanAllicateDetailEntity> allocateDetailList = allocateDetailService.queryList(param,false);
			if(ListUtil.isNotEmpty(allocateDetailList)){
				param = new QueryParam();
				param.getParams().put("id", new Parameter(QueryParam.IN,allocateDetailList.stream().map(PlanAllicateDetailEntity::getPid).collect(Collectors.toList())));
				List<PlanAllicateEntity> allocateList = allocateService.queryList(param,false);
				for(PlanAllicateEntity allocateEntity : allocateList){
					allocateEntity.setAbnormalStatus(3);
				}
				allocateService.saveOrUpdateBatch(allocateList);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("不支持弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
