package com.ejianc.business.procurement.plan.controller;

import java.io.Serializable;

import com.ejianc.business.procurement.plan.bean.*;
import com.ejianc.business.procurement.plan.service.IExecutePlanDetailService;
import com.ejianc.business.procurement.plan.service.IPlanAllicateDetailService;
import com.ejianc.business.procurement.plan.service.IPlanAllicateService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.procurement.plan.service.IExecutePlanService;
import com.ejianc.business.procurement.plan.vo.ExecutePlanVO;

/**
 * 采购执行计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("executePlan")
public class ExecutePlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;


    private static final String HW_BILL_CODE = "HW_EXE_CODE";
    private static final String GC_BILL_CODE = "GC_EXE_CODE";
    private static final String FW_BILL_CODE = "FW_EXE_CODE";

    @Autowired
    private IExecutePlanService service;
    @Autowired
    private IExecutePlanDetailService executePlanDetailService;

    @Autowired
    private IPlanAllicateService allocateService;
    @Autowired
    private IPlanAllicateDetailService allocateDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExecutePlanVO> saveOrUpdate(@RequestBody ExecutePlanVO saveOrUpdateVO) {
    	ExecutePlanEntity entity = BeanMapper.map(saveOrUpdateVO, ExecutePlanEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            String billcode = "";
            if("1".equals(saveOrUpdateVO.getBusinessType())){
                billcode = GC_BILL_CODE;
            }else if("2".equals(saveOrUpdateVO.getBusinessType())){
                billcode = HW_BILL_CODE;
            }else if("3".equals(saveOrUpdateVO.getBusinessType())){
                billcode = FW_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build(billcode,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //修改分配子表已执行数量
        if(CollectionUtils.isNotEmpty(saveOrUpdateVO.getExecutePlanDetailList())){
            QueryParam param = new QueryParam();
            saveOrUpdateVO.getExecutePlanDetailList().forEach(e->{
                /** 实时查出非本单据数据相加，作为已执行数据 */
                param.getParams().put("sourceId",Parameter.getEqInstance(e.getSourceId()));
                param.getParams().put("id",new Parameter(QueryParam.NE,e.getId()));
                List<ExecutePlanDetailEntity> list = executePlanDetailService.queryList(param,false);
                BigDecimal executeNum = BigDecimal.ZERO;
                if(CollectionUtils.isNotEmpty(list)){
                    executeNum = list.stream().map(ExecutePlanDetailEntity::getExecuteNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                PlanAllicateDetailEntity detailEntity = allocateDetailService.selectById(e.getSourceId());
                if("del".equals(e.getRowState())){
                    detailEntity.setExecutedNum(executeNum);
                }else{
                    /** 判断本次执行量是否大于可执行量 ，大于则不允许执行 */
                    if (detailEntity.getNum().compareTo(e.getExecuteNum().add(executeNum)) < 0) {
                        throw new BusinessException("本次执行数量["+e.getExecuteNum()+"]不能大于实际剩余可执行数量["+detailEntity.getNum().subtract(executeNum).setScale(2,RoundingMode.HALF_UP)+"]");
                    }
                    detailEntity.setExecutedNum(e.getExecuteNum().add(executeNum));
                }
                allocateDetailService.saveOrUpdate(detailEntity,false);
            });
        }
    	service.saveOrUpdate(entity, false);
    	ExecutePlanVO vo = BeanMapper.map(entity, ExecutePlanVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExecutePlanVO> queryDetail(Long id) {
    	ExecutePlanEntity entity = service.selectById(id);
    	ExecutePlanVO vo = BeanMapper.map(entity, ExecutePlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExecutePlanVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ExecutePlanVO vo : vos) {
                ExecutePlanEntity entity = service.selectById(vo.getId());
                if(CollectionUtils.isNotEmpty(entity.getExecutePlanDetailList())){
                    QueryParam param = new QueryParam();
                    entity.getExecutePlanDetailList().forEach(e->{
                        PlanAllicateDetailEntity detailEntity = allocateDetailService.selectById(e.getSourceId());
                        /** 将执行数量还回去 释放被占用资源 */
                        param.getParams().put("sourceId",Parameter.getEqInstance(e.getSourceId()));
                        param.getParams().put("id",new Parameter(QueryParam.NE,e.getId()));
                        List<ExecutePlanDetailEntity> list = executePlanDetailService.queryList(param,false);
                        BigDecimal executeNum = BigDecimal.ZERO;
                        if(CollectionUtils.isNotEmpty(list)){
                            executeNum = list.stream().map(ExecutePlanDetailEntity::getExecuteNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        }
                        detailEntity.setExecutedNum(executeNum);
                        allocateDetailService.saveOrUpdate(detailEntity,false);
                    });
                }

            }
        }
        service.removeByIds(vos.stream().map(ExecutePlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExecutePlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("allOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("planObject");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ExecutePlanEntity> page = service.queryPage(param,false);
        IPage<ExecutePlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExecutePlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ExecutePlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ExecutePlan-export.xlsx", beans, response);
    }

    /**
     * @Description getExecutePlanDataByPlanId 获取执行计划数据根据采购计划Id
     * @Return void
     */
    @RequestMapping(value = "/getExecutePlanDataByPlanId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ExecutePlanVO>> getExecutePlanDataByPlanId(@RequestParam Long planId) {
        QueryParam param = new QueryParam();
        param.getParams().put("planId", new Parameter(QueryParam.EQ, planId));
        List<ExecutePlanVO> result = new ArrayList<>();
        List<ExecutePlanDetailEntity> detailEntities = executePlanDetailService.queryList(param,false);
        if (CollectionUtils.isNotEmpty(detailEntities)) {
            param = new QueryParam();
            /** 采购计划已生效且是正常状态的执行计划 */
            param.getParams().put("abnormalStatus", new Parameter(QueryParam.EQ, 1));
            param.getParams().put("id", new Parameter(QueryParam.IN, detailEntities.stream().map(ExecutePlanDetailEntity::getPid).collect(Collectors.toList())));
            List<ExecutePlanEntity> executePlanEntities = service.queryList(param,false);
            result = BeanMapper.mapList(executePlanEntities, ExecutePlanVO.class);
        }
        return CommonResponse.success("查询参照数据成功！",result);
     }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refExecutePlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExecutePlanVO>> refExecutePlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("abnormalStatus", new Parameter(QueryParam.EQ, 1));// 计划异常状态 1-正常，2-取消采购，3-暂停采购，4-重新采购
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ExecutePlanEntity> page = service.queryPage(param,false);
        IPage<ExecutePlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExecutePlanVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
