package com.ejianc.business.procurement.plan.service.impl;

import com.ejianc.business.procurement.plan.bean.YearBudgetDetailEntity;
import com.ejianc.business.procurement.plan.service.IYearBudgetDetailService;
import com.ejianc.business.procurement.plan.vo.YearBudgetDetailVO;
import com.ejianc.business.procurement.plan.vo.YearBudgetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.procurement.plan.mapper.YearBudgetMapper;
import com.ejianc.business.procurement.plan.bean.YearBudgetEntity;
import com.ejianc.business.procurement.plan.service.IYearBudgetService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 年度预算
 * 
 * @author generator
 * 
 */
@Service("yearBudgetService")
public class YearBudgetServiceImpl extends BaseServiceImpl<YearBudgetMapper, YearBudgetEntity> implements IYearBudgetService{
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "YEAR_BUDGET_CODE";//此处需要根据实际修改
    @Autowired
    private IYearBudgetDetailService detailService;

    @Override
    public YearBudgetVO insertOrUpdate(YearBudgetVO vo) {
        if (StringUtils.isBlank(vo.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                vo.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        YearBudgetEntity entity = BeanMapper.map(vo, YearBudgetEntity.class);
        boolean b = this.saveOrUpdateNoES(entity);
        List<YearBudgetDetailEntity> detailEntityList = entity.getYearBudgetDetailList();
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (YearBudgetDetailEntity cdEntity : detailEntityList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (YearBudgetDetailEntity cdEntity : detailEntityList) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            detailService.saveOrUpdateBatch(detailEntityList);
        }
        return queryDetail(entity.getId());
    }

    @Override
    public YearBudgetVO queryDetail(Long id) {
        YearBudgetEntity entity = super.selectById(id);
        YearBudgetVO vo = BeanMapper.map(entity, YearBudgetVO.class);
        List<YearBudgetDetailVO> detailList = vo.getYearBudgetDetailList();
        if (CollectionUtils.isNotEmpty(detailList)){
            for (YearBudgetDetailVO detailVo : detailList) {
                detailVo.setTid(vo.getId().toString());
                detailVo.setTpid(detailVo.getParentId() != null && detailVo.getParentId() > 0 ? detailVo.getParentId().toString() : "");
                detailVo.setRowState("edit");
            }
            List<Map> detailMapList = BeanMapper.mapList(detailList, Map.class);
            List<YearBudgetDetailVO> resultList = BeanMapper.mapList(detailMapList, YearBudgetDetailVO.class);
            vo.setYearBudgetDetailList(resultList);
        }
        return vo;

    }
}
