package com.ejianc.business.procurement.plan.service.impl;

import com.ejianc.business.procurement.plan.bean.*;
import com.ejianc.business.procurement.plan.service.*;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("unabnormal") 
public class UnabnormalBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IUnabnormalService service;
	@Autowired
	private IPurchasePlanService planService;
	@Autowired
	private IPlanAllicateService allocateService;
	@Autowired
	private IPlanAllicateDetailService allocateDetailService;
	@Autowired
	private IExecutePlanService executePlanService;
	@Autowired
	private IExecutePlanDetailService executePlanDetailService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		UnabnormalEntity entity = service.selectById(billId);
		PurchasePlanEntity planEntity = planService.selectById(entity.getPlanId());
		//1,修改采购计划为正常
		planEntity.setAbnormalStatus(1);
		planService.saveOrUpdate(planEntity,false);
		QueryParam param = new QueryParam();
		param.getParams().put("planId", new Parameter(QueryParam.EQ,entity.getPlanId()));
		//2,更新 采购计划所有执行分配清单 为正常采购
		List<PlanAllicateDetailEntity> allocateDetailList = allocateDetailService.queryList(param,false);
		if(ListUtil.isNotEmpty(allocateDetailList)){
			param = new QueryParam();
			param.getParams().put("id", new Parameter(QueryParam.IN,allocateDetailList.stream().map(PlanAllicateDetailEntity::getPid).collect(Collectors.toList())));
			List<PlanAllicateEntity> allocateList = allocateService.queryList(param,false);
			for(PlanAllicateEntity allocateEntity : allocateList){
				allocateEntity.setAbnormalStatus(1);
			}
			allocateService.saveOrUpdateBatch(allocateList);
		}
		param = new QueryParam();
		param.getParams().put("planId", new Parameter(QueryParam.EQ,entity.getPlanId()));
		//3,更新 采购计划所有执行计划清单 为暂停采购
		List<ExecutePlanDetailEntity> executePlanDetailList = executePlanDetailService.queryList(param,false);
		if(ListUtil.isNotEmpty(executePlanDetailList)){
			param = new QueryParam();
			param.getParams().put("id", new Parameter(QueryParam.IN,executePlanDetailList.stream().map(ExecutePlanDetailEntity::getPid).collect(Collectors.toList())));
			List<ExecutePlanEntity> executePlanList = executePlanService.queryList(param,false);
			for(ExecutePlanEntity executePlanEntity : executePlanList){
				executePlanEntity.setAbnormalStatus(1);
			}
			executePlanService.saveOrUpdateBatch(executePlanList);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("不支持弃审功能！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
