package com.ejianc.business.procurement.perform.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.procurement.perform.bean.PurchaseProjectSupplierEntity;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectBidEntity;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectDetailEntity;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectConfirmEntity;
import com.ejianc.business.procurement.perform.bean.PurchaseProjectAnswerEntity;
/**
 * 采购项目
 * 
 * @author generator
 * 
 */
 @TableName("ejc_procurement_purchase_project")
public class PurchaseProjectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="negotiation_method")
    private Integer negotiationMethod; // 谈判方式
    @TableField(value="nobid_method")
    private Integer nobidMethod; // 非招标交易方式
    @TableField(value="direct_flag")
    private Integer directFlag; // 直接采前公告结果标识
    @TableField(value="purchase_stage")
    private String purchaseStage; // 入围阶段：1-一阶段；2-二阶段
    @TableField(value="expert_flag")
    private Integer expertFlag; // 专家抽取记录标识
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bid_extract_num")
    private Integer bidExtractNum; // 招标-抽取专家人数
    @TableField(value="bid_appoint_num")
    private Integer bidAppointNum; // 招标-专家指定人数
    @TableField(value="bid_expert_num")
    private Integer bidExpertNum; // 招标-专家人数
    @TableField(value="bid_invite_num")
    private Integer bidInviteNum; // 招标-采购方代表人数
    @TableField(value="bid_jury_num")
    private Integer bidJuryNum; // 招标-评委委员会人数
    @TableField(value="recommend_way")
    private String recommendWay; // 推荐方式
    @TableField(value="audit_way")
    private String auditWay; // 评审方式
    @TableField(value="open_date")
    private Date openDate; // 计划开标时间
    @TableField(value="send_date")
    private Date sendDate; // 计划发标时间
    @TableField(value="extract_num")
    private Integer extractNum; // 抽取人数
    @TableField(value="appoint_num")
    private Integer appointNum; // 专家中指定人数
    @TableField(value="expert_num")
    private Integer expertNum; // 专家人数
    @TableField(value="invite_num")
    private Integer inviteNum; // 招标代表
    @TableField(value="jury_num")
    private Integer juryNum; // 评标委员会
    @TableField(value="review_date")
    private Date reviewDate; // 技术资格预审审查时间
    @TableField(value="notice_date")
    private Date noticeDate; // 计划发布资格预审公告时间
    @TableField(value="make_date")
    private Date makeDate; // 编制日期
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="purchase_strategy_code")
    private String purchaseStrategyCode; // 采购策划编号
    @TableField(value="purchase_strategy_id")
    private Long purchaseStrategyId; // 采购策划
    @TableField(value="bid_file_way")
    private Integer bidFileWay; // 招标文件生成方式
    @TableField(value="awarded")
    private Integer awarded; // 是否兼中
    @TableField(value="lot_num")
    private Integer lotNum; // 标段数量
    @TableField(value="lot_split")
    private Integer lotSplit; // 是否分标段
    @TableField(value="bid_method")
    private Integer bidMethod; // 评标办法
    @TableField(value="review_way")
    private Integer reviewWay; // 资格审查方式
    @TableField(value="team_name")
    private String teamName; // 采购小组名单
    @TableField(value="need_date")
    private Date needDate; // 采购标的需求时间
    @TableField(value="budget_tax_mny")
    private BigDecimal budgetTaxMny; // 采购预算
    @TableField(value="funding_situation")
    private Integer fundingSituation; // 采购资金落实情况
    @TableField(value="funding_source")
    private Integer fundingSource; // 资金来源
    @TableField(value="technical_condition")
    private Integer technicalCondition; // 技术条件
    @TableField(value="uninvite_tender_code")
    private String uninviteTenderCode; // 拟不招标审批单编号
    @TableField(value="uninvite_tender_id")
    private Long uninviteTenderId; // 拟不招标审批单
    @TableField(value="invite_tender_code")
    private String inviteTenderCode; // 拟邀请事项申报表编码
    @TableField(value="invite_tender_id")
    private Long inviteTenderId; // 拟邀请事项申报表
    @TableField(value="publish_type")
    private Integer publishType; // 采购公开程度：公开、邀请
    @TableField(value="process_type")
    private Integer processType; // 流程类型1平台全流程2平台半流程3全线下
    @TableField(value="platform_name")
    private String platformName; // 平台名称
    @TableField(value="info_platform")
    private Integer infoPlatform; // 采购信息发布平台：1线上(中色电子采购平台)2线上(其他)3线下
    @TableField(value="bidding_program")
    private Integer biddingProgram; // 招标执行程序：1-法定必招项目；2-一般必招项目
    @TableField(value="contract_effective")
    private Integer contractEffective; // 投资项目以获取批准或与业主承包合同已生效：1-是；0-否
    @TableField(value="purchase_deploy_place")
    private Integer purchaseDeployPlace; // 采购实施地点：1-境内；2-境外
    @TableField(value="plan_object")
    private String planObject; // 采购标的
    @TableField(value="name")
    private String name; // 采购项目名称
    @TableField(value="purchase_type")
    private String purchaseType; // 采购方式：1-带量；2-入围；3-框架
    @TableField(value="execute_plan_name")
    private String executePlanName; // 执行计划名称
    @TableField(value="execute_plan_code")
    private String executePlanCode; // 执行计划编码
    @TableField(value="execute_plan_id")
    private Long executePlanId; // 执行计划
    @TableField(value="business_type")
    private String businessType; // 业务类别1-工程，2-货物，3-服务
    @TableField(value="organize_shape")
    private Integer organizeShape; // 采购组织形式1-自主采购,2-委托采购
    @TableField(value="permission_type")
    private Integer permissionType; // 实施权限1-一级集采，2-二级集采，3-所属单位，4-项目经理部
    @TableField(value="perform_way")
    private String performWay; // 采购实施方式1-招标，2-非招标
    @TableField(value="org_code")
    private String orgCode; // 采购实施单位编码
    @TableField(value="org_name")
    private String orgName; // 采购实施单位名称
    @TableField(value="org_id")
    private Long orgId; // 采购实施单位Id
    @TableField(value="bill_code")
    private String billCode; // 采购项目编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="business_state")
    private Integer businessState; // 业务状态
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="purchaseProjectSupplierService")//此处有pid="xxx"，默认值pid="pid"
    private List<PurchaseProjectSupplierEntity> supplierList = new ArrayList<>(); // 采购项目-供应商寻源情况
    @TableField(exist=false)
    @SubEntity(serviceName="purchaseProjectBidService")//此处有pid="xxx"，默认值pid="pid"
    private List<PurchaseProjectBidEntity> bidList = new ArrayList<>(); // 采购项目-标段信息汇总
    @TableField(exist=false)
    @SubEntity(serviceName="purchaseProjectDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<PurchaseProjectDetailEntity> detailList = new ArrayList<>(); // 采购项目-标段清单明细
    @TableField(exist=false)
    @SubEntity(serviceName="purchaseProjectConfirmService")//此处有pid="xxx"，默认值pid="pid"
    private List<PurchaseProjectConfirmEntity> confirmList = new ArrayList<>(); // 采购项目-资格性、符合性审查内容
    @TableField(exist=false)
    @SubEntity(serviceName="purchaseProjectAnswerService")//此处有pid="xxx"，默认值pid="pid"
    private List<PurchaseProjectAnswerEntity> answerList = new ArrayList<>(); // 采购项目-应答文件评审清单

    public Integer getBusinessState() {
        return businessState;
    }

    public void setBusinessState(Integer businessState) {
        this.businessState = businessState;
    }

    public Integer getNegotiationMethod() {
        return negotiationMethod;
    }

    public void setNegotiationMethod(Integer negotiationMethod) {
        this.negotiationMethod = negotiationMethod;
    }

    public Integer getNobidMethod() {
        return nobidMethod;
    }

    public void setNobidMethod(Integer nobidMethod) {
        this.nobidMethod = nobidMethod;
    }

    public Integer getDirectFlag() {
        return directFlag;
    }

    public void setDirectFlag(Integer directFlag) {
        this.directFlag = directFlag;
    }

    public String getPurchaseStage() {
        return purchaseStage;
    }

    public void setPurchaseStage(String purchaseStage) {
        this.purchaseStage = purchaseStage;
    }

    public Integer getExpertFlag() {
        return expertFlag;
    }

    public void setExpertFlag(Integer expertFlag) {
        this.expertFlag = expertFlag;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBidExtractNum() {
        return bidExtractNum;
    }

    public void setBidExtractNum(Integer bidExtractNum) {
        this.bidExtractNum = bidExtractNum;
    }
    public Integer getBidAppointNum() {
        return bidAppointNum;
    }

    public void setBidAppointNum(Integer bidAppointNum) {
        this.bidAppointNum = bidAppointNum;
    }
    public Integer getBidExpertNum() {
        return bidExpertNum;
    }

    public void setBidExpertNum(Integer bidExpertNum) {
        this.bidExpertNum = bidExpertNum;
    }
    public Integer getBidInviteNum() {
        return bidInviteNum;
    }

    public void setBidInviteNum(Integer bidInviteNum) {
        this.bidInviteNum = bidInviteNum;
    }
    public Integer getBidJuryNum() {
        return bidJuryNum;
    }

    public void setBidJuryNum(Integer bidJuryNum) {
        this.bidJuryNum = bidJuryNum;
    }
    public String getRecommendWay() {
        return recommendWay;
    }

    public void setRecommendWay(String recommendWay) {
        this.recommendWay = recommendWay;
    }
    public String getAuditWay() {
        return auditWay;
    }

    public void setAuditWay(String auditWay) {
        this.auditWay = auditWay;
    }
    public Date getOpenDate() {
        return openDate;
    }

    public void setOpenDate(Date openDate) {
        this.openDate = openDate;
    }
    public Date getSendDate() {
        return sendDate;
    }

    public void setSendDate(Date sendDate) {
        this.sendDate = sendDate;
    }
    public Integer getExtractNum() {
        return extractNum;
    }

    public void setExtractNum(Integer extractNum) {
        this.extractNum = extractNum;
    }
    public Integer getAppointNum() {
        return appointNum;
    }

    public void setAppointNum(Integer appointNum) {
        this.appointNum = appointNum;
    }
    public Integer getExpertNum() {
        return expertNum;
    }

    public void setExpertNum(Integer expertNum) {
        this.expertNum = expertNum;
    }
    public Integer getInviteNum() {
        return inviteNum;
    }

    public void setInviteNum(Integer inviteNum) {
        this.inviteNum = inviteNum;
    }
    public Integer getJuryNum() {
        return juryNum;
    }

    public void setJuryNum(Integer juryNum) {
        this.juryNum = juryNum;
    }
    public Date getReviewDate() {
        return reviewDate;
    }

    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }
    public Date getNoticeDate() {
        return noticeDate;
    }

    public void setNoticeDate(Date noticeDate) {
        this.noticeDate = noticeDate;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getPurchaseStrategyCode() {
        return purchaseStrategyCode;
    }

    public void setPurchaseStrategyCode(String purchaseStrategyCode) {
        this.purchaseStrategyCode = purchaseStrategyCode;
    }
    public Long getPurchaseStrategyId() {
        return purchaseStrategyId;
    }

    public void setPurchaseStrategyId(Long purchaseStrategyId) {
        this.purchaseStrategyId = purchaseStrategyId;
    }
    public Integer getBidFileWay() {
        return bidFileWay;
    }

    public void setBidFileWay(Integer bidFileWay) {
        this.bidFileWay = bidFileWay;
    }
    public Integer getAwarded() {
        return awarded;
    }

    public void setAwarded(Integer awarded) {
        this.awarded = awarded;
    }
    public Integer getLotNum() {
        return lotNum;
    }

    public void setLotNum(Integer lotNum) {
        this.lotNum = lotNum;
    }
    public Integer getLotSplit() {
        return lotSplit;
    }

    public void setLotSplit(Integer lotSplit) {
        this.lotSplit = lotSplit;
    }
    public Integer getBidMethod() {
        return bidMethod;
    }

    public void setBidMethod(Integer bidMethod) {
        this.bidMethod = bidMethod;
    }
    public Integer getReviewWay() {
        return reviewWay;
    }

    public void setReviewWay(Integer reviewWay) {
        this.reviewWay = reviewWay;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    public Date getNeedDate() {
        return needDate;
    }

    public void setNeedDate(Date needDate) {
        this.needDate = needDate;
    }
    public BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    public void setBudgetTaxMny(BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    public Integer getFundingSituation() {
        return fundingSituation;
    }

    public void setFundingSituation(Integer fundingSituation) {
        this.fundingSituation = fundingSituation;
    }
    public Integer getFundingSource() {
        return fundingSource;
    }

    public void setFundingSource(Integer fundingSource) {
        this.fundingSource = fundingSource;
    }
    public Integer getTechnicalCondition() {
        return technicalCondition;
    }

    public void setTechnicalCondition(Integer technicalCondition) {
        this.technicalCondition = technicalCondition;
    }
    public String getUninviteTenderCode() {
        return uninviteTenderCode;
    }

    public void setUninviteTenderCode(String uninviteTenderCode) {
        this.uninviteTenderCode = uninviteTenderCode;
    }
    public Long getUninviteTenderId() {
        return uninviteTenderId;
    }

    public void setUninviteTenderId(Long uninviteTenderId) {
        this.uninviteTenderId = uninviteTenderId;
    }
    public String getInviteTenderCode() {
        return inviteTenderCode;
    }

    public void setInviteTenderCode(String inviteTenderCode) {
        this.inviteTenderCode = inviteTenderCode;
    }
    public Long getInviteTenderId() {
        return inviteTenderId;
    }

    public void setInviteTenderId(Long inviteTenderId) {
        this.inviteTenderId = inviteTenderId;
    }
    public Integer getPublishType() {
        return publishType;
    }

    public void setPublishType(Integer publishType) {
        this.publishType = publishType;
    }
    public Integer getProcessType() {
        return processType;
    }

    public void setProcessType(Integer processType) {
        this.processType = processType;
    }
    public String getPlatformName() {
        return platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }
    public Integer getInfoPlatform() {
        return infoPlatform;
    }

    public void setInfoPlatform(Integer infoPlatform) {
        this.infoPlatform = infoPlatform;
    }
    public Integer getBiddingProgram() {
        return biddingProgram;
    }

    public void setBiddingProgram(Integer biddingProgram) {
        this.biddingProgram = biddingProgram;
    }
    public Integer getContractEffective() {
        return contractEffective;
    }

    public void setContractEffective(Integer contractEffective) {
        this.contractEffective = contractEffective;
    }
    public Integer getPurchaseDeployPlace() {
        return purchaseDeployPlace;
    }

    public void setPurchaseDeployPlace(Integer purchaseDeployPlace) {
        this.purchaseDeployPlace = purchaseDeployPlace;
    }
    public String getPlanObject() {
        return planObject;
    }

    public void setPlanObject(String planObject) {
        this.planObject = planObject;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getExecutePlanName() {
        return executePlanName;
    }

    public void setExecutePlanName(String executePlanName) {
        this.executePlanName = executePlanName;
    }
    public String getExecutePlanCode() {
        return executePlanCode;
    }

    public void setExecutePlanCode(String executePlanCode) {
        this.executePlanCode = executePlanCode;
    }
    public Long getExecutePlanId() {
        return executePlanId;
    }

    public void setExecutePlanId(Long executePlanId) {
        this.executePlanId = executePlanId;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public Integer getOrganizeShape() {
        return organizeShape;
    }

    public void setOrganizeShape(Integer organizeShape) {
        this.organizeShape = organizeShape;
    }
    public Integer getPermissionType() {
        return permissionType;
    }

    public void setPermissionType(Integer permissionType) {
        this.permissionType = permissionType;
    }
    public String getPerformWay() {
        return performWay;
    }

    public void setPerformWay(String performWay) {
        this.performWay = performWay;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<PurchaseProjectSupplierEntity> getSupplierList() {
        return supplierList;
    }

    public void setSupplierList(List<PurchaseProjectSupplierEntity> supplierList) {
        this.supplierList = supplierList;
    }

    public List<PurchaseProjectBidEntity> getBidList() {
        return bidList;
    }

    public void setBidList(List<PurchaseProjectBidEntity> bidList) {
        this.bidList = bidList;
    }

    public List<PurchaseProjectDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PurchaseProjectDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<PurchaseProjectConfirmEntity> getConfirmList() {
        return confirmList;
    }

    public void setConfirmList(List<PurchaseProjectConfirmEntity> confirmList) {
        this.confirmList = confirmList;
    }

    public List<PurchaseProjectAnswerEntity> getAnswerList() {
        return answerList;
    }

    public void setAnswerList(List<PurchaseProjectAnswerEntity> answerList) {
        this.answerList = answerList;
    }
}
