/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.procurement.plan.bean.AnswerDetailEntity;
import com.ejianc.business.procurement.plan.bean.AnswerEntity;
import com.ejianc.business.procurement.plan.bean.ReplyDetailEntity;
import com.ejianc.business.procurement.plan.bean.ReplyEntity;
import com.ejianc.business.procurement.plan.service.IAnswerDetailService;
import com.ejianc.business.procurement.plan.service.IAnswerService;
import com.ejianc.business.procurement.plan.service.IReplyService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="reply")
public class ReplyBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IReplyService replyService;
    @Autowired
    private IAnswerService answerService;
    @Autowired
    private IAnswerDetailService answerDetailService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String HW_BILL_CODE = "BT202512000002";
    private static final String REPLY_HW_BILL_CODE = "BT202512000010";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReplyEntity replyEntity = (ReplyEntity)((Object)this.replyService.selectById(billId));
        replyEntity.setReplyStatus(2);
        this.replyService.updateById((Object)replyEntity);
        List<ReplyDetailEntity> replyDetailList = replyEntity.getReplyDetailList();
        Map<Object, Object> replyDetailEntityMap = new HashMap();
        if (CollectionUtils.isNotEmpty(replyDetailList)) {
            replyDetailEntityMap = replyDetailList.stream().collect(Collectors.toMap(ReplyDetailEntity::getSourceDetailId, Function.identity()));
        }
        AnswerEntity answerEntity = (AnswerEntity)((Object)this.answerService.selectById(replyEntity.getSourceAnswerId()));
        answerEntity.setReplyStatus(2);
        this.answerService.updateById((Object)answerEntity);
        List<AnswerDetailEntity> answerDetailList = answerEntity.getAnswerDetailList();
        if (CollectionUtils.isNotEmpty(answerDetailList)) {
            for (AnswerDetailEntity answerDetailEntity : answerDetailList) {
                if (!replyDetailEntityMap.containsKey(answerDetailEntity.getId())) continue;
                ReplyDetailEntity replyDetailEntity = (ReplyDetailEntity)((Object)replyDetailEntityMap.get(answerDetailEntity.getId()));
                answerDetailEntity.setReplyId(replyDetailEntity.getReplyId());
                answerDetailEntity.setReplyName(replyDetailEntity.getReplyName());
                answerDetailEntity.setContent(replyDetailEntity.getContent());
            }
        }
        this.answerDetailService.updateBatchById(answerDetailList);
        if (CollectionUtils.isNotEmpty(replyDetailList)) {
            for (ReplyDetailEntity replyDetailEntity : replyDetailList) {
                CommonResponse responseCopy = this.attachmentApi.copyFilesFromSourceBillToTargetBill(replyDetailEntity.getId().toString(), REPLY_HW_BILL_CODE, "replyFile", replyDetailEntity.getSourceDetailId().toString(), HW_BILL_CODE, "answerFile");
                if (responseCopy.isSuccess()) continue;
                throw new BusinessException("\u62db\u6807\u7acb\u9879\u5411\u62db\u6807\u6587\u4ef6\u9644\u4ef6\u590d\u5236\u5931\u8d25:" + responseCopy.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReplyEntity replyEntity = (ReplyEntity)((Object)this.replyService.selectById(billId));
        replyEntity.setReplyStatus(1);
        this.replyService.updateById((Object)replyEntity);
        AnswerEntity answerEntity = (AnswerEntity)((Object)this.answerService.selectById(replyEntity.getSourceAnswerId()));
        answerEntity.setReplyStatus(1);
        this.answerService.updateById((Object)answerEntity);
        List<AnswerDetailEntity> answerDetailList = answerEntity.getAnswerDetailList();
        if (CollectionUtils.isNotEmpty(answerDetailList)) {
            for (AnswerDetailEntity answerDetailEntity : answerDetailList) {
                answerDetailEntity.setReplyId(null);
                answerDetailEntity.setReplyName(null);
                answerDetailEntity.setContent(null);
            }
            this.answerDetailService.updateBatchById(answerDetailList);
            List attachIds = answerDetailList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            HashMap map = new HashMap();
            map.put("sourceIds", attachIds);
            this.logger.info("\u9644\u4ef6\u8bf7\u6c42\u4fe1\u606f --" + JSONObject.toJSONString(attachIds));
            JSONObject itemJSONObj = JSONObject.parseObject((String)JSON.toJSONString(map));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(itemJSONObj);
            List attachmentVOList = (List)listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)attachmentVOList)) {
                this.logger.info("\u5f00\u59cb\u5220\u9664\u9644\u4ef6\u4fe1\u606f-----");
                String ids = attachmentVOList.stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
                CommonResponse deleteResponse = this.attachmentApi.delete(ids);
                this.logger.info("\u5220\u9664\u6587\u4ef6\u7ed3\u675f\uff0c\u5220\u9664\u7ed3\u679c\uff1a{}", deleteResponse.getData());
            }
        }
        return CommonResponse.success();
    }
}

