/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procurement.perform.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procurement.perform.bean.FileAnswerEntity;
import com.ejianc.business.procurement.perform.service.IFileAnswerService;
import com.ejianc.business.procurement.perform.vo.FileAnswerVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"fileAnswer"})
public class FileAnswerController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IFileAnswerService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FileAnswerVO> saveOrUpdate(@RequestBody FileAnswerVO saveOrUpdateVO) {
        FileAnswerEntity entity = (FileAnswerEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, FileAnswerEntity.class));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", (Object)entity.getPid()));
        List list = this.service.queryList(queryParam, false);
        if (entity.getId() == null || entity.getId() == 0L) {
            if (entity.getPid() > 10L) {
                return CommonResponse.error((String)"\u4e0d\u652f\u6301\u65b0\u589e\u4e0b\u7ea7\uff01");
            }
            entity.setSecCode(entity.getPid() + "." + (list.size() + 1));
        }
        Integer score = 0;
        if (!list.isEmpty()) {
            for (FileAnswerEntity entity1 : list) {
                if (Objects.equals(entity1.getId(), entity.getPid())) continue;
                score = score + entity1.getScore();
            }
        }
        score = score + entity.getScore();
        FileAnswerEntity parent = (FileAnswerEntity)((Object)this.service.selectById(entity.getPid()));
        if (score > parent.getScore()) {
            parent.setScore(score);
        }
        this.service.saveOrUpdate((Object)entity, false);
        this.service.saveOrUpdate((Object)parent, false);
        FileAnswerVO vo = (FileAnswerVO)BeanMapper.map((Object)((Object)entity), FileAnswerVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FileAnswerVO> queryDetail(Long id) {
        FileAnswerEntity entity = (FileAnswerEntity)((Object)this.service.selectById(id));
        FileAnswerVO vo = (FileAnswerVO)BeanMapper.map((Object)((Object)entity), FileAnswerVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FileAnswerVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FileAnswerVO vo : vos) {
                if (vo.getId() >= 10L) continue;
                return CommonResponse.error((String)"\u4e0d\u652f\u6301\u5220\u9664\u6839\u8282\u70b9\uff01");
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FileAnswerVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("content");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("pid", new Parameter("eq", null));
        param.getOrderMap().put("secCode", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), FileAnswerVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            for (FileAnswerVO record : records) {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("pid", new Parameter("eq", (Object)record.getId()));
                queryParam.getOrderMap().put("secCode", "asc");
                List list = this.service.queryList(queryParam, false);
                record.setChildren(BeanMapper.mapList((Iterable)list, FileAnswerVO.class));
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileAnswer-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFileAnswerData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FileAnswerVO>> refFileAnswerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("content");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("pid", new Parameter("eq", null));
        param.getOrderMap().put("secCode", "asc");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), FileAnswerVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            for (FileAnswerVO record : records) {
                QueryParam queryParam = new QueryParam();
                queryParam.getOrderMap().put("secCode", "asc");
                queryParam.getParams().put("pid", new Parameter("eq", (Object)record.getId()));
                List list = this.service.queryList(queryParam, false);
                record.setChildren(BeanMapper.mapList((Iterable)list, FileAnswerVO.class));
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/enabled"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> enabled(@RequestParam Long id, @RequestParam Boolean enabled) {
        FileAnswerEntity entity = (FileAnswerEntity)((Object)this.service.selectById(id));
        entity.setEnabled(enabled);
        this.service.saveOrUpdate((Object)entity, false);
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("eq", (Object)id));
        List list = this.service.queryList(param, false);
        if (ListUtil.isNotEmpty((List)list)) {
            for (FileAnswerEntity entity1 : list) {
                entity1.setEnabled(enabled);
            }
            this.service.saveOrUpdateBatch(list);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

