package com.ejianc.business.procurement.perform.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.procurement.perform.bean.FeeReductionDetailEntity;
/**
 * 供应商费用减免申请表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_procurement_fee_reduction")
public class FeeReductionEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="should_pay_mny")
    private BigDecimal shouldPayMny; // 应交总额
    @TableField(value="reduction_mny")
    private BigDecimal reductionMny; // 减免总额
    @TableField(value="last_pay_mny")
    private BigDecimal lastPayMny; // 最终缴纳金额
    @TableField(value="make_date")
    private Date makeDate; // 编制日期
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_name")
    private String orgName; // 采购实施单位名称
    @TableField(value="org_code")
    private String orgCode; // 采购实施单位编码
    @TableField(value="all_org_name")
    private String allOrgName; // 所属组织(所属单位-项目经理部)
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="name")
    private String name; // 计划分配名称
    @TableField(value="purchase_project_name")
    private String purchaseProjectName; // 采购项目名称
    @TableField(value="purchase_project_code")
    private String purchaseProjectCode; // 采购项目编码
    @TableField(value="business_type")
    private String businessType; // 标的物类别1-工程，2-货物，3-服务
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="grade_name")
    private String gradeName; // 供应商等级名称
    @TableField(value="soc_code")
    private String socCode; // 统一社会信用代码
    @TableField(value="legal_person")
    private String legalPerson; // 法人代表
    @TableField(value="legal_phone")
    private String legalPhone; // 联系电话
    @TableField(value="auth_phone")
    private String authPhone; // 授权人联系电话
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 采购实施单位Id
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="purchase_project_id")
    private Long purchaseProjectId; // 采购项目id
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="grade_id")
    private Long gradeId; // 供应商等级
    @TableField(value="auth_person")
    private Long authPerson; // 授权人id
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="feeReductionDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<FeeReductionDetailEntity> feeReductionDetailList = new ArrayList<>(); // 供应商费用减免申请表明细
    

    public BigDecimal getShouldPayMny() {
        return shouldPayMny;
    }

    public void setShouldPayMny(BigDecimal shouldPayMny) {
        this.shouldPayMny = shouldPayMny;
    }
    public BigDecimal getReductionMny() {
        return reductionMny;
    }

    public void setReductionMny(BigDecimal reductionMny) {
        this.reductionMny = reductionMny;
    }
    public BigDecimal getLastPayMny() {
        return lastPayMny;
    }

    public void setLastPayMny(BigDecimal lastPayMny) {
        this.lastPayMny = lastPayMny;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getAllOrgName() {
        return allOrgName;
    }

    public void setAllOrgName(String allOrgName) {
        this.allOrgName = allOrgName;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getPurchaseProjectName() {
        return purchaseProjectName;
    }

    public void setPurchaseProjectName(String purchaseProjectName) {
        this.purchaseProjectName = purchaseProjectName;
    }
    public String getPurchaseProjectCode() {
        return purchaseProjectCode;
    }

    public void setPurchaseProjectCode(String purchaseProjectCode) {
        this.purchaseProjectCode = purchaseProjectCode;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    public String getSocCode() {
        return socCode;
    }

    public void setSocCode(String socCode) {
        this.socCode = socCode;
    }
    public String getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }
    public String getLegalPhone() {
        return legalPhone;
    }

    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }
    public String getAuthPhone() {
        return authPhone;
    }

    public void setAuthPhone(String authPhone) {
        this.authPhone = authPhone;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Long getPurchaseProjectId() {
        return purchaseProjectId;
    }

    public void setPurchaseProjectId(Long purchaseProjectId) {
        this.purchaseProjectId = purchaseProjectId;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public Long getGradeId() {
        return gradeId;
    }

    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    public Long getAuthPerson() {
        return authPerson;
    }

    public void setAuthPerson(Long authPerson) {
        this.authPerson = authPerson;
    }
    
    public List<FeeReductionDetailEntity> getFeeReductionDetailList() {
        return feeReductionDetailList;
    }

    public void setFeeReductionDetailList(List<FeeReductionDetailEntity> feeReductionDetailList) {
        this.feeReductionDetailList = feeReductionDetailList;
    }
}
