package com.ejianc.business.procurement.perform.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.procurement.perform.bean.GradeBackEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 评委打分退回申请表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_procurement_grade_back")
public class GradeBackEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="bid_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bidDate; // 评标日期
    @TableField(value="bid_place")
    private String bidPlace; // 评标地点
    @TableField(value="business_type")
    private String businessType; // 业务类别1-工程，2-货物，3-服务
    @TableField(value="make_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate; // 编制日期
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="org_code")
    private String orgCode; // 采购实施单位名称
    @TableField(value="org_name")
    private String orgName; // 采购实施单位编码
    @TableField(value="org_id")
    private Long orgId; // 采购实施单位id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="gradeBackService")
    private List<GradeBackEntity> gradeBackList = new ArrayList<>(); // 评委打分退回申请表-详情
    

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Date getBidDate() {
        return bidDate;
    }

    public void setBidDate(Date bidDate) {
        this.bidDate = bidDate;
    }
    public String getBidPlace() {
        return bidPlace;
    }

    public void setBidPlace(String bidPlace) {
        this.bidPlace = bidPlace;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<GradeBackEntity> getGradeBackList() {
        return gradeBackList;
    }

    public void setGradeBackList(List<GradeBackEntity> gradeBackList) {
        this.gradeBackList = gradeBackList;
    }
}
