package com.ejianc.business.procurement.perform.controller;

import java.io.Serializable;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.procurement.perform.bean.FileAnswerEntity;
import com.ejianc.business.procurement.perform.service.IFileAnswerService;
import com.ejianc.business.procurement.perform.vo.FileAnswerVO;

/**
 * 应答文件审批档案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("fileAnswer")
public class FileAnswerController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IFileAnswerService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FileAnswerVO> saveOrUpdate(@RequestBody FileAnswerVO saveOrUpdateVO) {
    	FileAnswerEntity entity = BeanMapper.map(saveOrUpdateVO, FileAnswerEntity.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, entity.getPid()));
        List<FileAnswerEntity> list = service.queryList(queryParam, false);
    	if(entity.getId() == null || entity.getId() == 0){
            if(entity.getPid()>10L){
                return CommonResponse.error("不支持新增下级！");
            }
            entity.setSecCode(entity.getPid()+"."+(list.size()+1));
        }
        Integer score = 0;
        if(!list.isEmpty()){
            for (FileAnswerEntity entity1 : list) {
                if(!Objects.equals(entity1.getId(), entity.getPid())){
                    score += entity1.getScore();
                }
            }
        }
        score = score + entity.getScore();
        FileAnswerEntity parent = service.selectById(entity.getPid());
        if(score>parent.getScore()){
            parent.setScore( score);
        }
    	service.saveOrUpdate(entity, false);
    	service.saveOrUpdate(parent, false);
    	FileAnswerVO vo = BeanMapper.map(entity, FileAnswerVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FileAnswerVO> queryDetail(Long id) {
    	FileAnswerEntity entity = service.selectById(id);
    	FileAnswerVO vo = BeanMapper.map(entity, FileAnswerVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FileAnswerVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (FileAnswerVO vo : vos) {
                if(vo.getId() < 10){
                    return CommonResponse.error("不支持删除根节点！");
                }
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(FileAnswerVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FileAnswerVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("content");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("pid", new Parameter(QueryParam.EQ, null));
        param.getOrderMap().put("secCode", QueryParam.ASC);
        IPage<FileAnswerEntity> page = service.queryPage(param,false);
        IPage<FileAnswerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<FileAnswerVO> records = BeanMapper.mapList(page.getRecords(), FileAnswerVO.class);
  		if(ListUtil.isNotEmpty(records)){
            for (FileAnswerVO record : records) {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, record.getId()));
                queryParam.getOrderMap().put("secCode", QueryParam.ASC);
                List<FileAnswerEntity> list = service.queryList(queryParam, false);
                record.setChildren(BeanMapper.mapList(list, FileAnswerVO.class));
            }
        }
        pageData.setRecords(records);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<FileAnswerEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileAnswer-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refFileAnswerData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FileAnswerVO>> refFileAnswerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("content");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("pid", new Parameter(QueryParam.EQ, null));
        param.getOrderMap().put("secCode", QueryParam.ASC);
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FileAnswerEntity> page = service.queryPage(param,false);
        IPage<FileAnswerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<FileAnswerVO> records = BeanMapper.mapList(page.getRecords(), FileAnswerVO.class);
        if(ListUtil.isNotEmpty(records)){
            for (FileAnswerVO record : records) {
                QueryParam queryParam = new QueryParam();
                queryParam.getOrderMap().put("secCode", QueryParam.ASC);
                queryParam.getParams().put("pid", new Parameter(QueryParam.EQ, record.getId()));
                List<FileAnswerEntity> list = service.queryList(queryParam, false);
                record.setChildren(BeanMapper.mapList(list, FileAnswerVO.class));
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success("查询参照数据成功！",pageData);
     }

     /**
     * @Description 启停用
     * @Return void
     */
    @RequestMapping(value = "/enabled", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> enabled(@RequestParam Long id, @RequestParam Boolean enabled) {
        FileAnswerEntity entity = service.selectById(id);
        entity.setEnabled(enabled);
        service.saveOrUpdate( entity, false);
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter(QueryParam.EQ, id));
        List<FileAnswerEntity> list = service.queryList(param, false);
        if(ListUtil.isNotEmpty(list)){
            for (FileAnswerEntity entity1 : list) {
                entity1.setEnabled(enabled);
            }
            service.saveOrUpdateBatch(list);
        }
        return CommonResponse.success("操作成功！");
    }
}
