package com.ejianc.business.procurement.perform.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.procurement.perform.bean.ReviewAnnounceConfirmEntity;
/**
 * 采购前公示结果评审表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_procurement_review_announce")
public class ReviewAnnounceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="nobid_method")
    private Integer nobidMethod; // 非招标交易方式
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="make_date")
    private Date makeDate; // 编制日期
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="supplier_res_flag")
    private Integer supplierResFlag; // 是否存在其他潜在供应商响应
    @TableField(value="bid_method")
    private Integer bidMethod; // 评标办法
    @TableField(value="budget_tax_mny")
    private BigDecimal budgetTaxMny; // 采购预算
    @TableField(value="publish_type")
    private Integer publishType; // 采购公开程度：公开、邀请
    @TableField(value="plan_object")
    private String planObject; // 采购标的
    @TableField(value="purchase_type")
    private String purchaseType; // 采购方式：1-带量；2-入围；3-框架
    @TableField(value="execute_plan_name")
    private String executePlanName; // 执行计划名称
    @TableField(value="execute_plan_code")
    private String executePlanCode; // 执行计划编码
    @TableField(value="execute_plan_id")
    private Long executePlanId; // 执行计划
    @TableField(value="business_type")
    private String businessType; // 业务类别1-工程，2-货物，3-服务
    @TableField(value="organize_shape")
    private Integer organizeShape; // 采购组织形式1-自主采购,2-委托采购
    @TableField(value="permission_type")
    private Integer permissionType; // 实施权限1-一级集采，2-二级集采，3-所属单位，4-项目经理部
    @TableField(value="perform_way")
    private String performWay; // 采购实施方式1-招标，2-非招标
    @TableField(value="org_code")
    private String orgCode; // 采购实施单位编码
    @TableField(value="org_name")
    private String orgName; // 采购实施单位名称
    @TableField(value="org_id")
    private Long orgId; // 采购实施单位Id
    @TableField(value="purchase_project_name")
    private String purchaseProjectName; // 采购项目名称
    @TableField(value="purchase_project_code")
    private String purchaseProjectCode; // 采购项目编号
    @TableField(value="purchase_project_id")
    private Long purchaseProjectId; // 采购项目Id
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="reviewAnnounceConfirmService")
    private List<ReviewAnnounceConfirmEntity> reviewAnnounceConfirmList = new ArrayList<>(); // 采购前公示结果评审-审查清单
    

    public Integer getNobidMethod() {
        return nobidMethod;
    }

    public void setNobidMethod(Integer nobidMethod) {
        this.nobidMethod = nobidMethod;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public Integer getSupplierResFlag() {
        return supplierResFlag;
    }

    public void setSupplierResFlag(Integer supplierResFlag) {
        this.supplierResFlag = supplierResFlag;
    }

    public Integer getBidMethod() {
        return bidMethod;
    }

    public void setBidMethod(Integer bidMethod) {
        this.bidMethod = bidMethod;
    }
    public BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    public void setBudgetTaxMny(BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    public Integer getPublishType() {
        return publishType;
    }

    public void setPublishType(Integer publishType) {
        this.publishType = publishType;
    }
    public String getPlanObject() {
        return planObject;
    }

    public void setPlanObject(String planObject) {
        this.planObject = planObject;
    }
    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getExecutePlanName() {
        return executePlanName;
    }

    public void setExecutePlanName(String executePlanName) {
        this.executePlanName = executePlanName;
    }
    public String getExecutePlanCode() {
        return executePlanCode;
    }

    public void setExecutePlanCode(String executePlanCode) {
        this.executePlanCode = executePlanCode;
    }
    public Long getExecutePlanId() {
        return executePlanId;
    }

    public void setExecutePlanId(Long executePlanId) {
        this.executePlanId = executePlanId;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public Integer getOrganizeShape() {
        return organizeShape;
    }

    public void setOrganizeShape(Integer organizeShape) {
        this.organizeShape = organizeShape;
    }
    public Integer getPermissionType() {
        return permissionType;
    }

    public void setPermissionType(Integer permissionType) {
        this.permissionType = permissionType;
    }
    public String getPerformWay() {
        return performWay;
    }

    public void setPerformWay(String performWay) {
        this.performWay = performWay;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getPurchaseProjectName() {
        return purchaseProjectName;
    }

    public void setPurchaseProjectName(String purchaseProjectName) {
        this.purchaseProjectName = purchaseProjectName;
    }
    public String getPurchaseProjectCode() {
        return purchaseProjectCode;
    }

    public void setPurchaseProjectCode(String purchaseProjectCode) {
        this.purchaseProjectCode = purchaseProjectCode;
    }
    public Long getPurchaseProjectId() {
        return purchaseProjectId;
    }

    public void setPurchaseProjectId(Long purchaseProjectId) {
        this.purchaseProjectId = purchaseProjectId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<ReviewAnnounceConfirmEntity> getReviewAnnounceConfirmList() {
        return reviewAnnounceConfirmList;
    }

    public void setReviewAnnounceConfirmList(List<ReviewAnnounceConfirmEntity> reviewAnnounceConfirmList) {
        this.reviewAnnounceConfirmList = reviewAnnounceConfirmList;
    }
}
